/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.request;

import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.leshan.core.Destroyable;
import org.eclipse.leshan.core.californium.CoapResponseCallback;
import org.eclipse.leshan.core.link.LinkParser;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.node.codec.LwM2mDecoder;
import org.eclipse.leshan.core.node.codec.LwM2mEncoder;
import org.eclipse.leshan.core.observation.Observation;
import org.eclipse.leshan.core.observation.SingleObservation;
import org.eclipse.leshan.core.request.DownlinkRequest;
import org.eclipse.leshan.core.response.ErrorCallback;
import org.eclipse.leshan.core.response.LwM2mResponse;
import org.eclipse.leshan.core.response.ObserveCompositeResponse;
import org.eclipse.leshan.core.response.ObserveResponse;
import org.eclipse.leshan.core.response.ResponseCallback;
import org.eclipse.leshan.core.util.Validate;
import org.eclipse.leshan.server.californium.observation.ObservationServiceImpl;
import org.eclipse.leshan.server.californium.request.CoapRequestSender;
import org.eclipse.leshan.server.californium.request.RequestSender;
import org.eclipse.leshan.server.model.LwM2mModelProvider;
import org.eclipse.leshan.server.registration.Registration;
import org.eclipse.leshan.server.request.LowerLayerConfig;
import org.eclipse.leshan.server.request.LwM2mRequestSender;

public class CaliforniumLwM2mRequestSender
implements LwM2mRequestSender,
CoapRequestSender,
Destroyable {
    private final ObservationServiceImpl observationService;
    private final LwM2mModelProvider modelProvider;
    private final RequestSender sender;

    public CaliforniumLwM2mRequestSender(Endpoint secureEndpoint, Endpoint nonSecureEndpoint, ObservationServiceImpl observationService, LwM2mModelProvider modelProvider, LwM2mEncoder encoder, LwM2mDecoder decoder, LinkParser linkParser) {
        Validate.notNull((Object)observationService);
        Validate.notNull((Object)modelProvider);
        this.observationService = observationService;
        this.modelProvider = modelProvider;
        this.sender = new RequestSender(secureEndpoint, nonSecureEndpoint, encoder, decoder, linkParser);
    }

    public <T extends LwM2mResponse> T send(Registration destination, DownlinkRequest<T> request, LowerLayerConfig lowerLayerConfig, long timeoutInMs) throws InterruptedException {
        LwM2mModel model = this.modelProvider.getObjectModel(destination);
        T response = this.sender.sendLwm2mRequest(destination.getEndpoint(), destination.getIdentity(), destination.getId(), model, destination.getRootPath(), request, lowerLayerConfig, timeoutInMs, destination.canInitiateConnection());
        if (response != null && response.isSuccess()) {
            SingleObservation observation = null;
            if (response instanceof ObserveResponse) {
                observation = ((ObserveResponse)response).getObservation();
            } else if (response instanceof ObserveCompositeResponse) {
                observation = ((ObserveCompositeResponse)response).getObservation();
            }
            if (observation != null) {
                this.observationService.addObservation(destination, (Observation)observation);
            }
        }
        return response;
    }

    public <T extends LwM2mResponse> void send(final Registration destination, DownlinkRequest<T> request, LowerLayerConfig lowerLayerConfig, long timeoutInMs, final ResponseCallback<T> responseCallback, ErrorCallback errorCallback) {
        LwM2mModel model = this.modelProvider.getObjectModel(destination);
        this.sender.sendLwm2mRequest(destination.getEndpoint(), destination.getIdentity(), destination.getId(), model, destination.getRootPath(), request, lowerLayerConfig, timeoutInMs, new ResponseCallback<T>(){

            public void onResponse(T response) {
                if (response != null && response.getClass() == ObserveResponse.class && response.isSuccess()) {
                    CaliforniumLwM2mRequestSender.this.observationService.addObservation(destination, (Observation)((ObserveResponse)response).getObservation());
                }
                responseCallback.onResponse(response);
            }
        }, errorCallback, destination.canInitiateConnection());
    }

    @Override
    public Response sendCoapRequest(Registration destination, Request coapRequest, long timeoutInMs) throws InterruptedException {
        return this.sender.sendCoapRequest(destination.getIdentity(), destination.getId(), coapRequest, timeoutInMs, destination.canInitiateConnection());
    }

    @Override
    public void sendCoapRequest(Registration destination, Request coapRequest, long timeoutInMs, CoapResponseCallback responseCallback, ErrorCallback errorCallback) {
        this.sender.sendCoapRequest(destination.getIdentity(), destination.getId(), coapRequest, timeoutInMs, responseCallback, errorCallback, destination.canInitiateConnection());
    }

    public void cancelOngoingRequests(Registration registration) {
        Validate.notNull((Object)registration);
        this.sender.cancelRequests(registration.getId());
    }

    public void destroy() {
        this.sender.destroy();
    }
}

