/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.bootstrap;

import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.leshan.core.Destroyable;
import org.eclipse.leshan.core.link.LinkParser;
import org.eclipse.leshan.core.node.codec.LwM2mDecoder;
import org.eclipse.leshan.core.node.codec.LwM2mEncoder;
import org.eclipse.leshan.core.request.DownlinkRequest;
import org.eclipse.leshan.core.response.ErrorCallback;
import org.eclipse.leshan.core.response.LwM2mResponse;
import org.eclipse.leshan.core.response.ResponseCallback;
import org.eclipse.leshan.server.bootstrap.BootstrapSession;
import org.eclipse.leshan.server.bootstrap.LwM2mBootstrapRequestSender;
import org.eclipse.leshan.server.californium.request.RequestSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaliforniumLwM2mBootstrapRequestSender
implements LwM2mBootstrapRequestSender,
Destroyable {
    static final Logger LOG = LoggerFactory.getLogger(CaliforniumLwM2mBootstrapRequestSender.class);
    private final RequestSender sender;

    public CaliforniumLwM2mBootstrapRequestSender(Endpoint secureEndpoint, Endpoint nonSecureEndpoint, LwM2mEncoder encoder, LwM2mDecoder decoder, LinkParser linkParser) {
        this.sender = new RequestSender(secureEndpoint, nonSecureEndpoint, encoder, decoder, linkParser);
    }

    public <T extends LwM2mResponse> T send(BootstrapSession destination, DownlinkRequest<T> request, long timeoutInMs) throws InterruptedException {
        return this.sender.sendLwm2mRequest(destination.getEndpoint(), destination.getIdentity(), destination.getId(), destination.getModel(), null, request, null, timeoutInMs, false);
    }

    public <T extends LwM2mResponse> void send(BootstrapSession destination, DownlinkRequest<T> request, long timeoutInMs, ResponseCallback<T> responseCallback, ErrorCallback errorCallback) {
        this.sender.sendLwm2mRequest(destination.getEndpoint(), destination.getIdentity(), destination.getId(), destination.getModel(), null, request, null, timeoutInMs, responseCallback, errorCallback, false);
    }

    public void cancelOngoingRequests(BootstrapSession session) {
        this.sender.cancelRequests(session.getId());
    }

    public void destroy() {
        this.sender.destroy();
    }
}

