/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium;

import java.net.InetSocketAddress;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.observe.ObservationStore;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.SystemConfig;
import org.eclipse.californium.elements.config.UdpConfig;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.dtls.x509.CertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.SingleCertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.StaticNewAdvancedCertificateVerifier;
import org.eclipse.leshan.core.californium.DefaultEndpointFactory;
import org.eclipse.leshan.core.californium.EndpointFactory;
import org.eclipse.leshan.core.link.DefaultLinkParser;
import org.eclipse.leshan.core.link.LinkParser;
import org.eclipse.leshan.core.node.codec.DefaultLwM2mDecoder;
import org.eclipse.leshan.core.node.codec.DefaultLwM2mEncoder;
import org.eclipse.leshan.core.node.codec.LwM2mDecoder;
import org.eclipse.leshan.core.node.codec.LwM2mEncoder;
import org.eclipse.leshan.server.californium.LeshanServer;
import org.eclipse.leshan.server.californium.LwM2mPskStore;
import org.eclipse.leshan.server.californium.registration.CaliforniumRegistrationStore;
import org.eclipse.leshan.server.californium.registration.InMemoryRegistrationStore;
import org.eclipse.leshan.server.model.LwM2mModelProvider;
import org.eclipse.leshan.server.model.StandardModelProvider;
import org.eclipse.leshan.server.queue.ClientAwakeTimeProvider;
import org.eclipse.leshan.server.queue.StaticClientAwakeTimeProvider;
import org.eclipse.leshan.server.registration.RandomStringRegistrationIdProvider;
import org.eclipse.leshan.server.registration.RegistrationIdProvider;
import org.eclipse.leshan.server.security.Authorizer;
import org.eclipse.leshan.server.security.DefaultAuthorizer;
import org.eclipse.leshan.server.security.SecurityStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeshanServerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(LeshanServerBuilder.class);
    private CaliforniumRegistrationStore registrationStore;
    private SecurityStore securityStore;
    private LwM2mModelProvider modelProvider;
    private Authorizer authorizer;
    private ClientAwakeTimeProvider awakeTimeProvider;
    private RegistrationIdProvider registrationIdProvider;
    private InetSocketAddress localAddress;
    private InetSocketAddress localSecureAddress;
    private LwM2mEncoder encoder;
    private LwM2mDecoder decoder;
    private PublicKey publicKey;
    private PrivateKey privateKey;
    private X509Certificate[] certificateChain;
    private Certificate[] trustedCertificates;
    private Configuration coapConfig;
    private DtlsConnectorConfig.Builder dtlsConfigBuilder;
    private EndpointFactory endpointFactory;
    private boolean noSecuredEndpoint;
    private boolean noUnsecuredEndpoint;
    private boolean noQueueMode = false;
    protected boolean updateRegistrationOnNotification;
    private LinkParser linkParser;

    public LeshanServerBuilder setLocalAddress(String hostname, int port) {
        this.localAddress = hostname == null ? new InetSocketAddress(port) : new InetSocketAddress(hostname, port);
        return this;
    }

    public LeshanServerBuilder setLocalAddress(InetSocketAddress localAddress) {
        this.localAddress = localAddress;
        return this;
    }

    public LeshanServerBuilder setLocalSecureAddress(String hostname, int port) {
        this.localSecureAddress = hostname == null ? new InetSocketAddress(port) : new InetSocketAddress(hostname, port);
        return this;
    }

    public LeshanServerBuilder setLocalSecureAddress(InetSocketAddress localSecureAddress) {
        this.localSecureAddress = localSecureAddress;
        return this;
    }

    public LeshanServerBuilder setRegistrationStore(CaliforniumRegistrationStore registrationStore) {
        this.registrationStore = registrationStore;
        return this;
    }

    public LeshanServerBuilder setSecurityStore(SecurityStore securityStore) {
        this.securityStore = securityStore;
        return this;
    }

    public LeshanServerBuilder setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
        return this;
    }

    public LeshanServerBuilder setObjectModelProvider(LwM2mModelProvider objectModelProvider) {
        this.modelProvider = objectModelProvider;
        return this;
    }

    public LeshanServerBuilder setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public LeshanServerBuilder setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public <T extends X509Certificate> LeshanServerBuilder setCertificateChain(T[] certificateChain) {
        this.certificateChain = certificateChain;
        return this;
    }

    public <T extends Certificate> LeshanServerBuilder setTrustedCertificates(T[] trustedCertificates) {
        this.trustedCertificates = trustedCertificates;
        return this;
    }

    public LeshanServerBuilder setEncoder(LwM2mEncoder encoder) {
        this.encoder = encoder;
        return this;
    }

    public LeshanServerBuilder setDecoder(LwM2mDecoder decoder) {
        this.decoder = decoder;
        return this;
    }

    public void setLinkParser(LinkParser linkParser) {
        this.linkParser = linkParser;
    }

    public LeshanServerBuilder setCoapConfig(Configuration config) {
        this.coapConfig = config;
        return this;
    }

    public LeshanServerBuilder setDtlsConfig(DtlsConnectorConfig.Builder config) {
        this.dtlsConfigBuilder = config;
        return this;
    }

    public LeshanServerBuilder setEndpointFactory(EndpointFactory endpointFactory) {
        this.endpointFactory = endpointFactory;
        return this;
    }

    public LeshanServerBuilder disableUnsecuredEndpoint() {
        this.noUnsecuredEndpoint = true;
        return this;
    }

    public LeshanServerBuilder disableSecuredEndpoint() {
        this.noSecuredEndpoint = true;
        return this;
    }

    public LeshanServerBuilder disableQueueModeSupport() {
        this.noQueueMode = true;
        return this;
    }

    public LeshanServerBuilder setClientAwakeTimeProvider(ClientAwakeTimeProvider awakeTimeProvider) {
        this.awakeTimeProvider = awakeTimeProvider;
        return this;
    }

    public void setRegistrationIdProvider(RegistrationIdProvider registrationIdProvider) {
        this.registrationIdProvider = registrationIdProvider;
    }

    public LeshanServerBuilder setUpdateRegistrationOnNotification(boolean updateRegistrationOnNotification) {
        this.updateRegistrationOnNotification = updateRegistrationOnNotification;
        return this;
    }

    public static Configuration createDefaultCoapConfiguration() {
        Configuration networkConfig = new Configuration(new Configuration.ModuleDefinitionsProvider[]{CoapConfig.DEFINITIONS, DtlsConfig.DEFINITIONS, UdpConfig.DEFINITIONS, SystemConfig.DEFINITIONS});
        networkConfig.set((BasicDefinition)CoapConfig.MID_TRACKER, (Object)CoapConfig.TrackerMode.NULL);
        networkConfig.set((BasicDefinition)DtlsConfig.DTLS_DEFAULT_HANDSHAKE_MODE, (Object)"none");
        networkConfig.set((BasicDefinition)DtlsConfig.DTLS_ROLE, (Object)DtlsConfig.DtlsRole.BOTH);
        return networkConfig;
    }

    public LeshanServer build() {
        if (this.localAddress == null) {
            this.localAddress = new InetSocketAddress(5683);
        }
        if (this.registrationStore == null) {
            this.registrationStore = new InMemoryRegistrationStore();
        }
        if (this.authorizer == null) {
            this.authorizer = new DefaultAuthorizer(this.securityStore);
        }
        if (this.modelProvider == null) {
            this.modelProvider = new StandardModelProvider();
        }
        if (this.encoder == null) {
            this.encoder = new DefaultLwM2mEncoder();
        }
        if (this.decoder == null) {
            this.decoder = new DefaultLwM2mDecoder();
        }
        if (this.linkParser == null) {
            this.linkParser = new DefaultLinkParser();
        }
        if (this.coapConfig == null) {
            this.coapConfig = LeshanServerBuilder.createDefaultCoapConfiguration();
        }
        if (this.awakeTimeProvider == null) {
            int maxTransmitWait = this.coapConfig.getTimeAsInt(CoapConfig.MAX_TRANSMIT_WAIT, TimeUnit.MILLISECONDS);
            if (maxTransmitWait == 0) {
                LOG.warn("No value available for MAX_TRANSMIT_WAIT in CoAP NetworkConfig. Fallback with a default 93s value.");
                this.awakeTimeProvider = new StaticClientAwakeTimeProvider();
            } else {
                this.awakeTimeProvider = new StaticClientAwakeTimeProvider(maxTransmitWait);
            }
        }
        if (this.registrationIdProvider == null) {
            this.registrationIdProvider = new RandomStringRegistrationIdProvider();
        }
        if (this.endpointFactory == null) {
            this.endpointFactory = new DefaultEndpointFactory("LWM2M Server", false);
        }
        DtlsConnectorConfig dtlsConfig = null;
        if (!this.noSecuredEndpoint && this.shouldTryToCreateSecureEndpoint()) {
            DtlsConnectorConfig incompleteConfig;
            if (this.dtlsConfigBuilder == null) {
                this.dtlsConfigBuilder = DtlsConnectorConfig.builder((Configuration)this.coapConfig);
            }
            if ((incompleteConfig = this.dtlsConfigBuilder.getIncompleteConfig()).getAdvancedPskStore() != null) {
                LOG.warn("PskStore should be automatically set by Leshan. Using a custom implementation is not advised.");
            } else if (this.securityStore != null) {
                this.dtlsConfigBuilder.setAdvancedPskStore((AdvancedPskStore)new LwM2mPskStore(this.securityStore, this.registrationStore));
            }
            if (incompleteConfig.getAddress() == null) {
                if (this.localSecureAddress == null) {
                    this.localSecureAddress = new InetSocketAddress(5684);
                }
                this.dtlsConfigBuilder.setAddress(this.localSecureAddress);
            } else if (this.localSecureAddress != null && !this.localSecureAddress.equals(incompleteConfig.getAddress())) {
                throw new IllegalStateException(String.format("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder for secure address: %s != %s", this.localSecureAddress, incompleteConfig.getAddress()));
            }
            if (incompleteConfig.getCertificateIdentityProvider() != null) {
                if (this.privateKey != null) {
                    throw new IllegalStateException(String.format("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder for private key", new Object[0]));
                }
                if (this.publicKey != null) {
                    throw new IllegalStateException(String.format("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder for public key", new Object[0]));
                }
                if (this.certificateChain != null) {
                    throw new IllegalStateException(String.format("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder for certificate chain", new Object[0]));
                }
            } else if (this.privateKey != null) {
                if (this.certificateChain == null && this.publicKey != null) {
                    this.dtlsConfigBuilder.setCertificateIdentityProvider((CertificateProvider)new SingleCertificateProvider(this.privateKey, this.publicKey));
                }
                if (this.certificateChain != null && this.certificateChain.length > 0) {
                    this.dtlsConfigBuilder.setCertificateIdentityProvider((CertificateProvider)new SingleCertificateProvider(this.privateKey, (Certificate[])this.certificateChain, new CertificateType[]{CertificateType.X_509, CertificateType.RAW_PUBLIC_KEY}));
                }
            }
            if (incompleteConfig.getAdvancedCertificateVerifier() != null) {
                if (this.trustedCertificates != null) {
                    throw new IllegalStateException("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder: if a AdvancedCertificateVerifier is set, trustedCertificates must not be set.");
                }
            } else if (incompleteConfig.getCertificateIdentityProvider() != null) {
                StaticNewAdvancedCertificateVerifier.Builder verifierBuilder = StaticNewAdvancedCertificateVerifier.builder();
                verifierBuilder.setTrustAllRPKs();
                if (this.trustedCertificates != null) {
                    verifierBuilder.setTrustedCertificates(this.trustedCertificates);
                }
                this.dtlsConfigBuilder.setAdvancedCertificateVerifier(verifierBuilder.build());
            }
            try {
                dtlsConfig = this.dtlsConfigBuilder.build();
            }
            catch (IllegalStateException e) {
                LOG.warn("Unable to create DTLS config and so secured endpoint.", (Throwable)e);
            }
        }
        CoapEndpoint unsecuredEndpoint = null;
        if (!this.noUnsecuredEndpoint) {
            unsecuredEndpoint = this.endpointFactory.createUnsecuredEndpoint(this.localAddress, this.coapConfig, (ObservationStore)this.registrationStore);
        }
        CoapEndpoint securedEndpoint = null;
        if (!this.noSecuredEndpoint && dtlsConfig != null) {
            securedEndpoint = this.endpointFactory.createSecuredEndpoint(dtlsConfig, this.coapConfig, (ObservationStore)this.registrationStore);
        }
        if (securedEndpoint == null && unsecuredEndpoint == null) {
            throw new IllegalStateException("All CoAP enpoints are deactivated, at least one endpoint should be activated");
        }
        return this.createServer(unsecuredEndpoint, securedEndpoint, this.registrationStore, this.securityStore, this.authorizer, this.modelProvider, this.encoder, this.decoder, this.coapConfig, this.noQueueMode, this.awakeTimeProvider, this.registrationIdProvider, this.linkParser);
    }

    protected boolean shouldTryToCreateSecureEndpoint() {
        return this.dtlsConfigBuilder != null || this.certificateChain != null || this.privateKey != null || this.publicKey != null || this.securityStore != null || this.trustedCertificates != null;
    }

    protected LeshanServer createServer(CoapEndpoint unsecuredEndpoint, CoapEndpoint securedEndpoint, CaliforniumRegistrationStore registrationStore, SecurityStore securityStore, Authorizer authorizer, LwM2mModelProvider modelProvider, LwM2mEncoder encoder, LwM2mDecoder decoder, Configuration coapConfig, boolean noQueueMode, ClientAwakeTimeProvider awakeTimeProvider, RegistrationIdProvider registrationIdProvider, LinkParser linkParser) {
        return new LeshanServer(unsecuredEndpoint, securedEndpoint, registrationStore, securityStore, authorizer, modelProvider, encoder, decoder, coapConfig, noQueueMode, awakeTimeProvider, registrationIdProvider, this.updateRegistrationOnNotification, linkParser);
    }
}

