/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch.removaltime;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.impl.batch.AbstractBatchJobHandler;
import org.camunda.bpm.engine.impl.batch.BatchJobContext;
import org.camunda.bpm.engine.impl.batch.BatchJobDeclaration;
import org.camunda.bpm.engine.impl.batch.removaltime.ProcessSetRemovalTimeResultHandler;
import org.camunda.bpm.engine.impl.batch.removaltime.SetRemovalTimeBatchConfiguration;
import org.camunda.bpm.engine.impl.batch.removaltime.SetRemovalTimeJsonConverter;
import org.camunda.bpm.engine.impl.cfg.TransactionListener;
import org.camunda.bpm.engine.impl.cfg.TransactionState;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class ProcessSetRemovalTimeJobHandler
extends AbstractBatchJobHandler<SetRemovalTimeBatchConfiguration> {
    public static final BatchJobDeclaration JOB_DECLARATION = new BatchJobDeclaration("process-set-removal-time");
    public static final int MAX_CHUNK_SIZE = 500;

    @Override
    public void executeHandler(SetRemovalTimeBatchConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        if (configuration.isUpdateInChunks()) {
            String instanceId = configuration.getIds().get(0);
            Set<String> entities = configuration.getEntities();
            Integer chunkSize = this.getUpdateChunkSize(configuration, commandContext);
            Map<Class<? extends DbEntity>, DbOperation> operations = this.addRemovalTimeToInstance(instanceId, configuration, chunkSize, entities, commandContext);
            MessageEntity currentJob = (MessageEntity)commandContext.getCurrentJob();
            this.registerTransactionHandler(configuration, operations, chunkSize, currentJob, commandContext);
            currentJob.setRepeat("true");
        } else {
            configuration.getIds().forEach(id -> this.addRemovalTimeToInstance((String)id, configuration, null, Collections.emptySet(), commandContext));
        }
    }

    protected Map<Class<? extends DbEntity>, DbOperation> addRemovalTimeToInstance(String instanceId, SetRemovalTimeBatchConfiguration configuration, Integer batchSize, Set<String> entities, CommandContext commandContext) {
        HistoricProcessInstanceEntity instance = this.findProcessInstanceById(instanceId, commandContext);
        if (instance != null) {
            if (configuration.isHierarchical() && this.hasHierarchy(instance)) {
                String rootProcessInstanceId = instance.getRootProcessInstanceId();
                HistoricProcessInstanceEntity rootInstance = this.findProcessInstanceById(rootProcessInstanceId, commandContext);
                Date removalTime = this.getOrCalculateRemovalTime(configuration, rootInstance, commandContext);
                return this.addRemovalTimeToHierarchy(rootProcessInstanceId, removalTime, batchSize, entities, commandContext);
            }
            Date removalTime = this.getOrCalculateRemovalTime(configuration, instance, commandContext);
            if (removalTime != instance.getRemovalTime()) {
                return this.addRemovalTime(instanceId, removalTime, batchSize, entities, commandContext);
            }
        }
        return null;
    }

    protected Date getOrCalculateRemovalTime(SetRemovalTimeBatchConfiguration configuration, HistoricProcessInstanceEntity instance, CommandContext commandContext) {
        if (configuration.hasRemovalTime()) {
            return configuration.getRemovalTime();
        }
        if (this.hasBaseTime(instance, commandContext)) {
            return this.calculateRemovalTime(instance, commandContext);
        }
        return null;
    }

    protected Map<Class<? extends DbEntity>, DbOperation> addRemovalTimeToHierarchy(String rootProcessInstanceId, Date removalTime, Integer batchSize, Set<String> entities, CommandContext commandContext) {
        Map<Class<? extends DbEntity>, DbOperation> operations = commandContext.getHistoricProcessInstanceManager().addRemovalTimeToProcessInstancesByRootProcessInstanceId(rootProcessInstanceId, removalTime, batchSize, entities);
        if (this.isDmnEnabled(commandContext)) {
            operations.putAll(commandContext.getHistoricDecisionInstanceManager().addRemovalTimeToDecisionsByRootProcessInstanceId(rootProcessInstanceId, removalTime, batchSize, entities));
        }
        return operations;
    }

    protected Map<Class<? extends DbEntity>, DbOperation> addRemovalTime(String instanceId, Date removalTime, Integer batchSize, Set<String> entities, CommandContext commandContext) {
        Map<Class<? extends DbEntity>, DbOperation> operations = commandContext.getHistoricProcessInstanceManager().addRemovalTimeById(instanceId, removalTime, batchSize, entities);
        if (this.isDmnEnabled(commandContext)) {
            operations.putAll(commandContext.getHistoricDecisionInstanceManager().addRemovalTimeToDecisionsByProcessInstanceId(instanceId, removalTime, batchSize, entities));
        }
        return operations;
    }

    protected boolean hasBaseTime(HistoricProcessInstanceEntity instance, CommandContext commandContext) {
        return this.isStrategyStart(commandContext) || this.isStrategyEnd(commandContext) && this.isEnded(instance);
    }

    protected boolean isEnded(HistoricProcessInstanceEntity instance) {
        return instance.getEndTime() != null;
    }

    protected boolean isStrategyStart(CommandContext commandContext) {
        return "start".equals(this.getHistoryRemovalTimeStrategy(commandContext));
    }

    protected boolean isStrategyEnd(CommandContext commandContext) {
        return "end".equals(this.getHistoryRemovalTimeStrategy(commandContext));
    }

    protected boolean hasHierarchy(HistoricProcessInstanceEntity instance) {
        return instance.getRootProcessInstanceId() != null;
    }

    protected String getHistoryRemovalTimeStrategy(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getHistoryRemovalTimeStrategy();
    }

    protected ProcessDefinition findProcessDefinitionById(String processDefinitionId, CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(processDefinitionId);
    }

    protected boolean isDmnEnabled(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().isDmnEnabled();
    }

    protected Date calculateRemovalTime(HistoricProcessInstanceEntity processInstance, CommandContext commandContext) {
        ProcessDefinition processDefinition = this.findProcessDefinitionById(processInstance.getProcessDefinitionId(), commandContext);
        return commandContext.getProcessEngineConfiguration().getHistoryRemovalTimeProvider().calculateRemovalTime(processInstance, processDefinition);
    }

    protected ByteArrayEntity findByteArrayById(String byteArrayId, CommandContext commandContext) {
        return commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, byteArrayId);
    }

    protected HistoricProcessInstanceEntity findProcessInstanceById(String instanceId, CommandContext commandContext) {
        return commandContext.getHistoricProcessInstanceManager().findHistoricProcessInstance(instanceId);
    }

    protected void registerTransactionHandler(SetRemovalTimeBatchConfiguration configuration, Map<Class<? extends DbEntity>, DbOperation> operations, Integer chunkSize, MessageEntity currentJob, CommandContext commandContext) {
        CommandExecutor newCommandExecutor = commandContext.getProcessEngineConfiguration().getCommandExecutorTxRequiresNew();
        TransactionListener transactionResulthandler = this.createTransactionHandler(configuration, operations, chunkSize, currentJob, newCommandExecutor);
        commandContext.getTransactionContext().addTransactionListener(TransactionState.COMMITTED, transactionResulthandler);
    }

    protected int getUpdateChunkSize(SetRemovalTimeBatchConfiguration configuration, CommandContext commandContext) {
        return configuration.getChunkSize() == null ? commandContext.getProcessEngineConfiguration().getRemovalTimeUpdateChunkSize() : configuration.getChunkSize().intValue();
    }

    protected TransactionListener createTransactionHandler(SetRemovalTimeBatchConfiguration configuration, Map<Class<? extends DbEntity>, DbOperation> operations, Integer chunkSize, MessageEntity currentJob, CommandExecutor newCommandExecutor) {
        return new ProcessSetRemovalTimeResultHandler(configuration, chunkSize, newCommandExecutor, this, currentJob.getId(), operations);
    }

    @Override
    public JobDeclaration<BatchJobContext, MessageEntity> getJobDeclaration() {
        return JOB_DECLARATION;
    }

    @Override
    protected SetRemovalTimeBatchConfiguration createJobConfiguration(SetRemovalTimeBatchConfiguration configuration, List<String> processInstanceIds) {
        return new SetRemovalTimeBatchConfiguration(processInstanceIds).setRemovalTime(configuration.getRemovalTime()).setHasRemovalTime(configuration.hasRemovalTime()).setHierarchical(configuration.isHierarchical()).setUpdateInChunks(configuration.isUpdateInChunks()).setChunkSize(configuration.getChunkSize());
    }

    protected SetRemovalTimeJsonConverter getJsonConverterInstance() {
        return SetRemovalTimeJsonConverter.INSTANCE;
    }

    @Override
    public int calculateInvocationsPerBatchJob(String batchType, SetRemovalTimeBatchConfiguration configuration) {
        if (configuration.isUpdateInChunks()) {
            return 1;
        }
        return super.calculateInvocationsPerBatchJob(batchType, configuration);
    }

    @Override
    public String getType() {
        return "process-set-removal-time";
    }
}

