/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.maven.runner;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.tomcat.maven.runner.PasswordUtil;
import org.apache.tomcat.maven.runner.Tomcat7Runner;

public class Tomcat7RunnerCli {
    public static final String STAND_ALONE_PROPERTIES_FILENAME = "tomcat.standalone.properties";
    static Option httpPort;
    static Option httpsPort;
    static Option ajpPort;
    static Option serverXmlPath;
    static Option resetExtract;
    static Option help;
    static Option debug;
    static Option sysProps;
    static Option clientAuth;
    static Option keyAlias;
    static Option obfuscate;
    static Option httpProtocol;
    static Option extractDirectory;
    static Option loggerName;
    static Option uriEncoding;
    static Options options;

    public static void main(String[] args) throws Exception {
        Properties systemProperties;
        String port;
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println("Parsing failed.  Reason: " + e.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(Tomcat7RunnerCli.getCmdLineSyntax(), options);
            System.exit(1);
        }
        if (line.hasOption(help.getOpt())) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(Tomcat7RunnerCli.getCmdLineSyntax(), options);
            System.exit(0);
        }
        if (line.hasOption(obfuscate.getOpt())) {
            System.out.println(PasswordUtil.obfuscate(line.getOptionValue(obfuscate.getOpt())));
            System.exit(0);
        }
        Tomcat7Runner tomcat7Runner = new Tomcat7Runner();
        tomcat7Runner.runtimeProperties = Tomcat7RunnerCli.buildStandaloneProperties();
        if (line.hasOption(serverXmlPath.getOpt())) {
            tomcat7Runner.serverXmlPath = line.getOptionValue(serverXmlPath.getOpt());
        }
        if ((port = tomcat7Runner.runtimeProperties.getProperty("httpPort")) != null) {
            tomcat7Runner.httpPort = Integer.parseInt(port);
        }
        if (line.hasOption(httpPort.getOpt())) {
            tomcat7Runner.httpPort = Integer.parseInt(line.getOptionValue(httpPort.getOpt()));
        }
        if (line.hasOption(httpsPort.getOpt())) {
            tomcat7Runner.httpsPort = Integer.parseInt(line.getOptionValue(httpsPort.getOpt()));
        }
        if (line.hasOption(ajpPort.getOpt())) {
            tomcat7Runner.ajpPort = Integer.parseInt(line.getOptionValue(ajpPort.getOpt()));
        }
        if (line.hasOption(resetExtract.getOpt())) {
            tomcat7Runner.resetExtract = true;
        }
        if (line.hasOption(debug.getOpt())) {
            tomcat7Runner.debug = true;
        }
        if (line.hasOption(httpProtocol.getOpt())) {
            tomcat7Runner.httpProtocol = line.getOptionValue(httpProtocol.getOpt());
        }
        if (line.hasOption(sysProps.getOpt()) && (systemProperties = line.getOptionProperties(sysProps.getOpt())) != null && !systemProperties.isEmpty()) {
            for (Map.Entry<Object, Object> sysProp : systemProperties.entrySet()) {
                System.setProperty((String)sysProp.getKey(), (String)sysProp.getValue());
            }
        }
        if (line.hasOption(clientAuth.getOpt())) {
            tomcat7Runner.clientAuth = clientAuth.getOpt();
        }
        if (line.hasOption(keyAlias.getOpt())) {
            tomcat7Runner.keyAlias = line.getOptionValue(keyAlias.getOpt());
        }
        if (line.hasOption(extractDirectory.getOpt())) {
            tomcat7Runner.extractDirectory = line.getOptionValue(extractDirectory.getOpt());
        }
        if (line.hasOption(loggerName.getOpt())) {
            tomcat7Runner.loggerName = line.getOptionValue(loggerName.getOpt());
        }
        if (line.hasOption(uriEncoding.getOpt())) {
            tomcat7Runner.uriEncoding = line.getOptionValue(uriEncoding.getOpt());
        }
        tomcat7Runner.run();
    }

    private static Properties buildStandaloneProperties() throws IOException {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(STAND_ALONE_PROPERTIES_FILENAME);
        Properties properties = new Properties();
        properties.load(is);
        return properties;
    }

    public static String getCmdLineSyntax() {
        return "java -jar [path to your exec war jar]";
    }

    static {
        OptionBuilder.withArgName((String)"httpPort");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"http port to use");
        httpPort = OptionBuilder.create((String)"httpPort");
        OptionBuilder.withArgName((String)"httpsPort");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"https port to use");
        httpsPort = OptionBuilder.create((String)"httpsPort");
        OptionBuilder.withArgName((String)"ajpPort");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"ajp port to use");
        ajpPort = OptionBuilder.create((String)"ajpPort");
        OptionBuilder.withArgName((String)"serverXmlPath");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"server.xml to use, optional");
        serverXmlPath = OptionBuilder.create((String)"serverXmlPath");
        OptionBuilder.withArgName((String)"resetExtract");
        OptionBuilder.withDescription((String)"clean previous extract directory");
        resetExtract = OptionBuilder.create((String)"resetExtract");
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"help");
        help = OptionBuilder.create((char)'h');
        OptionBuilder.withLongOpt((String)"debug");
        OptionBuilder.withDescription((String)"debug");
        debug = OptionBuilder.create((char)'X');
        OptionBuilder.withDescription((String)"use value for given property");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"key=value");
        OptionBuilder.withValueSeparator();
        sysProps = OptionBuilder.create((char)'D');
        OptionBuilder.withArgName((String)"clientAuth");
        OptionBuilder.withDescription((String)"enable client authentication for https");
        clientAuth = OptionBuilder.create((String)"clientAuth");
        OptionBuilder.withArgName((String)"keyAlias");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"alias from keystore for ssl");
        keyAlias = OptionBuilder.create((String)"keyAlias");
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"obfuscate the password and exit");
        obfuscate = OptionBuilder.create((String)"obfuscate");
        OptionBuilder.withArgName((String)"httpProtocol");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"http protocol to use: HTTP/1.1 or org.apache.coyote.http11.Http11NioProtocol");
        httpProtocol = OptionBuilder.create((String)"httpProtocol");
        OptionBuilder.withArgName((String)"extractDirectory");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"path to extract war content, default value: .extract");
        extractDirectory = OptionBuilder.create((String)"extractDirectory");
        OptionBuilder.withArgName((String)"loggerName");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"logger to use: slf4j to use slf4j bridge on top of jul");
        loggerName = OptionBuilder.create((String)"loggerName");
        OptionBuilder.withArgName((String)"uriEncoding");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"connector uriEncoding default ISO-8859-1");
        uriEncoding = OptionBuilder.create((String)"uriEncoding");
        options = new Options();
        options.addOption(httpPort).addOption(httpsPort).addOption(ajpPort).addOption(serverXmlPath).addOption(resetExtract).addOption(help).addOption(debug).addOption(sysProps).addOption(httpProtocol).addOption(clientAuth).addOption(keyAlias).addOption(obfuscate).addOption(extractDirectory).addOption(loggerName).addOption(uriEncoding);
    }
}

