/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.records.TezDAGID;

public class DAGRecoveredEvent
implements HistoryEvent {
    private final ApplicationAttemptId applicationAttemptId;
    private final TezDAGID dagID;
    private final long recoveredTime;
    private final DAGState recoveredDagState;
    private final String recoveryFailureReason;
    private final String dagName;
    private final String user;
    private boolean historyLoggingEnabled = true;
    private String containerLogs;

    public DAGRecoveredEvent(ApplicationAttemptId applicationAttemptId, TezDAGID dagId, String dagName, String user, long recoveredTime, DAGState recoveredState, String recoveryFailureReason, String containerLogs) {
        this.applicationAttemptId = applicationAttemptId;
        this.dagID = dagId;
        this.dagName = dagName;
        this.user = user;
        this.recoveredTime = recoveredTime;
        this.recoveredDagState = recoveredState;
        this.recoveryFailureReason = recoveryFailureReason;
        this.containerLogs = containerLogs;
    }

    public DAGRecoveredEvent(ApplicationAttemptId applicationAttemptId, TezDAGID dagId, String dagName, String user, long recoveredTime, String containerLogs) {
        this(applicationAttemptId, dagId, dagName, user, recoveredTime, null, null, containerLogs);
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.DAG_RECOVERED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return false;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException("Invalid operation for eventType " + this.getEventType().name());
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException("Invalid operation for eventType " + this.getEventType().name());
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.applicationAttemptId;
    }

    public TezDAGID getDagID() {
        return this.dagID;
    }

    public long getRecoveredTime() {
        return this.recoveredTime;
    }

    public DAGState getRecoveredDagState() {
        return this.recoveredDagState;
    }

    public String getRecoveryFailureReason() {
        return this.recoveryFailureReason;
    }

    public String getDagName() {
        return this.dagName;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isHistoryLoggingEnabled() {
        return this.historyLoggingEnabled;
    }

    public void setHistoryLoggingEnabled(boolean historyLoggingEnabled) {
        this.historyLoggingEnabled = historyLoggingEnabled;
    }

    public String getContainerLogs() {
        return this.containerLogs;
    }

    public String toString() {
        return "applicationAttemptId=" + (this.applicationAttemptId != null ? this.applicationAttemptId.toString() : "null") + ", dagId=" + (this.dagID != null ? this.dagID.toString() : "null") + ", recoveredTime=" + this.recoveredTime + ", recoveredState=" + (this.recoveredDagState != null ? this.recoveredDagState.name() : "null") + ", recoveryFailureReason=" + this.recoveryFailureReason;
    }
}

