/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tez.runtime.api.AbstractLogicalInput;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ProgressHelper.class);
    private static final float MIN_PROGRESS_VAL = 0.0f;
    private static final float MAX_PROGRESS_VAL = 1.0f;
    private final String processorName;
    protected final Map<String, LogicalInput> inputs;
    private final ProcessorContext processorContext;
    private final AtomicReference<ScheduledFuture<?>> periodicMonitorTaskRef = new AtomicReference<Object>(null);
    private long monitorExecPeriod;
    private volatile ScheduledExecutorService scheduledExecutorService;

    public static final float processProgress(float val) {
        return Float.isNaN(val) ? 0.0f : Math.max(0.0f, Math.min(1.0f, val));
    }

    public static final boolean isProgressWithinRange(float val) {
        return val <= 1.0f && val >= 0.0f;
    }

    public ProgressHelper(Map<String, LogicalInput> inputsParam, ProcessorContext context, String processorName) {
        this.inputs = inputsParam;
        this.processorContext = context;
        this.processorName = processorName;
    }

    public void scheduleProgressTaskService(long delay, long period) {
        this.monitorExecPeriod = period;
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("TaskProgressService{" + this.processorName + ":" + this.processorContext.getTaskVertexName() + "} #%d").build());
        try {
            this.createPeriodicTask(delay);
        }
        catch (IllegalArgumentException | RejectedExecutionException ex) {
            LOG.error("Could not create periodic scheduled task for processor={}", (Object)this.processorName, (Object)ex);
        }
    }

    private Runnable createRunnableMonitor() {
        return new Runnable(){

            @Override
            public void run() {
                block7: {
                    try {
                        float progSum = 0.0f;
                        int invalidInput = 0;
                        float progressVal = 0.0f;
                        if (ProgressHelper.this.inputs != null && !ProgressHelper.this.inputs.isEmpty()) {
                            for (LogicalInput input : ProgressHelper.this.inputs.values()) {
                                if (!(input instanceof AbstractLogicalInput)) continue;
                                float inputProgress = ((AbstractLogicalInput)input).getProgress();
                                if (!ProgressHelper.isProgressWithinRange(inputProgress)) {
                                    int invalidSnapshot = ++invalidInput;
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("progress update: Incorrect value in progress helper in processor={}, inputProgress={}, inputsSize={}, invalidInput={}", new Object[]{ProgressHelper.this.processorName, Float.valueOf(inputProgress), ProgressHelper.this.inputs.size(), invalidSnapshot});
                                    }
                                }
                                progSum += ProgressHelper.processProgress(inputProgress);
                            }
                            progressVal = progSum / (float)ProgressHelper.this.inputs.size();
                        }
                        ProgressHelper.this.processorContext.setProgress(progressVal);
                    }
                    catch (Throwable th) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("progress update: Encountered InterruptedException during Processor={}", (Object)ProgressHelper.this.processorName, (Object)th);
                        }
                        if (!(th instanceof InterruptedException)) break block7;
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
        };
    }

    private boolean createPeriodicTask(long delay) throws RejectedExecutionException, IllegalArgumentException {
        this.stopPeriodicMonitor();
        Runnable runnableMonitor = this.createRunnableMonitor();
        ScheduledFuture<?> futureTask = this.scheduledExecutorService.scheduleWithFixedDelay(runnableMonitor, delay, this.monitorExecPeriod, TimeUnit.MILLISECONDS);
        this.periodicMonitorTaskRef.set(futureTask);
        return true;
    }

    private void stopPeriodicMonitor() {
        ScheduledFuture<?> scheduledMonitorRes = this.periodicMonitorTaskRef.get();
        if (scheduledMonitorRes != null && !scheduledMonitorRes.isCancelled()) {
            scheduledMonitorRes.cancel(true);
            this.periodicMonitorTaskRef.set(null);
        }
    }

    public void shutDownProgressTaskService() {
        this.stopPeriodicMonitor();
        if (this.scheduledExecutorService != null) {
            block4: {
                this.scheduledExecutorService.shutdown();
                try {
                    if (!this.scheduledExecutorService.awaitTermination(this.monitorExecPeriod, TimeUnit.MILLISECONDS)) {
                        this.scheduledExecutorService.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug("Interrupted exception while shutting down the executor service for the processor name={}", (Object)this.processorName);
                }
            }
            this.scheduledExecutorService.shutdownNow();
        }
        this.scheduledExecutorService = null;
    }
}

