/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.util.install;

import java.io.File;
import java.util.ArrayList;
import org.apache.pluto.util.install.PortalInstaller;
import org.apache.pluto.util.install.file.jetty.Jetty5FileSystemInstaller;
import org.apache.pluto.util.install.file.tomcat5.Tomcat5FileSystemInstaller;
import org.apache.pluto.util.install.file.tomcat6.Tomcat6FileSystemInstaller;

public abstract class PortalInstallerFactory {
    private static final ArrayList HANDLERS = new ArrayList();

    public static PortalInstaller getAppServerHandler(File installDir) {
        String className = System.getProperty(PortalInstallerFactory.class.getName());
        PortalInstaller installer = null;
        installer = className != null ? PortalInstallerFactory.getHandler(className, installDir) : PortalInstallerFactory.findHandler(installDir);
        return installer;
    }

    private static PortalInstaller getHandler(String className, File installDir) {
        try {
            Class<?> cl = Class.forName(className);
            PortalInstaller ash = (PortalInstaller)cl.newInstance();
            if (ash.isValidInstallationDirectory(installDir)) {
                return ash;
            }
            throw new Exception("Invalid installation directory for handler: " + className);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate class: " + className, e);
        }
    }

    private static PortalInstaller findHandler(File installDir) {
        for (PortalInstaller ash : HANDLERS) {
            if (!ash.isValidInstallationDirectory(installDir)) continue;
            return ash;
        }
        throw new RuntimeException("Unable to locate appropriate app server handler for: " + installDir.getAbsolutePath());
    }

    static {
        HANDLERS.add(new Tomcat6FileSystemInstaller());
        HANDLERS.add(new Tomcat5FileSystemInstaller());
        HANDLERS.add(new Jetty5FileSystemInstaller());
    }
}

