/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.util.assemble.ear;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.pluto.util.assemble.ear.AssemblySink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ByteArrayAssemblySink
extends AssemblySink {
    private static final Logger LOG = LoggerFactory.getLogger(ByteArrayAssemblySink.class);

    ByteArrayAssemblySink(ByteArrayOutputStream out) {
        super(out);
    }

    ByteArrayAssemblySink(ByteArrayOutputStream out, int buflen) {
        this.out = new ByteArrayOutputStream(buflen);
    }

    public void writeTo(OutputStream out, int buflen) throws IOException {
        byte[] buf = new byte[buflen];
        int read = 0;
        BufferedInputStream sinkReader = new BufferedInputStream(new ByteArrayInputStream(((ByteArrayOutputStream)this.out).toByteArray()), buflen);
        while ((read = ((InputStream)sinkReader).read(buf)) != -1) {
            out.write(buf, 0, read);
        }
    }
}

