/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.errors.InvalidMetadataException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.utils.Utils;

public class MetadataResponse
extends AbstractResponse {
    private static final String BROKERS_KEY_NAME = "brokers";
    private static final String TOPIC_METADATA_KEY_NAME = "topic_metadata";
    private static final String NODE_ID_KEY_NAME = "node_id";
    private static final String HOST_KEY_NAME = "host";
    private static final String PORT_KEY_NAME = "port";
    private static final String RACK_KEY_NAME = "rack";
    private static final String CONTROLLER_ID_KEY_NAME = "controller_id";
    public static final int NO_CONTROLLER_ID = -1;
    private static final String CLUSTER_ID_KEY_NAME = "cluster_id";
    private static final String TOPIC_ERROR_CODE_KEY_NAME = "topic_error_code";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String IS_INTERNAL_KEY_NAME = "is_internal";
    private static final String PARTITION_METADATA_KEY_NAME = "partition_metadata";
    private static final String PARTITION_ERROR_CODE_KEY_NAME = "partition_error_code";
    private static final String PARTITION_KEY_NAME = "partition_id";
    private static final String LEADER_KEY_NAME = "leader";
    private static final String REPLICAS_KEY_NAME = "replicas";
    private static final String ISR_KEY_NAME = "isr";
    private final int throttleTimeMs;
    private final Collection<Node> brokers;
    private final Node controller;
    private final List<TopicMetadata> topicMetadata;
    private final String clusterId;

    public MetadataResponse(List<Node> brokers, String clusterId, int controllerId, List<TopicMetadata> topicMetadata) {
        this(0, brokers, clusterId, controllerId, topicMetadata);
    }

    public MetadataResponse(int throttleTimeMs, List<Node> brokers, String clusterId, int controllerId, List<TopicMetadata> topicMetadata) {
        this.throttleTimeMs = throttleTimeMs;
        this.brokers = brokers;
        this.controller = this.getControllerNode(controllerId, brokers);
        this.topicMetadata = topicMetadata;
        this.clusterId = clusterId;
    }

    public MetadataResponse(Struct struct) {
        Object[] topicInfos;
        Object[] brokerStructs;
        this.throttleTimeMs = struct.hasField("throttle_time_ms") ? struct.getInt("throttle_time_ms") : 0;
        HashMap<Integer, Node> brokers = new HashMap<Integer, Node>();
        for (Object brokerStruct : brokerStructs = (Object[])struct.get(BROKERS_KEY_NAME)) {
            Struct broker = (Struct)brokerStruct;
            int nodeId = broker.getInt(NODE_ID_KEY_NAME);
            String host = broker.getString(HOST_KEY_NAME);
            int port = broker.getInt(PORT_KEY_NAME);
            String rack = broker.hasField(RACK_KEY_NAME) ? broker.getString(RACK_KEY_NAME) : null;
            brokers.put(nodeId, new Node(nodeId, host, port, rack));
        }
        int controllerId = -1;
        if (struct.hasField(CONTROLLER_ID_KEY_NAME)) {
            controllerId = struct.getInt(CONTROLLER_ID_KEY_NAME);
        }
        this.clusterId = struct.hasField(CLUSTER_ID_KEY_NAME) ? struct.getString(CLUSTER_ID_KEY_NAME) : null;
        ArrayList<TopicMetadata> topicMetadata = new ArrayList<TopicMetadata>();
        for (Object topicInfoObj : topicInfos = (Object[])struct.get(TOPIC_METADATA_KEY_NAME)) {
            Object[] partitionInfos;
            Struct topicInfo = (Struct)topicInfoObj;
            Errors topicError = Errors.forCode(topicInfo.getShort(TOPIC_ERROR_CODE_KEY_NAME));
            String topic = topicInfo.getString(TOPIC_KEY_NAME);
            boolean isInternal = topicInfo.hasField(IS_INTERNAL_KEY_NAME) ? topicInfo.getBoolean(IS_INTERNAL_KEY_NAME) : false;
            ArrayList<PartitionMetadata> partitionMetadata = new ArrayList<PartitionMetadata>();
            for (Object partitionInfoObj : partitionInfos = (Object[])topicInfo.get(PARTITION_METADATA_KEY_NAME)) {
                Struct partitionInfo = (Struct)partitionInfoObj;
                Errors partitionError = Errors.forCode(partitionInfo.getShort(PARTITION_ERROR_CODE_KEY_NAME));
                int partition = partitionInfo.getInt(PARTITION_KEY_NAME);
                int leader = partitionInfo.getInt(LEADER_KEY_NAME);
                Node leaderNode = leader == -1 ? null : (Node)brokers.get(leader);
                Object[] replicas = (Object[])partitionInfo.get(REPLICAS_KEY_NAME);
                ArrayList<Node> replicaNodes = new ArrayList<Node>(replicas.length);
                for (Object replicaNodeId : replicas) {
                    if (brokers.containsKey(replicaNodeId)) {
                        replicaNodes.add((Node)brokers.get(replicaNodeId));
                        continue;
                    }
                    replicaNodes.add(new Node((Integer)replicaNodeId, "", -1));
                }
                Object[] isr = (Object[])partitionInfo.get(ISR_KEY_NAME);
                ArrayList<Node> isrNodes = new ArrayList<Node>(isr.length);
                for (Object isrNode : isr) {
                    if (brokers.containsKey(isrNode)) {
                        isrNodes.add((Node)brokers.get(isrNode));
                        continue;
                    }
                    isrNodes.add(new Node((Integer)isrNode, "", -1));
                }
                partitionMetadata.add(new PartitionMetadata(partitionError, partition, leaderNode, replicaNodes, isrNodes));
            }
            topicMetadata.add(new TopicMetadata(topicError, topic, isInternal, partitionMetadata));
        }
        this.brokers = brokers.values();
        this.controller = this.getControllerNode(controllerId, brokers.values());
        this.topicMetadata = topicMetadata;
    }

    private Node getControllerNode(int controllerId, Collection<Node> brokers) {
        for (Node broker : brokers) {
            if (broker.id() != controllerId) continue;
            return broker;
        }
        return null;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Map<String, Errors> errors() {
        HashMap<String, Errors> errors = new HashMap<String, Errors>();
        for (TopicMetadata metadata : this.topicMetadata) {
            if (metadata.error == Errors.NONE) continue;
            errors.put(metadata.topic(), metadata.error);
        }
        return errors;
    }

    public Set<String> topicsByError(Errors error) {
        HashSet<String> errorTopics = new HashSet<String>();
        for (TopicMetadata metadata : this.topicMetadata) {
            if (metadata.error != error) continue;
            errorTopics.add(metadata.topic());
        }
        return errorTopics;
    }

    public Set<String> unavailableTopics() {
        HashSet<String> invalidMetadataTopics = new HashSet<String>();
        block0: for (TopicMetadata topicMetadata : this.topicMetadata) {
            if (topicMetadata.error.exception() instanceof InvalidMetadataException) {
                invalidMetadataTopics.add(topicMetadata.topic);
                continue;
            }
            for (PartitionMetadata partitionMetadata : topicMetadata.partitionMetadata) {
                if (!(partitionMetadata.error.exception() instanceof InvalidMetadataException)) continue;
                invalidMetadataTopics.add(topicMetadata.topic);
                continue block0;
            }
        }
        return invalidMetadataTopics;
    }

    public Cluster cluster() {
        HashSet<String> internalTopics = new HashSet<String>();
        ArrayList<PartitionInfo> partitions = new ArrayList<PartitionInfo>();
        for (TopicMetadata metadata : this.topicMetadata) {
            if (metadata.error != Errors.NONE) continue;
            if (metadata.isInternal) {
                internalTopics.add(metadata.topic);
            }
            for (PartitionMetadata partitionMetadata : metadata.partitionMetadata) {
                partitions.add(new PartitionInfo(metadata.topic, partitionMetadata.partition, partitionMetadata.leader, partitionMetadata.replicas.toArray(new Node[0]), partitionMetadata.isr.toArray(new Node[0])));
            }
        }
        return new Cluster(this.clusterId, this.brokers, partitions, this.topicsByError(Errors.TOPIC_AUTHORIZATION_FAILED), internalTopics, this.controller);
    }

    public Collection<Node> brokers() {
        return this.brokers;
    }

    public Collection<TopicMetadata> topicMetadata() {
        return this.topicMetadata;
    }

    public Node controller() {
        return this.controller;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public static MetadataResponse parse(ByteBuffer buffer, short version) {
        return new MetadataResponse(ApiKeys.METADATA.parseResponse(version, buffer));
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.METADATA.responseSchema(version));
        if (struct.hasField("throttle_time_ms")) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        ArrayList<Struct> brokerArray = new ArrayList<Struct>();
        for (Node node : this.brokers) {
            Struct broker = struct.instance(BROKERS_KEY_NAME);
            broker.set(NODE_ID_KEY_NAME, (Object)node.id());
            broker.set(HOST_KEY_NAME, (Object)node.host());
            broker.set(PORT_KEY_NAME, (Object)node.port());
            if (broker.hasField(RACK_KEY_NAME)) {
                broker.set(RACK_KEY_NAME, (Object)node.rack());
            }
            brokerArray.add(broker);
        }
        struct.set(BROKERS_KEY_NAME, (Object)brokerArray.toArray());
        if (struct.hasField(CONTROLLER_ID_KEY_NAME)) {
            struct.set(CONTROLLER_ID_KEY_NAME, (Object)(this.controller == null ? -1 : this.controller.id()));
        }
        if (struct.hasField(CLUSTER_ID_KEY_NAME)) {
            struct.set(CLUSTER_ID_KEY_NAME, (Object)this.clusterId);
        }
        ArrayList<Struct> topicMetadataArray = new ArrayList<Struct>(this.topicMetadata.size());
        for (TopicMetadata metadata : this.topicMetadata) {
            Struct topicData = struct.instance(TOPIC_METADATA_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)metadata.topic);
            topicData.set(TOPIC_ERROR_CODE_KEY_NAME, (Object)metadata.error.code());
            if (topicData.hasField(IS_INTERNAL_KEY_NAME)) {
                topicData.set(IS_INTERNAL_KEY_NAME, (Object)metadata.isInternal());
            }
            ArrayList<Struct> partitionMetadataArray = new ArrayList<Struct>(metadata.partitionMetadata.size());
            for (PartitionMetadata partitionMetadata : metadata.partitionMetadata()) {
                Struct partitionData = topicData.instance(PARTITION_METADATA_KEY_NAME);
                partitionData.set(PARTITION_ERROR_CODE_KEY_NAME, (Object)partitionMetadata.error.code());
                partitionData.set(PARTITION_KEY_NAME, (Object)partitionMetadata.partition);
                partitionData.set(LEADER_KEY_NAME, (Object)partitionMetadata.leader.id());
                ArrayList<Integer> replicas = new ArrayList<Integer>(partitionMetadata.replicas.size());
                for (Node node : partitionMetadata.replicas) {
                    replicas.add(node.id());
                }
                partitionData.set(REPLICAS_KEY_NAME, (Object)replicas.toArray());
                ArrayList<Integer> isr = new ArrayList<Integer>(partitionMetadata.isr.size());
                for (Node node : partitionMetadata.isr) {
                    isr.add(node.id());
                }
                partitionData.set(ISR_KEY_NAME, (Object)isr.toArray());
                partitionMetadataArray.add(partitionData);
            }
            topicData.set(PARTITION_METADATA_KEY_NAME, (Object)partitionMetadataArray.toArray());
            topicMetadataArray.add(topicData);
        }
        struct.set(TOPIC_METADATA_KEY_NAME, (Object)topicMetadataArray.toArray());
        return struct;
    }

    public static class PartitionMetadata {
        private final Errors error;
        private final int partition;
        private final Node leader;
        private final List<Node> replicas;
        private final List<Node> isr;

        public PartitionMetadata(Errors error, int partition, Node leader, List<Node> replicas, List<Node> isr) {
            this.error = error;
            this.partition = partition;
            this.leader = leader;
            this.replicas = replicas;
            this.isr = isr;
        }

        public Errors error() {
            return this.error;
        }

        public int partition() {
            return this.partition;
        }

        public Node leader() {
            return this.leader;
        }

        public List<Node> replicas() {
            return this.replicas;
        }

        public List<Node> isr() {
            return this.isr;
        }

        public String toString() {
            return "(type=PartitionMetadata,, error=" + (Object)((Object)this.error) + ", partition=" + this.partition + ", leader=" + this.leader + ", replicas=" + Utils.join(this.replicas, ",") + ", isr=" + Utils.join(this.isr, ",") + ')';
        }
    }

    public static class TopicMetadata {
        private final Errors error;
        private final String topic;
        private final boolean isInternal;
        private final List<PartitionMetadata> partitionMetadata;

        public TopicMetadata(Errors error, String topic, boolean isInternal, List<PartitionMetadata> partitionMetadata) {
            this.error = error;
            this.topic = topic;
            this.isInternal = isInternal;
            this.partitionMetadata = partitionMetadata;
        }

        public Errors error() {
            return this.error;
        }

        public String topic() {
            return this.topic;
        }

        public boolean isInternal() {
            return this.isInternal;
        }

        public List<PartitionMetadata> partitionMetadata() {
            return this.partitionMetadata;
        }
    }
}

