/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import org.apache.hudi.org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MetricsRegionSource;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;

@InterfaceAudience.Private
public class MetricsRegion {
    private final MetricsRegionSource source;
    private MetricsRegionWrapper regionWrapper;

    public MetricsRegion(MetricsRegionWrapper wrapper) {
        this.source = ((MetricsRegionServerSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class)).createRegion(wrapper);
        this.regionWrapper = wrapper;
    }

    public void close() {
        this.source.close();
    }

    public void updatePut() {
        this.source.updatePut();
    }

    public void updateDelete() {
        this.source.updateDelete();
    }

    public void updateGet(long getSize) {
        this.source.updateGet(getSize);
    }

    public void updateScanNext(long scanSize) {
        this.source.updateScan(scanSize);
    }

    public void updateAppend() {
        this.source.updateAppend();
    }

    public void updateIncrement() {
        this.source.updateIncrement();
    }

    MetricsRegionSource getSource() {
        return this.source;
    }

    public MetricsRegionWrapper getRegionWrapper() {
        return this.regionWrapper;
    }
}

