/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.procedure.flush;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hudi.org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hudi.org.apache.hadoop.hbase.procedure.ProcedureMember;
import org.apache.hudi.org.apache.hadoop.hbase.procedure.Subprocedure;
import org.apache.hudi.org.apache.hadoop.hbase.procedure.flush.RegionServerFlushTableProcedureManager;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.Region;

@InterfaceAudience.Private
public class FlushTableSubprocedure
extends Subprocedure {
    private static final Log LOG = LogFactory.getLog(FlushTableSubprocedure.class);
    private final String table;
    private final List<Region> regions;
    private final RegionServerFlushTableProcedureManager.FlushTableSubprocedurePool taskManager;

    public FlushTableSubprocedure(ProcedureMember member, ForeignExceptionDispatcher errorListener, long wakeFrequency, long timeout, List<Region> regions, String table, RegionServerFlushTableProcedureManager.FlushTableSubprocedurePool taskManager) {
        super(member, table, errorListener, wakeFrequency, timeout);
        this.table = table;
        this.regions = regions;
        this.taskManager = taskManager;
    }

    private void flushRegions() throws ForeignException {
        if (this.regions.isEmpty()) {
            return;
        }
        this.monitor.rethrowException();
        if (this.taskManager.hasTasks()) {
            throw new IllegalStateException("Attempting to flush " + this.table + " but we currently have outstanding tasks");
        }
        for (Region region : this.regions) {
            this.taskManager.submitTask(new RegionFlushTask(region));
            this.monitor.rethrowException();
        }
        LOG.debug((Object)("Flush region tasks submitted for " + this.regions.size() + " regions"));
        try {
            this.taskManager.waitForOutstandingTasks();
        }
        catch (InterruptedException e) {
            throw new ForeignException(this.getMemberName(), e);
        }
    }

    @Override
    public void acquireBarrier() throws ForeignException {
        this.flushRegions();
    }

    @Override
    public byte[] insideBarrier() throws ForeignException {
        return new byte[0];
    }

    @Override
    public void cleanup(Exception e) {
        LOG.info((Object)("Aborting all flush region subprocedure task threads for '" + this.table + "' due to error"), (Throwable)e);
        try {
            this.taskManager.cancelTasks();
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
        }
    }

    public void releaseBarrier() {
    }

    private static class RegionFlushTask
    implements Callable<Void> {
        Region region;

        RegionFlushTask(Region region) {
            this.region = region;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            LOG.debug((Object)("Starting region operation on " + this.region));
            this.region.startRegionOperation();
            try {
                LOG.debug((Object)("Flush region " + this.region.toString() + " started..."));
                this.region.flush(true);
            }
            finally {
                LOG.debug((Object)("Closing region operation on " + this.region));
                this.region.closeRegionOperation();
            }
            return null;
        }
    }
}

