/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.client.ClientScanner;
import org.apache.hudi.org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hudi.org.apache.hadoop.hbase.client.ReversedScannerCallable;
import org.apache.hudi.org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hudi.org.apache.hadoop.hbase.client.Scan;
import org.apache.hudi.org.apache.hadoop.hbase.client.ScannerCallableWithReplicas;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.ExceptionUtil;

@InterfaceAudience.Private
public class ReversedClientScanner
extends ClientScanner {
    private static final Log LOG = LogFactory.getLog(ReversedClientScanner.class);

    public ReversedClientScanner(Configuration conf, Scan scan, TableName tableName, ClusterConnection connection, RpcRetryingCallerFactory rpcFactory, RpcControllerFactory controllerFactory, ExecutorService pool, int primaryOperationTimeout) throws IOException {
        super(conf, scan, tableName, connection, rpcFactory, controllerFactory, pool, primaryOperationTimeout);
    }

    @Override
    protected boolean nextScanner(int nbRows, boolean done) throws IOException {
        byte[] localStartKey;
        if (this.callable != null) {
            this.callable.setClose();
            this.caller.callWithoutRetries(this.callable, this.scannerTimeout);
            this.callable = null;
        }
        boolean locateTheClosestFrontRow = true;
        if (this.currentRegion != null) {
            byte[] startKey = this.currentRegion.getStartKey();
            if (startKey == null || Bytes.equals(startKey, HConstants.EMPTY_BYTE_ARRAY) || this.checkScanStopRow(startKey) || done) {
                this.close();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Finished " + this.currentRegion));
                }
                return false;
            }
            localStartKey = startKey;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Finished " + this.currentRegion));
            }
        } else {
            localStartKey = this.scan.getStartRow();
            if (!Bytes.equals(localStartKey, HConstants.EMPTY_BYTE_ARRAY)) {
                locateTheClosestFrontRow = false;
            }
        }
        if (LOG.isDebugEnabled() && this.currentRegion != null) {
            LOG.debug((Object)("Advancing internal scanner to startKey at '" + Bytes.toStringBinary(localStartKey) + "'"));
        }
        try {
            byte[] locateStartRow = locateTheClosestFrontRow ? ReversedClientScanner.createClosestRowBefore(localStartKey) : null;
            this.callable = this.getScannerCallable(localStartKey, nbRows, locateStartRow);
            this.caller.callWithoutRetries(this.callable, this.scannerTimeout);
            this.currentRegion = this.callable.getHRegionInfo();
            if (this.scanMetrics != null) {
                this.scanMetrics.countOfRegions.incrementAndGet();
            }
        }
        catch (IOException e) {
            ExceptionUtil.rethrowIfInterrupt(e);
            this.close();
            throw e;
        }
        return true;
    }

    protected ScannerCallableWithReplicas getScannerCallable(byte[] localStartKey, int nbRows, byte[] locateStartRow) {
        this.scan.setStartRow(localStartKey);
        ReversedScannerCallable s = new ReversedScannerCallable(this.getConnection(), this.getTable(), this.scan, this.scanMetrics, locateStartRow, this.rpcControllerFactory);
        s.setCaching(nbRows);
        ScannerCallableWithReplicas sr = new ScannerCallableWithReplicas(this.getTable(), this.getConnection(), s, this.pool, this.primaryOperationTimeout, this.scan, this.getRetries(), this.getScannerTimeout(), this.caching, this.getConf(), this.caller);
        return sr;
    }

    @Override
    protected boolean checkScanStopRow(byte[] startKey) {
        byte[] stopRow;
        int cmp;
        return this.scan.getStopRow().length > 0 && (cmp = Bytes.compareTo(stopRow = this.scan.getStopRow(), 0, stopRow.length, startKey, 0, startKey.length)) >= 0;
    }
}

