/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.com.google.common.collect;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hudi.com.google.common.annotations.GwtCompatible;
import org.apache.hudi.com.google.common.collect.ImmutableCollection;
import org.apache.hudi.com.google.common.collect.ImmutableList;
import org.apache.hudi.com.google.common.collect.ImmutableMap;
import org.apache.hudi.com.google.common.collect.ImmutableMultiset;
import org.apache.hudi.com.google.common.collect.ImmutableSet;
import org.apache.hudi.com.google.common.collect.Multiset;
import org.apache.hudi.com.google.common.collect.Multisets;
import org.apache.hudi.com.google.common.collect.TransformedImmutableList;
import org.apache.hudi.com.google.common.collect.UnmodifiableIterator;

@GwtCompatible(serializable=true)
class RegularImmutableMultiset<E>
extends ImmutableMultiset<E> {
    private final transient ImmutableMap<E, Integer> map;
    private final transient int size;

    RegularImmutableMultiset(ImmutableMap<E, Integer> map, int size) {
        this.map = map;
        this.size = size;
    }

    @Override
    boolean isPartialView() {
        return this.map.isPartialView();
    }

    @Override
    public int count(@Nullable Object element) {
        Integer value = this.map.get(element);
        return value == null ? 0 : value;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(@Nullable Object element) {
        return this.map.containsKey(element);
    }

    @Override
    public ImmutableSet<E> elementSet() {
        return this.map.keySet();
    }

    private static <E> Multiset.Entry<E> entryFromMapEntry(Map.Entry<E, Integer> entry) {
        return Multisets.immutableEntry(entry.getKey(), entry.getValue());
    }

    @Override
    ImmutableSet<Multiset.Entry<E>> createEntrySet() {
        return new ImmutableMultiset.EntrySet(){

            @Override
            public int size() {
                return RegularImmutableMultiset.this.map.size();
            }

            @Override
            public UnmodifiableIterator<Multiset.Entry<E>> iterator() {
                return this.asList().iterator();
            }

            @Override
            ImmutableList<Multiset.Entry<E>> createAsList() {
                ImmutableList entryList = ((ImmutableCollection)((Object)RegularImmutableMultiset.this.map.entrySet())).asList();
                return new TransformedImmutableList<Map.Entry<E, Integer>, Multiset.Entry<E>>(entryList){

                    @Override
                    Multiset.Entry<E> transform(Map.Entry<E, Integer> entry) {
                        return RegularImmutableMultiset.entryFromMapEntry(entry);
                    }
                };
            }
        };
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }
}

