/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001B\u0001\u0003\u0001=\u0011q\u0003\u0015:pGRKW.\u001a\"pk:$W\r\u001a*poN|e/\u001a:\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\u000e$!\u0011\t\"\u0003\u0006\u000b\u000e\u0003\tI!a\u0005\u0002\u0003?A\u0013xnY3tg\u001a+hn\u0019;j_:<\u0016\u000e\u001e5DY\u0016\fg.\u001e9Ti\u0006$X\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\t\u0005)A/\u001f9fg&\u0011\u0011D\u0006\u0002\u0005\u0007J{w\u000fE\u0002\u001c=\u0001j\u0011\u0001\b\u0006\u0003;\u0019\tqaY8eK\u001e,g.\u0003\u0002 9\tA1i\\7qS2,'\u000f\u0005\u0002\u0012C%\u0011!E\u0001\u0002\u0016\u000f\u0016tWM]1uK\u0012\fum\u001a:fO\u0006$\u0018n\u001c8t!\t!s%D\u0001&\u0015\t1c!\u0001\u0003vi&d\u0017B\u0001\u0015&\u0005\u001daunZ4j]\u001eD\u0001B\u000b\u0001\u0003\u0002\u0003\u0006IaK\u0001\u0010O\u0016t\u0017iZ4sK\u001e\fG/[8ogB\u00111\u0004L\u0005\u0003[q\u0011QdR3oKJ\fG/\u001a3BO\u001e\u0014XmZ1uS>t7OR;oGRLwN\u001c\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u0005y\u0001O]3dK\u0012LgnZ(gMN,G\u000f\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$G\u0001\u0003M_:<\u0007\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\u0002%\u0005<wM]3hCR,7\u000fV=qK&sgm\u001c\t\u0003s\u0001k\u0011A\u000f\u0006\u0003wq\n\u0011\u0002^=qKV$\u0018\u000e\\:\u000b\u0005ur\u0014\u0001\u00026bm\u0006T!a\u0010\u0005\u0002\u0007\u0005\u0004\u0018.\u0003\u0002Bu\tY!k\\<UsB,\u0017J\u001c4p\u0011!\u0019\u0005A!A!\u0002\u0013!\u0015!C5oaV$H+\u001f9f!\r)%\nF\u0007\u0002\r*\u0011q\tS\u0001\tif\u0004X-\u001b8g_*\u0011\u0011JP\u0001\u0007G>lWn\u001c8\n\u0005-3%a\u0004+za\u0016LeNZ8s[\u0006$\u0018n\u001c8\t\u00115\u0003!\u0011!Q\u0001\n9\u000b1\"];fef\u001cuN\u001c4jOB\u0011q*U\u0007\u0002!*\u0011qHB\u0005\u0003%B\u0013\u0011c\u0015;sK\u0006l\u0017+^3ss\u000e{gNZ5h\u0011\u0015!\u0006\u0001\"\u0001V\u0003\u0019a\u0014N\\5u}Q1ak\u0016-Z5n\u0003\"!\u0005\u0001\t\u000b)\u001a\u0006\u0019A\u0016\t\u000b=\u001a\u0006\u0019\u0001\u0019\t\u000b]\u001a\u0006\u0019\u0001\u001d\t\u000b\r\u001b\u0006\u0019\u0001#\t\u000b5\u001b\u0006\u0019\u0001(\t\u0013u\u0003\u0001\u0019!a\u0001\n\u0013q\u0016\u0001E1dGVlW\u000f\\1u_J\u001cF/\u0019;f+\u0005y\u0006c\u00011dK6\t\u0011M\u0003\u0002c\u0011\u0006)1\u000f^1uK&\u0011A-\u0019\u0002\u000b-\u0006dW/Z*uCR,\u0007C\u00014i\u001b\u00059'BA\f\t\u0013\tIwMA\u0002S_^D\u0011b\u001b\u0001A\u0002\u0003\u0007I\u0011\u00027\u0002)\u0005\u001c7-^7vY\u0006$xN]*uCR,w\fJ3r)\ti\u0007\u000f\u0005\u00022]&\u0011qN\r\u0002\u0005+:LG\u000fC\u0004rU\u0006\u0005\t\u0019A0\u0002\u0007a$\u0013\u0007\u0003\u0004t\u0001\u0001\u0006KaX\u0001\u0012C\u000e\u001cW/\\;mCR|'o\u0015;bi\u0016\u0004\u0003\"C;\u0001\u0001\u0004\u0005\r\u0011\"\u0003w\u0003-\u0011xn^'baN#\u0018\r^3\u0016\u0003]\u0004B\u0001\u0019=1u&\u0011\u00110\u0019\u0002\t\u001b\u0006\u00048\u000b^1uKB\u00191P`3\u000e\u0003qT!AJ?\u000b\u0003uJ!a ?\u0003\t1K7\u000f\u001e\u0005\f\u0003\u0007\u0001\u0001\u0019!a\u0001\n\u0013\t)!A\bs_^l\u0015\r]*uCR,w\fJ3r)\ri\u0017q\u0001\u0005\tc\u0006\u0005\u0011\u0011!a\u0001o\"9\u00111\u0002\u0001!B\u00139\u0018\u0001\u0004:po6\u000b\u0007o\u0015;bi\u0016\u0004\u0003bCA\b\u0001\u0001\u0007\t\u0019!C\u0005\u0003#\taa\\;uaV$X#\u0001\u000b\t\u0017\u0005U\u0001\u00011AA\u0002\u0013%\u0011qC\u0001\u000b_V$\b/\u001e;`I\u0015\fHcA7\u0002\u001a!A\u0011/a\u0005\u0002\u0002\u0003\u0007A\u0003C\u0004\u0002\u001e\u0001\u0001\u000b\u0015\u0002\u000b\u0002\u000f=,H\u000f];uA!Y\u0011\u0011\u0005\u0001A\u0002\u0003\u0007I\u0011BA\u0012\u00031\u0019w.\u001e8uKJ\u001cF/\u0019;f+\t\t)\u0003E\u0002aGBB1\"!\u000b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002,\u0005\u00012m\\;oi\u0016\u00148\u000b^1uK~#S-\u001d\u000b\u0004[\u00065\u0002\"C9\u0002(\u0005\u0005\t\u0019AA\u0013\u0011!\t\t\u0004\u0001Q!\n\u0005\u0015\u0012!D2pk:$XM]*uCR,\u0007\u0005C\u0006\u00026\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0012aD:nC2dWm\u001d;UgN#\u0018\r^3\t\u0017\u0005e\u0002\u00011AA\u0002\u0013%\u00111H\u0001\u0014g6\fG\u000e\\3tiR\u001b8\u000b^1uK~#S-\u001d\u000b\u0004[\u0006u\u0002\"C9\u00028\u0005\u0005\t\u0019AA\u0013\u0011!\t\t\u0005\u0001Q!\n\u0005\u0015\u0012\u0001E:nC2dWm\u001d;UgN#\u0018\r^3!\u0011-\t)\u0005\u0001a\u0001\u0002\u0004%I!a\u0012\u0002\u0011\u0019,hn\u0019;j_:,\u0012\u0001\t\u0005\f\u0003\u0017\u0002\u0001\u0019!a\u0001\n\u0013\ti%\u0001\u0007gk:\u001cG/[8o?\u0012*\u0017\u000fF\u0002n\u0003\u001fB\u0001\"]A%\u0003\u0003\u0005\r\u0001\t\u0005\b\u0003'\u0002\u0001\u0015)\u0003!\u0003%1WO\\2uS>t\u0007\u0005C\u0004\u0002X\u0001!\t%!\u0017\u0002\t=\u0004XM\u001c\u000b\u0004[\u0006m\u0003\u0002CA/\u0003+\u0002\r!a\u0018\u0002\r\r|gNZ5h!\u0011\t\t'a\u001a\u000e\u0005\u0005\r$bAA3\u0011\u0005i1m\u001c8gS\u001e,(/\u0019;j_:LA!!\u001b\u0002d\ti1i\u001c8gS\u001e,(/\u0019;j_:Dq!!\u001c\u0001\t\u0003\ny'\u0001\bqe>\u001cWm]:FY\u0016lWM\u001c;\u0015\u000f5\f\t(!\u001e\u0002\u0012\"9\u00111OA6\u0001\u0004!\u0012AB5oaV$8\t\u0003\u0005\u0002x\u0005-\u0004\u0019AA=\u0003\r\u0019G\u000f\u001f\t\u0005\u0003w\ni\t\u0005\u0004\u0002~\u0005%E\u0003F\u0007\u0003\u0003\u007fRA!!!\u0002\u0004\u0006Ia-\u001e8di&|gn\u001d\u0006\u0004\u007f\u0005\u0015%bAAD\u0011\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0005\u0003\u0017\u000byHA\bQe>\u001cWm]:Gk:\u001cG/[8o\u0013\u0011\ty)!#\u0003\u000f\r{g\u000e^3yi\"A\u00111SA6\u0001\u0004\t)*A\u0002pkR\u0004R!a&\u0002\u001cRi!!!'\u000b\u0005\u0019B\u0011\u0002BAO\u00033\u0013\u0011bQ8mY\u0016\u001cGo\u001c:\t\u000f\u0005\u0005\u0006\u0001\"\u0011\u0002$\u00069qN\u001c+j[\u0016\u0014HcB7\u0002&\u0006%\u0016\u0011\u0017\u0005\b\u0003O\u000by\n1\u00011\u0003%!\u0018.\\3ti\u0006l\u0007\u000f\u0003\u0005\u0002x\u0005}\u0005\u0019AAV!\u0011\tY(!,\n\t\u0005=\u0016\u0011\u0012\u0002\u000f\u001f:$\u0016.\\3s\u0007>tG/\u001a=u\u0011!\t\u0019*a(A\u0002\u0005U\u0005bBA[\u0001\u0011\u0005\u0013qW\u0001\u0006G2|7/\u001a\u000b\u0002[\u0002")
public class ProcTimeBoundedRowsOver
extends ProcessFunctionWithCleanupState<CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final long precedingOffset;
    private final RowTypeInfo aggregatesTypeInfo;
    private final TypeInformation<CRow> inputType;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> rowMapState;
    private CRow output;
    private ValueState<Object> counterState;
    private ValueState<Object> smallestTsState;
    private GeneratedAggregations function;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        ProcTimeBoundedRowsOver procTimeBoundedRowsOver = this;
        synchronized (procTimeBoundedRowsOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> rowMapState() {
        return this.rowMapState;
    }

    private void rowMapState_$eq(MapState<Object, List<Row>> x$1) {
        this.rowMapState = x$1;
    }

    private CRow output() {
        return this.output;
    }

    private void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Object> counterState() {
        return this.counterState;
    }

    private void counterState_$eq(ValueState<Object> x$1) {
        this.counterState = x$1;
    }

    private ValueState<Object> smallestTsState() {
        return this.smallestTsState;
    }

    private void smallestTsState_$eq(ValueState<Object> x$1) {
        this.smallestTsState = x$1;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", " \\n\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.code()}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        ListTypeInfo rowListTypeInfo = new ListTypeInfo((TypeInformation)((CRowTypeInfo)this.inputType).rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("windowBufferMapState", (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, (TypeInformation)rowListTypeInfo);
        this.rowMapState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        ValueStateDescriptor aggregationStateDescriptor = new ValueStateDescriptor("aggregationState", (TypeInformation)this.aggregatesTypeInfo);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(aggregationStateDescriptor));
        ValueStateDescriptor processedCountDescriptor = new ValueStateDescriptor("processedCountState", Long.TYPE);
        this.counterState_$eq((ValueState<Object>)this.getRuntimeContext().getState(processedCountDescriptor));
        ValueStateDescriptor smallestTimestampDescriptor = new ValueStateDescriptor("smallestTSState", Long.TYPE);
        this.smallestTsState_$eq((ValueState<Object>)this.getRuntimeContext().getState(smallestTimestampDescriptor));
        this.initCleanupTimeState("ProcTimeBoundedRowsOverCleanupTime");
    }

    public void processElement(CRow inputC, ProcessFunction.Context ctx, Collector<CRow> out) {
        long counter;
        long smallestTs;
        Row input = inputC.row();
        long currentTime2 = ctx.timerService().currentProcessingTime();
        this.processCleanupTimer(ctx, currentTime2);
        Row accumulators = (Row)this.accumulatorState().value();
        if (accumulators == null) {
            accumulators = this.function().createAccumulators();
        }
        if ((smallestTs = BoxesRunTime.unboxToLong((Object)this.smallestTsState().value())) == 0L) {
            smallestTs = currentTime2;
            this.smallestTsState().update((Object)BoxesRunTime.boxToLong((long)smallestTs));
        }
        if ((counter = BoxesRunTime.unboxToLong((Object)this.counterState().value())) == this.precedingOffset) {
            List retractList = (List)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)smallestTs));
            Row retractRow = (Row)retractList.get(0);
            this.function().retract(accumulators, retractRow);
            retractList.remove(0);
            if (retractList.isEmpty()) {
                this.rowMapState().remove((Object)BoxesRunTime.boxToLong((long)smallestTs));
                Iterator iter = this.rowMapState().keys().iterator();
                long currentTs = 0L;
                long newSmallestTs = Long.MAX_VALUE;
                while (iter.hasNext()) {
                    currentTs = BoxesRunTime.unboxToLong(iter.next());
                    if (currentTs >= newSmallestTs) continue;
                    newSmallestTs = currentTs;
                }
                this.smallestTsState().update((Object)BoxesRunTime.boxToLong((long)newSmallestTs));
            } else {
                this.rowMapState().put((Object)BoxesRunTime.boxToLong((long)smallestTs), (Object)retractList);
            }
        } else {
            this.counterState().update((Object)BoxesRunTime.boxToLong((long)(++counter)));
        }
        this.function().setForwardedFields(input, this.output().row());
        this.function().accumulate(accumulators, input);
        this.function().setAggregationResults(accumulators, this.output().row());
        List currentTimeState = (List)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)currentTime2));
        if (currentTimeState == null) {
            ArrayList<Row> newList = new ArrayList<Row>();
            newList.add(input);
            this.rowMapState().put((Object)BoxesRunTime.boxToLong((long)currentTime2), newList);
        } else {
            currentTimeState.add(input);
            this.rowMapState().put((Object)BoxesRunTime.boxToLong((long)currentTime2), (Object)currentTimeState);
        }
        this.accumulatorState().update((Object)accumulators);
        out.collect((Object)this.output());
    }

    public void onTimer(long timestamp, ProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.stateCleaningEnabled()) {
            this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.rowMapState(), this.accumulatorState(), this.counterState(), this.smallestTsState()}));
            this.function().cleanup();
        }
    }

    public void close() {
        this.function().close();
    }

    public ProcTimeBoundedRowsOver(GeneratedAggregationsFunction genAggregations, long precedingOffset, RowTypeInfo aggregatesTypeInfo, TypeInformation<CRow> inputType, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.precedingOffset = precedingOffset;
        this.aggregatesTypeInfo = aggregatesTypeInfo;
        this.inputType = inputType;
        super(queryConfig);
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
        Preconditions.checkArgument((precedingOffset > 0L ? 1 : 0) != 0);
    }
}

