/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.expressions.ArrayConstructor;
import org.apache.flink.table.expressions.Cast;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.Literal;
import org.apache.flink.table.expressions.Literal$;
import org.apache.flink.table.expressions.Mul;
import org.apache.flink.table.expressions.ResolvedFieldReference;
import org.apache.flink.table.typeutils.RowIntervalTypeInfo;
import org.apache.flink.table.typeutils.RowIntervalTypeInfo$;
import org.apache.flink.table.typeutils.TimeIntervalTypeInfo;
import org.apache.flink.table.typeutils.TimeIntervalTypeInfo$;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ExpressionUtils$ {
    public static final ExpressionUtils$ MODULE$;

    static {
        new ExpressionUtils$();
    }

    public TypeInformation<?> getResultType(Expression expr) {
        return expr.resultType();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTimeIntervalLiteral(Expression expr) {
        Expression expression2 = expr;
        if (!(expression2 instanceof Literal)) return false;
        Literal literal = (Literal)expression2;
        TypeInformation<?> typeInformation = literal.resultType();
        TimeIntervalTypeInfo<Long> timeIntervalTypeInfo = TimeIntervalTypeInfo$.MODULE$.INTERVAL_MILLIS();
        TypeInformation<?> typeInformation2 = typeInformation;
        if (timeIntervalTypeInfo != null) {
            if (!((Object)timeIntervalTypeInfo).equals(typeInformation2)) return false;
            return true;
        }
        if (typeInformation2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRowCountLiteral(Expression expr) {
        Expression expression2 = expr;
        if (!(expression2 instanceof Literal)) return false;
        Literal literal = (Literal)expression2;
        TypeInformation<?> typeInformation = literal.resultType();
        RowIntervalTypeInfo rowIntervalTypeInfo = RowIntervalTypeInfo$.MODULE$.INTERVAL_ROWS();
        TypeInformation<?> typeInformation2 = typeInformation;
        if (rowIntervalTypeInfo != null) {
            if (!((Object)((Object)rowIntervalTypeInfo)).equals(typeInformation2)) return false;
            return true;
        }
        if (typeInformation2 == null) return true;
        return false;
    }

    public boolean isTimeAttribute(Expression expr) {
        ResolvedFieldReference resolvedFieldReference;
        Expression expression2 = expr;
        boolean bl = expression2 instanceof ResolvedFieldReference && FlinkTypeFactory$.MODULE$.isTimeIndicatorType((resolvedFieldReference = (ResolvedFieldReference)expression2).resultType());
        return bl;
    }

    public boolean isRowtimeAttribute(Expression expr) {
        ResolvedFieldReference resolvedFieldReference;
        Expression expression2 = expr;
        boolean bl = expression2 instanceof ResolvedFieldReference && FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType((resolvedFieldReference = (ResolvedFieldReference)expression2).resultType());
        return bl;
    }

    public boolean isProctimeAttribute(Expression expr) {
        ResolvedFieldReference resolvedFieldReference;
        Expression expression2 = expr;
        boolean bl = expression2 instanceof ResolvedFieldReference && FlinkTypeFactory$.MODULE$.isProctimeIndicatorType((resolvedFieldReference = (ResolvedFieldReference)expression2).resultType());
        return bl;
    }

    public Time toTime(Expression expr) {
        Expression expression2 = expr;
        if (expression2 instanceof Literal) {
            Literal literal = (Literal)expression2;
            Object value = literal.value();
            TypeInformation<?> typeInformation = literal.resultType();
            if (value instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)value);
                TimeIntervalTypeInfo<Long> timeIntervalTypeInfo = TimeIntervalTypeInfo$.MODULE$.INTERVAL_MILLIS();
                TypeInformation<?> typeInformation2 = typeInformation;
                if (!(timeIntervalTypeInfo != null ? !((Object)timeIntervalTypeInfo).equals(typeInformation2) : typeInformation2 != null)) {
                    Time time = Time.milliseconds((long)l);
                    return time;
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public long toLong(Expression expr) {
        Expression expression2 = expr;
        if (expression2 instanceof Literal) {
            Literal literal = (Literal)expression2;
            Object value = literal.value();
            TypeInformation<?> typeInformation = literal.resultType();
            if (value instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)value);
                RowIntervalTypeInfo rowIntervalTypeInfo = RowIntervalTypeInfo$.MODULE$.INTERVAL_ROWS();
                TypeInformation<?> typeInformation2 = typeInformation;
                if (!(rowIntervalTypeInfo != null ? !((Object)((Object)rowIntervalTypeInfo)).equals(typeInformation2) : typeInformation2 != null)) {
                    long l2 = l;
                    return l2;
                }
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Expression toMonthInterval(Expression expr, int multiplier) {
        void var9_11;
        Expression expression2 = expr;
        if (expression2 instanceof Literal) {
            Literal literal = (Literal)expression2;
            Object value = literal.value();
            TypeInformation<?> typeInformation = literal.resultType();
            if (value instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)value);
                BasicTypeInfo basicTypeInfo = BasicTypeInfo.INT_TYPE_INFO;
                TypeInformation<?> typeInformation2 = typeInformation;
                if (!(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation2) : typeInformation2 != null)) {
                    Literal literal2 = new Literal(BoxesRunTime.boxToInteger((int)(n * multiplier)), TimeIntervalTypeInfo$.MODULE$.INTERVAL_MONTHS());
                    return var9_11;
                }
            }
        }
        Cast cast = new Cast(new Mul(expr, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)multiplier))), TimeIntervalTypeInfo$.MODULE$.INTERVAL_MONTHS());
        return var9_11;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Expression toMilliInterval(Expression expr, long multiplier) {
        void var11_13;
        boolean bl = false;
        Literal literal = null;
        Expression expression2 = expr;
        if (expression2 instanceof Literal) {
            bl = true;
            literal = (Literal)expression2;
            Object value = literal.value();
            TypeInformation<?> typeInformation = literal.resultType();
            if (value instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)value);
                BasicTypeInfo basicTypeInfo = BasicTypeInfo.INT_TYPE_INFO;
                TypeInformation<?> typeInformation2 = typeInformation;
                if (!(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation2) : typeInformation2 != null)) {
                    Literal literal2 = new Literal(BoxesRunTime.boxToLong((long)((long)n * multiplier)), TimeIntervalTypeInfo$.MODULE$.INTERVAL_MILLIS());
                    return var11_13;
                }
            }
        }
        if (bl) {
            Object value = literal.value();
            TypeInformation<?> typeInformation = literal.resultType();
            if (value instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)value);
                BasicTypeInfo basicTypeInfo = BasicTypeInfo.LONG_TYPE_INFO;
                TypeInformation<?> typeInformation3 = typeInformation;
                if (!(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation3) : typeInformation3 != null)) {
                    Literal literal3 = new Literal(BoxesRunTime.boxToLong((long)(l * multiplier)), TimeIntervalTypeInfo$.MODULE$.INTERVAL_MILLIS());
                    return var11_13;
                }
            }
        }
        Cast cast = new Cast(new Mul(expr, Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)multiplier))), TimeIntervalTypeInfo$.MODULE$.INTERVAL_MILLIS());
        return var11_13;
    }

    public Expression toRowInterval(Expression expr) {
        block4: {
            Literal literal;
            block3: {
                Literal literal2;
                boolean bl;
                block2: {
                    bl = false;
                    literal2 = null;
                    Expression expression2 = expr;
                    if (!(expression2 instanceof Literal)) break block2;
                    bl = true;
                    literal2 = (Literal)expression2;
                    Object value = literal2.value();
                    TypeInformation<?> typeInformation = literal2.resultType();
                    if (!(value instanceof Integer)) break block2;
                    int n = BoxesRunTime.unboxToInt((Object)value);
                    BasicTypeInfo basicTypeInfo = BasicTypeInfo.INT_TYPE_INFO;
                    TypeInformation<?> typeInformation2 = typeInformation;
                    if (basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation2) : typeInformation2 != null) break block2;
                    literal = new Literal(BoxesRunTime.boxToLong((long)n), RowIntervalTypeInfo$.MODULE$.INTERVAL_ROWS());
                    break block3;
                }
                if (!bl) break block4;
                Object value = literal2.value();
                TypeInformation<?> typeInformation = literal2.resultType();
                if (!(value instanceof Long)) break block4;
                long l = BoxesRunTime.unboxToLong((Object)value);
                BasicTypeInfo basicTypeInfo = BasicTypeInfo.LONG_TYPE_INFO;
                TypeInformation<?> typeInformation3 = typeInformation;
                if (basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation3) : typeInformation3 != null) break block4;
                literal = new Literal(BoxesRunTime.boxToLong((long)l), RowIntervalTypeInfo$.MODULE$.INTERVAL_ROWS());
            }
            return literal;
        }
        throw new IllegalArgumentException("Invalid value for row interval literal.");
    }

    public Expression convertArray(Object array2) {
        block23: {
            Expression expression2;
            block3: {
                block22: {
                    Object object;
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        block16: {
                                            block15: {
                                                block14: {
                                                    block13: {
                                                        block12: {
                                                            block11: {
                                                                block10: {
                                                                    block9: {
                                                                        block8: {
                                                                            block7: {
                                                                                block6: {
                                                                                    block5: {
                                                                                        block4: {
                                                                                            block2: {
                                                                                                object = array2;
                                                                                                if (!(object instanceof boolean[])) break block2;
                                                                                                expression2 = this.createArray$1(array2);
                                                                                                break block3;
                                                                                            }
                                                                                            if (!(object instanceof byte[])) break block4;
                                                                                            expression2 = this.createArray$1(array2);
                                                                                            break block3;
                                                                                        }
                                                                                        if (!(object instanceof short[])) break block5;
                                                                                        expression2 = this.createArray$1(array2);
                                                                                        break block3;
                                                                                    }
                                                                                    if (!(object instanceof int[])) break block6;
                                                                                    expression2 = this.createArray$1(array2);
                                                                                    break block3;
                                                                                }
                                                                                if (!(object instanceof long[])) break block7;
                                                                                expression2 = this.createArray$1(array2);
                                                                                break block3;
                                                                            }
                                                                            if (!(object instanceof float[])) break block8;
                                                                            expression2 = this.createArray$1(array2);
                                                                            break block3;
                                                                        }
                                                                        if (!(object instanceof double[])) break block9;
                                                                        expression2 = this.createArray$1(array2);
                                                                        break block3;
                                                                    }
                                                                    if (!(object instanceof Boolean[])) break block10;
                                                                    expression2 = this.createArray$1(array2);
                                                                    break block3;
                                                                }
                                                                if (!(object instanceof Byte[])) break block11;
                                                                expression2 = this.createArray$1(array2);
                                                                break block3;
                                                            }
                                                            if (!(object instanceof Short[])) break block12;
                                                            expression2 = this.createArray$1(array2);
                                                            break block3;
                                                        }
                                                        if (!(object instanceof Integer[])) break block13;
                                                        expression2 = this.createArray$1(array2);
                                                        break block3;
                                                    }
                                                    if (!(object instanceof Long[])) break block14;
                                                    expression2 = this.createArray$1(array2);
                                                    break block3;
                                                }
                                                if (!(object instanceof Float[])) break block15;
                                                expression2 = this.createArray$1(array2);
                                                break block3;
                                            }
                                            if (!(object instanceof Double[])) break block16;
                                            expression2 = this.createArray$1(array2);
                                            break block3;
                                        }
                                        if (!(object instanceof String[])) break block17;
                                        expression2 = this.createArray$1(array2);
                                        break block3;
                                    }
                                    if (!(object instanceof BigDecimal[])) break block18;
                                    expression2 = this.createArray$1(array2);
                                    break block3;
                                }
                                if (!(object instanceof Date[])) break block19;
                                expression2 = this.createArray$1(array2);
                                break block3;
                            }
                            if (!(object instanceof java.sql.Time[])) break block20;
                            expression2 = this.createArray$1(array2);
                            break block3;
                        }
                        if (!(object instanceof Timestamp[])) break block21;
                        expression2 = this.createArray$1(array2);
                        break block3;
                    }
                    if (!(object instanceof scala.math.BigDecimal[])) break block22;
                    scala.math.BigDecimal[] bigDecimalArray = (scala.math.BigDecimal[])object;
                    expression2 = new ArrayConstructor((Seq<Expression>)((Seq)Predef$.MODULE$.refArrayOps((Object[])bigDecimalArray).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Literal apply(scala.math.BigDecimal bd) {
                            return Literal$.MODULE$.apply(bd.bigDecimal());
                        }
                    }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
                    break block3;
                }
                if (ScalaRunTime$.MODULE$.array_length(array2) <= 0 || !ScalaRunTime$.MODULE$.isArray(Predef$.MODULE$.genericArrayOps(array2).head(), 1)) break block23;
                expression2 = new ArrayConstructor((Seq<Expression>)((Seq)Predef$.MODULE$.genericArrayOps(array2).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Expression apply(Object na) {
                        return ExpressionUtils$.MODULE$.convertArray(na);
                    }
                }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
            }
            return expression2;
        }
        throw new ValidationException("Unsupported array type.");
    }

    private final Expression createArray$1(Object array$1) {
        return new ArrayConstructor((Seq<Expression>)((Seq)Predef$.MODULE$.genericArrayOps(array$1).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Literal apply(Object x$1) {
                return Literal$.MODULE$.apply(x$1);
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
    }

    private ExpressionUtils$() {
        MODULE$ = this;
    }
}

