/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.calcite.shaded.com.google.common.cache.CacheBuilder;
import org.apache.flink.calcite.shaded.com.google.common.cache.CacheLoader;
import org.apache.flink.calcite.shaded.com.google.common.cache.LoadingCache;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.Sets;

public class SqlTypeAssignmentRules {
    private static final SqlTypeAssignmentRules INSTANCE;
    private static final SqlTypeAssignmentRules COERCE_INSTANCE;
    private final Map<SqlTypeName, ImmutableSet<SqlTypeName>> map;

    private SqlTypeAssignmentRules(Map<SqlTypeName, ImmutableSet<SqlTypeName>> map2) {
        this.map = ImmutableMap.copyOf(map2);
    }

    public static synchronized SqlTypeAssignmentRules instance() {
        return SqlTypeAssignmentRules.instance(false);
    }

    public static synchronized SqlTypeAssignmentRules instance(boolean coerce) {
        return coerce ? COERCE_INSTANCE : INSTANCE;
    }

    @Deprecated
    public boolean canCastFrom(SqlTypeName to, SqlTypeName from, boolean coerce) {
        return SqlTypeAssignmentRules.instance(coerce).canCastFrom(to, from);
    }

    public boolean canCastFrom(SqlTypeName to, SqlTypeName from) {
        Objects.requireNonNull(to);
        Objects.requireNonNull(from);
        if (to == SqlTypeName.NULL) {
            return false;
        }
        if (from == SqlTypeName.NULL) {
            return true;
        }
        Set rule = this.map.get((Object)to);
        if (rule == null) {
            throw new AssertionError((Object)("No assign rules for " + (Object)((Object)to) + " defined"));
        }
        return rule.contains((Object)from);
    }

    static {
        Builder rules = new Builder();
        HashSet<SqlTypeName> rule = new HashSet<SqlTypeName>();
        for (SqlTypeName interval : SqlTypeName.YEAR_INTERVAL_TYPES) {
            rules.add(interval, SqlTypeName.YEAR_INTERVAL_TYPES);
        }
        for (SqlTypeName interval : SqlTypeName.DAY_INTERVAL_TYPES) {
            rules.add(interval, SqlTypeName.DAY_INTERVAL_TYPES);
        }
        for (SqlTypeName interval : SqlTypeName.DAY_INTERVAL_TYPES) {
            Set<SqlTypeName> dayIntervalTypes = SqlTypeName.DAY_INTERVAL_TYPES;
            rules.add(interval, dayIntervalTypes);
        }
        rules.add(SqlTypeName.MULTISET, EnumSet.of(SqlTypeName.MULTISET));
        rules.add(SqlTypeName.TINYINT, EnumSet.of(SqlTypeName.TINYINT));
        rule.clear();
        rule.add(SqlTypeName.TINYINT);
        rule.add(SqlTypeName.SMALLINT);
        rules.add(SqlTypeName.SMALLINT, rule);
        rule.clear();
        rule.add(SqlTypeName.TINYINT);
        rule.add(SqlTypeName.SMALLINT);
        rule.add(SqlTypeName.INTEGER);
        rules.add(SqlTypeName.INTEGER, rule);
        rule.clear();
        rule.add(SqlTypeName.TINYINT);
        rule.add(SqlTypeName.SMALLINT);
        rule.add(SqlTypeName.INTEGER);
        rule.add(SqlTypeName.BIGINT);
        rules.add(SqlTypeName.BIGINT, rule);
        rule.clear();
        rule.add(SqlTypeName.TINYINT);
        rule.add(SqlTypeName.SMALLINT);
        rule.add(SqlTypeName.INTEGER);
        rule.add(SqlTypeName.BIGINT);
        rule.add(SqlTypeName.DECIMAL);
        rule.add(SqlTypeName.FLOAT);
        rules.add(SqlTypeName.FLOAT, rule);
        rule.clear();
        rule.add(SqlTypeName.TINYINT);
        rule.add(SqlTypeName.SMALLINT);
        rule.add(SqlTypeName.INTEGER);
        rule.add(SqlTypeName.BIGINT);
        rule.add(SqlTypeName.DECIMAL);
        rule.add(SqlTypeName.FLOAT);
        rule.add(SqlTypeName.REAL);
        rules.add(SqlTypeName.REAL, rule);
        rule.clear();
        rule.add(SqlTypeName.TINYINT);
        rule.add(SqlTypeName.SMALLINT);
        rule.add(SqlTypeName.INTEGER);
        rule.add(SqlTypeName.BIGINT);
        rule.add(SqlTypeName.DECIMAL);
        rule.add(SqlTypeName.FLOAT);
        rule.add(SqlTypeName.REAL);
        rule.add(SqlTypeName.DOUBLE);
        rules.add(SqlTypeName.DOUBLE, rule);
        rule.clear();
        rule.add(SqlTypeName.TINYINT);
        rule.add(SqlTypeName.SMALLINT);
        rule.add(SqlTypeName.INTEGER);
        rule.add(SqlTypeName.BIGINT);
        rule.add(SqlTypeName.REAL);
        rule.add(SqlTypeName.DOUBLE);
        rule.add(SqlTypeName.DECIMAL);
        rules.add(SqlTypeName.DECIMAL, rule);
        rule.clear();
        rule.add(SqlTypeName.VARBINARY);
        rule.add(SqlTypeName.BINARY);
        rules.add(SqlTypeName.VARBINARY, rule);
        rules.add(SqlTypeName.CHAR, EnumSet.of(SqlTypeName.CHAR));
        rule.clear();
        rule.add(SqlTypeName.CHAR);
        rule.add(SqlTypeName.VARCHAR);
        rules.add(SqlTypeName.VARCHAR, rule);
        rules.add(SqlTypeName.BOOLEAN, EnumSet.of(SqlTypeName.BOOLEAN));
        rule.clear();
        rule.add(SqlTypeName.BINARY);
        rule.add(SqlTypeName.VARBINARY);
        rules.add(SqlTypeName.BINARY, rule);
        rule.clear();
        rule.add(SqlTypeName.DATE);
        rule.add(SqlTypeName.TIMESTAMP);
        rules.add(SqlTypeName.DATE, rule);
        rule.clear();
        rule.add(SqlTypeName.TIME);
        rule.add(SqlTypeName.TIMESTAMP);
        rules.add(SqlTypeName.TIME, rule);
        rules.add(SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE, EnumSet.of(SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE));
        rules.add(SqlTypeName.TIMESTAMP, EnumSet.of(SqlTypeName.TIMESTAMP));
        rules.add(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, EnumSet.of(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE));
        rules.add(SqlTypeName.GEOMETRY, EnumSet.of(SqlTypeName.GEOMETRY));
        rules.add(SqlTypeName.ARRAY, EnumSet.of(SqlTypeName.ARRAY));
        rule.clear();
        rule.add(SqlTypeName.TINYINT);
        rule.add(SqlTypeName.SMALLINT);
        rule.add(SqlTypeName.INTEGER);
        rule.add(SqlTypeName.BIGINT);
        rule.add(SqlTypeName.DECIMAL);
        rule.add(SqlTypeName.FLOAT);
        rule.add(SqlTypeName.REAL);
        rule.add(SqlTypeName.TIME);
        rule.add(SqlTypeName.DATE);
        rule.add(SqlTypeName.TIMESTAMP);
        rules.add(SqlTypeName.ANY, rule);
        Builder coerceRules = new Builder(rules);
        rule.clear();
        rule.add(SqlTypeName.TINYINT);
        rule.add(SqlTypeName.SMALLINT);
        rule.add(SqlTypeName.INTEGER);
        rule.add(SqlTypeName.BIGINT);
        rule.add(SqlTypeName.DECIMAL);
        rule.add(SqlTypeName.FLOAT);
        rule.add(SqlTypeName.REAL);
        rule.add(SqlTypeName.DOUBLE);
        rule.add(SqlTypeName.CHAR);
        rule.add(SqlTypeName.VARCHAR);
        coerceRules.add(SqlTypeName.TINYINT, rule);
        coerceRules.add(SqlTypeName.SMALLINT, rule);
        coerceRules.add(SqlTypeName.INTEGER, rule);
        coerceRules.add(SqlTypeName.BIGINT, rule);
        coerceRules.add(SqlTypeName.FLOAT, rule);
        coerceRules.add(SqlTypeName.REAL, rule);
        coerceRules.add(SqlTypeName.DECIMAL, rule);
        coerceRules.add(SqlTypeName.DOUBLE, rule);
        coerceRules.add(SqlTypeName.CHAR, rule);
        coerceRules.add(SqlTypeName.VARCHAR, rule);
        for (SqlTypeName exactType : SqlTypeName.EXACT_TYPES) {
            coerceRules.add(exactType, (Set<SqlTypeName>)((Object)((ImmutableSet.Builder)coerceRules.copyValues(exactType).addAll(SqlTypeName.INTERVAL_TYPES)).build()));
        }
        for (SqlTypeName typeName : SqlTypeName.INTERVAL_TYPES) {
            coerceRules.add(typeName, (Set<SqlTypeName>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)coerceRules.copyValues(typeName).add((Object)SqlTypeName.TINYINT)).add((Object)SqlTypeName.SMALLINT)).add((Object)SqlTypeName.INTEGER)).add((Object)SqlTypeName.BIGINT)).add((Object)SqlTypeName.DECIMAL)).add((Object)SqlTypeName.VARCHAR)).build()));
        }
        coerceRules.add(SqlTypeName.VARCHAR, (Set<SqlTypeName>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)coerceRules.copyValues(SqlTypeName.VARCHAR).add((Object)SqlTypeName.BOOLEAN)).add((Object)SqlTypeName.DATE)).add((Object)SqlTypeName.TIME)).add((Object)SqlTypeName.TIMESTAMP)).addAll(SqlTypeName.INTERVAL_TYPES)).build()));
        coerceRules.add(SqlTypeName.CHAR, (Set<SqlTypeName>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)coerceRules.copyValues(SqlTypeName.CHAR).add((Object)SqlTypeName.BOOLEAN)).add((Object)SqlTypeName.DATE)).add((Object)SqlTypeName.TIME)).add((Object)SqlTypeName.TIMESTAMP)).addAll(SqlTypeName.INTERVAL_TYPES)).build()));
        coerceRules.add(SqlTypeName.BOOLEAN, (Set<SqlTypeName>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)coerceRules.copyValues(SqlTypeName.BOOLEAN).add((Object)SqlTypeName.CHAR)).add((Object)SqlTypeName.VARCHAR)).build()));
        coerceRules.add(SqlTypeName.DATE, (Set<SqlTypeName>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)coerceRules.copyValues(SqlTypeName.DATE).add((Object)SqlTypeName.DATE)).add((Object)SqlTypeName.TIMESTAMP)).add((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE)).add((Object)SqlTypeName.CHAR)).add((Object)SqlTypeName.VARCHAR)).build()));
        coerceRules.add(SqlTypeName.TIME, (Set<SqlTypeName>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)coerceRules.copyValues(SqlTypeName.TIME).add((Object)SqlTypeName.TIME)).add((Object)SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE)).add((Object)SqlTypeName.TIMESTAMP)).add((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE)).add((Object)SqlTypeName.CHAR)).add((Object)SqlTypeName.VARCHAR)).build()));
        coerceRules.add(SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE, (Set<SqlTypeName>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)coerceRules.copyValues(SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE).add((Object)SqlTypeName.TIME)).add((Object)SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE)).add((Object)SqlTypeName.TIMESTAMP)).add((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE)).add((Object)SqlTypeName.CHAR)).add((Object)SqlTypeName.VARCHAR)).build()));
        coerceRules.add(SqlTypeName.TIMESTAMP, (Set<SqlTypeName>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)coerceRules.copyValues(SqlTypeName.TIMESTAMP).add((Object)SqlTypeName.TIMESTAMP)).add((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE)).add((Object)SqlTypeName.DATE)).add((Object)SqlTypeName.TIME)).add((Object)SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE)).add((Object)SqlTypeName.CHAR)).add((Object)SqlTypeName.VARCHAR)).build()));
        coerceRules.add(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, (Set<SqlTypeName>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)coerceRules.copyValues(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE).add((Object)SqlTypeName.TIMESTAMP)).add((Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE)).add((Object)SqlTypeName.DATE)).add((Object)SqlTypeName.TIME)).add((Object)SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE)).add((Object)SqlTypeName.CHAR)).add((Object)SqlTypeName.VARCHAR)).build()));
        INSTANCE = new SqlTypeAssignmentRules(rules.map);
        COERCE_INSTANCE = new SqlTypeAssignmentRules(coerceRules.map);
    }

    private static class Builder {
        final Map<SqlTypeName, ImmutableSet<SqlTypeName>> map;
        final LoadingCache<Set<SqlTypeName>, ImmutableSet<SqlTypeName>> sets;

        Builder() {
            this.map = new HashMap<SqlTypeName, ImmutableSet<SqlTypeName>>();
            this.sets = CacheBuilder.newBuilder().build(CacheLoader.from(set -> Sets.immutableEnumSet(set)));
        }

        Builder(Builder builder) {
            this.map = new HashMap<SqlTypeName, ImmutableSet<SqlTypeName>>(builder.map);
            this.sets = builder.sets;
        }

        void add(SqlTypeName fromType, Set<SqlTypeName> toTypes) {
            try {
                this.map.put(fromType, this.sets.get(toTypes));
            }
            catch (ExecutionException e2) {
                throw new RuntimeException("populating SqlTypeAssignmentRules", e2);
            }
        }

        ImmutableSet.Builder<SqlTypeName> copyValues(SqlTypeName typeName) {
            return ImmutableSet.builder().addAll(this.map.get((Object)typeName));
        }
    }
}

