/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.parser;

import java.io.StringReader;
import java.util.Objects;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.config.Lex;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlAbstractParserImpl;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParserImplFactory;
import org.apache.calcite.sql.parser.impl.SqlParserImpl;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlDelegatingConformance;

public class SqlParser {
    public static final int DEFAULT_IDENTIFIER_MAX_LENGTH = 128;
    @Deprecated
    public static final boolean DEFAULT_ALLOW_BANG_EQUAL = SqlConformanceEnum.DEFAULT.isBangEqualAllowed();
    private final SqlAbstractParserImpl parser;
    private final String originalInput;

    private SqlParser(String s, SqlAbstractParserImpl parser, Config config) {
        this.originalInput = s;
        this.parser = parser;
        parser.setOriginalSql(s);
        parser.setTabSize(1);
        parser.setQuotedCasing(config.quotedCasing());
        parser.setUnquotedCasing(config.unquotedCasing());
        parser.setIdentifierMaxLength(config.identifierMaxLength());
        parser.setConformance(config.conformance());
        switch (config.quoting()) {
            case DOUBLE_QUOTE: {
                parser.switchTo("DQID");
                break;
            }
            case BACK_TICK: {
                parser.switchTo("BTID");
                break;
            }
            case BRACKET: {
                parser.switchTo("DEFAULT");
            }
        }
    }

    public static SqlParser create(String s) {
        return SqlParser.create(s, SqlParser.configBuilder().build());
    }

    public static SqlParser create(String sql, Config config) {
        SqlAbstractParserImpl parser = config.parserFactory().getParser(new StringReader(sql));
        return new SqlParser(sql, parser, config);
    }

    public SqlNode parseExpression() throws SqlParseException {
        try {
            return this.parser.parseSqlExpressionEof();
        }
        catch (Throwable ex) {
            if (ex instanceof CalciteContextException && this.originalInput != null) {
                ((CalciteContextException)ex).setOriginalStatement(this.originalInput);
            }
            throw this.parser.normalizeException(ex);
        }
    }

    public SqlNode parseQuery() throws SqlParseException {
        try {
            return this.parser.parseSqlStmtEof();
        }
        catch (Throwable ex) {
            if (ex instanceof CalciteContextException && this.originalInput != null) {
                ((CalciteContextException)ex).setOriginalStatement(this.originalInput);
            }
            throw this.parser.normalizeException(ex);
        }
    }

    public SqlNode parseQuery(String sql) throws SqlParseException {
        this.parser.ReInit(new StringReader(sql));
        return this.parseQuery();
    }

    public SqlNode parseStmt() throws SqlParseException {
        return this.parseQuery();
    }

    public SqlAbstractParserImpl.Metadata getMetadata() {
        return this.parser.getMetadata();
    }

    public static ConfigBuilder configBuilder() {
        return new ConfigBuilder();
    }

    public static ConfigBuilder configBuilder(Config config) {
        return new ConfigBuilder().setConfig(config);
    }

    private static class ConfigImpl
    implements Config {
        private final int identifierMaxLength;
        private final boolean caseSensitive;
        private final SqlConformance conformance;
        private final Casing quotedCasing;
        private final Casing unquotedCasing;
        private final Quoting quoting;
        private final SqlParserImplFactory parserFactory;

        private ConfigImpl(int identifierMaxLength, Casing quotedCasing, Casing unquotedCasing, Quoting quoting, boolean caseSensitive, SqlConformance conformance, SqlParserImplFactory parserFactory) {
            this.identifierMaxLength = identifierMaxLength;
            this.caseSensitive = caseSensitive;
            this.conformance = Objects.requireNonNull(conformance);
            this.quotedCasing = Objects.requireNonNull(quotedCasing);
            this.unquotedCasing = Objects.requireNonNull(unquotedCasing);
            this.quoting = Objects.requireNonNull(quoting);
            this.parserFactory = Objects.requireNonNull(parserFactory);
        }

        @Override
        public int identifierMaxLength() {
            return this.identifierMaxLength;
        }

        @Override
        public Casing quotedCasing() {
            return this.quotedCasing;
        }

        @Override
        public Casing unquotedCasing() {
            return this.unquotedCasing;
        }

        @Override
        public Quoting quoting() {
            return this.quoting;
        }

        @Override
        public boolean caseSensitive() {
            return this.caseSensitive;
        }

        @Override
        public SqlConformance conformance() {
            return this.conformance;
        }

        @Override
        public boolean allowBangEqual() {
            return this.conformance.isBangEqualAllowed();
        }

        @Override
        public SqlParserImplFactory parserFactory() {
            return this.parserFactory;
        }
    }

    public static class ConfigBuilder {
        private Casing quotedCasing;
        private Casing unquotedCasing;
        private Quoting quoting;
        private int identifierMaxLength;
        private boolean caseSensitive;
        private SqlConformance conformance;
        private SqlParserImplFactory parserFactory;

        private ConfigBuilder() {
            this.quotedCasing = Lex.ORACLE.quotedCasing;
            this.unquotedCasing = Lex.ORACLE.unquotedCasing;
            this.quoting = Lex.ORACLE.quoting;
            this.identifierMaxLength = 128;
            this.caseSensitive = Lex.ORACLE.caseSensitive;
            this.conformance = SqlConformanceEnum.DEFAULT;
            this.parserFactory = SqlParserImpl.FACTORY;
        }

        public ConfigBuilder setConfig(Config config) {
            this.quotedCasing = config.quotedCasing();
            this.unquotedCasing = config.unquotedCasing();
            this.quoting = config.quoting();
            this.identifierMaxLength = config.identifierMaxLength();
            this.conformance = config.conformance();
            this.parserFactory = config.parserFactory();
            return this;
        }

        public ConfigBuilder setQuotedCasing(Casing quotedCasing) {
            this.quotedCasing = Objects.requireNonNull(quotedCasing);
            return this;
        }

        public ConfigBuilder setUnquotedCasing(Casing unquotedCasing) {
            this.unquotedCasing = Objects.requireNonNull(unquotedCasing);
            return this;
        }

        public ConfigBuilder setQuoting(Quoting quoting) {
            this.quoting = Objects.requireNonNull(quoting);
            return this;
        }

        public ConfigBuilder setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        public ConfigBuilder setIdentifierMaxLength(int identifierMaxLength) {
            this.identifierMaxLength = identifierMaxLength;
            return this;
        }

        @Deprecated
        public ConfigBuilder setAllowBangEqual(final boolean allowBangEqual) {
            if (allowBangEqual != this.conformance.isBangEqualAllowed()) {
                this.setConformance(new SqlDelegatingConformance(this.conformance){

                    @Override
                    public boolean isBangEqualAllowed() {
                        return allowBangEqual;
                    }
                });
            }
            return this;
        }

        public ConfigBuilder setConformance(SqlConformance conformance) {
            this.conformance = conformance;
            return this;
        }

        public ConfigBuilder setParserFactory(SqlParserImplFactory factory) {
            this.parserFactory = Objects.requireNonNull(factory);
            return this;
        }

        public ConfigBuilder setLex(Lex lex) {
            this.setCaseSensitive(lex.caseSensitive);
            this.setUnquotedCasing(lex.unquotedCasing);
            this.setQuotedCasing(lex.quotedCasing);
            this.setQuoting(lex.quoting);
            return this;
        }

        public Config build() {
            return new ConfigImpl(this.identifierMaxLength, this.quotedCasing, this.unquotedCasing, this.quoting, this.caseSensitive, this.conformance, this.parserFactory);
        }
    }

    public static interface Config {
        public static final Config DEFAULT = SqlParser.configBuilder().build();

        public int identifierMaxLength();

        public Casing quotedCasing();

        public Casing unquotedCasing();

        public Quoting quoting();

        public boolean caseSensitive();

        public SqlConformance conformance();

        @Deprecated
        public boolean allowBangEqual();

        public SqlParserImplFactory parserFactory();
    }
}

