/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.materialize;

import java.io.PrintWriter;
import java.util.List;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.algorithm.Algorithm;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.algorithm.Result;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.algorithm.impl.MonteCarloAlgorithm;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.algorithm.util.ArgumentUtils;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.model.Aggregate;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.model.Attribute;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.model.Dialect;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.model.Dimension;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.model.Measure;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.model.Schema;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.model.StatisticsProvider;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.model.Table;

public class TileSuggester {
    private final Lattice lattice;

    public TileSuggester(Lattice lattice) {
        this.lattice = lattice;
    }

    public Iterable<? extends Lattice.Tile> tiles() {
        MonteCarloAlgorithm algorithm = new MonteCarloAlgorithm();
        PrintWriter pw = Util.printWriter(System.out);
        ArgumentUtils.TextProgress progress = new ArgumentUtils.TextProgress(pw);
        StatisticsProviderImpl statisticsProvider = new StatisticsProviderImpl(this.lattice);
        double f = statisticsProvider.getFactRowCount();
        ImmutableMap.Builder<Algorithm.ParameterEnum, Number> map2 = ImmutableMap.builder();
        if (this.lattice.algorithmMaxMillis >= 0L) {
            map2.put(Algorithm.ParameterEnum.timeLimitSeconds, Math.max(1, (int)(this.lattice.algorithmMaxMillis / 1000L)));
        }
        map2.put(Algorithm.ParameterEnum.aggregateLimit, 3);
        map2.put(Algorithm.ParameterEnum.costLimit, f * 5.0);
        SchemaImpl schema2 = new SchemaImpl(this.lattice, statisticsProvider);
        Result result = algorithm.run(schema2, map2.build(), progress);
        ImmutableList.Builder tiles = ImmutableList.builder();
        for (Aggregate aggregate : result.getAggregates()) {
            tiles.add(this.toTile(aggregate));
        }
        return tiles.build();
    }

    private Lattice.Tile toTile(Aggregate aggregate) {
        Lattice.TileBuilder tileBuilder = new Lattice.TileBuilder();
        for (Lattice.Measure measure : this.lattice.defaultMeasures) {
            tileBuilder.addMeasure(measure);
        }
        for (Attribute attribute : aggregate.getAttributes()) {
            tileBuilder.addDimension(((AttributeImpl)attribute).column);
        }
        return tileBuilder.build();
    }

    private static class StatisticsProviderImpl
    implements StatisticsProvider {
        private final Lattice lattice;

        StatisticsProviderImpl(Lattice lattice) {
            this.lattice = lattice;
        }

        @Override
        public double getFactRowCount() {
            return this.lattice.getFactRowCount();
        }

        @Override
        public double getRowCount(List<Attribute> attributes) {
            return this.lattice.getRowCount(Util.transform(attributes, input -> ((AttributeImpl)input).column));
        }

        @Override
        public double getSpace(List<Attribute> attributes) {
            return attributes.size();
        }

        @Override
        public double getLoadTime(List<Attribute> attributes) {
            return this.getSpace(attributes) * this.getRowCount(attributes);
        }
    }

    private static class AttributeImpl
    implements Attribute {
        private final Lattice.Column column;
        private final TableImpl table;

        private AttributeImpl(Lattice.Column column, TableImpl table) {
            this.column = column;
            this.table = table;
        }

        public String toString() {
            return this.getLabel();
        }

        @Override
        public String getLabel() {
            return this.column.alias;
        }

        @Override
        public Table getTable() {
            return this.table;
        }

        @Override
        public double estimateSpace() {
            return 0.0;
        }

        @Override
        public String getCandidateColumnName() {
            return null;
        }

        @Override
        public String getDatatype(Dialect dialect) {
            return null;
        }

        @Override
        public List<Attribute> getAncestorAttributes() {
            return ImmutableList.of();
        }
    }

    private static class TableImpl
    implements Table {
        private TableImpl() {
        }

        @Override
        public String getLabel() {
            return "TABLE";
        }

        @Override
        public Table getParent() {
            return null;
        }
    }

    private static class SchemaImpl
    implements Schema {
        private final StatisticsProvider statisticsProvider;
        private final TableImpl table;
        private final ImmutableList<AttributeImpl> attributes;

        SchemaImpl(Lattice lattice, StatisticsProvider statisticsProvider) {
            this.statisticsProvider = statisticsProvider;
            this.table = new TableImpl();
            ImmutableList.Builder attributeBuilder = ImmutableList.builder();
            for (Lattice.Column column : lattice.columns) {
                attributeBuilder.add(new AttributeImpl(column, this.table));
            }
            this.attributes = attributeBuilder.build();
        }

        @Override
        public List<? extends Table> getTables() {
            return ImmutableList.of(this.table);
        }

        @Override
        public List<Measure> getMeasures() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<? extends Dimension> getDimensions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<? extends Attribute> getAttributes() {
            return this.attributes;
        }

        @Override
        public StatisticsProvider getStatisticsProvider() {
            return this.statisticsProvider;
        }

        @Override
        public Dialect getDialect() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String generateAggregateSql(Aggregate aggregate, List<String> columnNameList) {
            throw new UnsupportedOperationException();
        }
    }
}

