/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.shaded.hadoop2.com.google.common.base.Stopwatch;
import org.apache.flink.shaded.hadoop2.com.google.common.collect.Lists;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.mapred.LocatedFileStatusFetcher;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.InvalidInputException;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class FileInputFormat<K, V>
extends InputFormat<K, V> {
    public static final String INPUT_DIR = "mapreduce.input.fileinputformat.inputdir";
    public static final String SPLIT_MAXSIZE = "mapreduce.input.fileinputformat.split.maxsize";
    public static final String SPLIT_MINSIZE = "mapreduce.input.fileinputformat.split.minsize";
    public static final String PATHFILTER_CLASS = "mapreduce.input.pathFilter.class";
    public static final String NUM_INPUT_FILES = "mapreduce.input.fileinputformat.numinputfiles";
    public static final String INPUT_DIR_RECURSIVE = "mapreduce.input.fileinputformat.input.dir.recursive";
    public static final String LIST_STATUS_NUM_THREADS = "mapreduce.input.fileinputformat.list-status.num-threads";
    public static final int DEFAULT_LIST_STATUS_NUM_THREADS = 1;
    private static final Log LOG = LogFactory.getLog(FileInputFormat.class);
    private static final double SPLIT_SLOP = 1.1;
    private static final PathFilter hiddenFileFilter = new PathFilter(){

        @Override
        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };

    public static void setInputDirRecursive(Job job, boolean inputDirRecursive) {
        job.getConfiguration().setBoolean(INPUT_DIR_RECURSIVE, inputDirRecursive);
    }

    public static boolean getInputDirRecursive(JobContext job) {
        return job.getConfiguration().getBoolean(INPUT_DIR_RECURSIVE, false);
    }

    protected long getFormatMinSplitSize() {
        return 1L;
    }

    protected boolean isSplitable(JobContext context, Path filename) {
        return true;
    }

    public static void setInputPathFilter(Job job, Class<? extends PathFilter> filter) {
        job.getConfiguration().setClass(PATHFILTER_CLASS, filter, PathFilter.class);
    }

    public static void setMinInputSplitSize(Job job, long size) {
        job.getConfiguration().setLong(SPLIT_MINSIZE, size);
    }

    public static long getMinSplitSize(JobContext job) {
        return job.getConfiguration().getLong(SPLIT_MINSIZE, 1L);
    }

    public static void setMaxInputSplitSize(Job job, long size) {
        job.getConfiguration().setLong(SPLIT_MAXSIZE, size);
    }

    public static long getMaxSplitSize(JobContext context) {
        return context.getConfiguration().getLong(SPLIT_MAXSIZE, Long.MAX_VALUE);
    }

    public static PathFilter getInputPathFilter(JobContext context) {
        Configuration conf = context.getConfiguration();
        Class<PathFilter> filterClass = conf.getClass(PATHFILTER_CLASS, null, PathFilter.class);
        return filterClass != null ? ReflectionUtils.newInstance(filterClass, conf) : null;
    }

    protected List<FileStatus> listStatus(JobContext job) throws IOException {
        Path[] dirs = FileInputFormat.getInputPaths(job);
        if (dirs.length == 0) {
            throw new IOException("No input paths specified in job");
        }
        TokenCache.obtainTokensForNamenodes(job.getCredentials(), dirs, job.getConfiguration());
        boolean recursive = FileInputFormat.getInputDirRecursive(job);
        ArrayList<PathFilter> filters = new ArrayList<PathFilter>();
        filters.add(hiddenFileFilter);
        PathFilter jobFilter = FileInputFormat.getInputPathFilter(job);
        if (jobFilter != null) {
            filters.add(jobFilter);
        }
        MultiPathFilter inputFilter = new MultiPathFilter(filters);
        List<FileStatus> result = null;
        int numThreads = job.getConfiguration().getInt(LIST_STATUS_NUM_THREADS, 1);
        Stopwatch sw = new Stopwatch().start();
        if (numThreads == 1) {
            result = this.singleThreadedListStatus(job, dirs, inputFilter, recursive);
        } else {
            Iterable<FileStatus> locatedFiles = null;
            try {
                LocatedFileStatusFetcher locatedFileStatusFetcher = new LocatedFileStatusFetcher(job.getConfiguration(), dirs, recursive, inputFilter, true);
                locatedFiles = locatedFileStatusFetcher.getFileStatuses();
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while getting file statuses");
            }
            result = Lists.newArrayList(locatedFiles);
        }
        sw.stop();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Time taken to get FileStatuses: " + sw.elapsedMillis()));
        }
        LOG.info((Object)("Total input paths to process : " + result.size()));
        return result;
    }

    private List<FileStatus> singleThreadedListStatus(JobContext job, Path[] dirs, PathFilter inputFilter, boolean recursive) throws IOException {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        ArrayList<IOException> errors = new ArrayList<IOException>();
        for (int i = 0; i < dirs.length; ++i) {
            Path p = dirs[i];
            FileSystem fs = p.getFileSystem(job.getConfiguration());
            FileStatus[] matches = fs.globStatus(p, inputFilter);
            if (matches == null) {
                errors.add(new IOException("Input path does not exist: " + p));
                continue;
            }
            if (matches.length == 0) {
                errors.add(new IOException("Input Pattern " + p + " matches 0 files"));
                continue;
            }
            for (FileStatus globStat : matches) {
                if (globStat.isDirectory()) {
                    RemoteIterator<LocatedFileStatus> iter = fs.listLocatedStatus(globStat.getPath());
                    while (iter.hasNext()) {
                        LocatedFileStatus stat = iter.next();
                        if (!inputFilter.accept(stat.getPath())) continue;
                        if (recursive && stat.isDirectory()) {
                            this.addInputPathRecursively(result, fs, stat.getPath(), inputFilter);
                            continue;
                        }
                        result.add(stat);
                    }
                    continue;
                }
                result.add(globStat);
            }
        }
        if (!errors.isEmpty()) {
            throw new InvalidInputException(errors);
        }
        return result;
    }

    protected void addInputPathRecursively(List<FileStatus> result, FileSystem fs, Path path, PathFilter inputFilter) throws IOException {
        RemoteIterator<LocatedFileStatus> iter = fs.listLocatedStatus(path);
        while (iter.hasNext()) {
            LocatedFileStatus stat = iter.next();
            if (!inputFilter.accept(stat.getPath())) continue;
            if (stat.isDirectory()) {
                this.addInputPathRecursively(result, fs, stat.getPath(), inputFilter);
                continue;
            }
            result.add(stat);
        }
    }

    protected FileSplit makeSplit(Path file, long start, long length, String[] hosts) {
        return new FileSplit(file, start, length, hosts);
    }

    @Override
    public List<InputSplit> getSplits(JobContext job) throws IOException {
        Stopwatch sw = new Stopwatch().start();
        long minSize = Math.max(this.getFormatMinSplitSize(), FileInputFormat.getMinSplitSize(job));
        long maxSize = FileInputFormat.getMaxSplitSize(job);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        List<FileStatus> files = this.listStatus(job);
        for (FileStatus file : files) {
            Path path = file.getPath();
            long length = file.getLen();
            if (length != 0L) {
                BlockLocation[] blkLocations;
                if (file instanceof LocatedFileStatus) {
                    blkLocations = ((LocatedFileStatus)file).getBlockLocations();
                } else {
                    FileSystem fs = path.getFileSystem(job.getConfiguration());
                    blkLocations = fs.getFileBlockLocations(file, 0L, length);
                }
                if (this.isSplitable(job, path)) {
                    int blkIndex;
                    long blockSize = file.getBlockSize();
                    long splitSize = this.computeSplitSize(blockSize, minSize, maxSize);
                    long bytesRemaining = length;
                    while ((double)bytesRemaining / (double)splitSize > 1.1) {
                        blkIndex = this.getBlockIndex(blkLocations, length - bytesRemaining);
                        splits.add(this.makeSplit(path, length - bytesRemaining, splitSize, blkLocations[blkIndex].getHosts()));
                        bytesRemaining -= splitSize;
                    }
                    if (bytesRemaining == 0L) continue;
                    blkIndex = this.getBlockIndex(blkLocations, length - bytesRemaining);
                    splits.add(this.makeSplit(path, length - bytesRemaining, bytesRemaining, blkLocations[blkIndex].getHosts()));
                    continue;
                }
                splits.add(this.makeSplit(path, 0L, length, blkLocations[0].getHosts()));
                continue;
            }
            splits.add(this.makeSplit(path, 0L, length, new String[0]));
        }
        job.getConfiguration().setLong(NUM_INPUT_FILES, files.size());
        sw.stop();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Total # of splits generated by getSplits: " + splits.size() + ", TimeTaken: " + sw.elapsedMillis()));
        }
        return splits;
    }

    protected long computeSplitSize(long blockSize, long minSize, long maxSize) {
        return Math.max(minSize, Math.min(maxSize, blockSize));
    }

    protected int getBlockIndex(BlockLocation[] blkLocations, long offset) {
        for (int i = 0; i < blkLocations.length; ++i) {
            if (blkLocations[i].getOffset() > offset || offset >= blkLocations[i].getOffset() + blkLocations[i].getLength()) continue;
            return i;
        }
        BlockLocation last = blkLocations[blkLocations.length - 1];
        long fileLength = last.getOffset() + last.getLength() - 1L;
        throw new IllegalArgumentException("Offset " + offset + " is outside of file (0.." + fileLength + ")");
    }

    public static void setInputPaths(Job job, String commaSeparatedPaths) throws IOException {
        FileInputFormat.setInputPaths(job, StringUtils.stringToPath(FileInputFormat.getPathStrings(commaSeparatedPaths)));
    }

    public static void addInputPaths(Job job, String commaSeparatedPaths) throws IOException {
        for (String str : FileInputFormat.getPathStrings(commaSeparatedPaths)) {
            FileInputFormat.addInputPath(job, new Path(str));
        }
    }

    public static void setInputPaths(Job job, Path ... inputPaths) throws IOException {
        Configuration conf = job.getConfiguration();
        Path path = inputPaths[0].getFileSystem(conf).makeQualified(inputPaths[0]);
        StringBuffer str = new StringBuffer(StringUtils.escapeString(path.toString()));
        for (int i = 1; i < inputPaths.length; ++i) {
            str.append(",");
            path = inputPaths[i].getFileSystem(conf).makeQualified(inputPaths[i]);
            str.append(StringUtils.escapeString(path.toString()));
        }
        conf.set(INPUT_DIR, str.toString());
    }

    public static void addInputPath(Job job, Path path) throws IOException {
        Configuration conf = job.getConfiguration();
        path = path.getFileSystem(conf).makeQualified(path);
        String dirStr = StringUtils.escapeString(path.toString());
        String dirs = conf.get(INPUT_DIR);
        conf.set(INPUT_DIR, dirs == null ? dirStr : dirs + "," + dirStr);
    }

    private static String[] getPathStrings(String commaSeparatedPaths) {
        int length = commaSeparatedPaths.length();
        int curlyOpen = 0;
        int pathStart = 0;
        boolean globPattern = false;
        ArrayList<String> pathStrings = new ArrayList<String>();
        block5: for (int i = 0; i < length; ++i) {
            char ch = commaSeparatedPaths.charAt(i);
            switch (ch) {
                case '{': {
                    ++curlyOpen;
                    if (globPattern) continue block5;
                    globPattern = true;
                    continue block5;
                }
                case '}': {
                    if (--curlyOpen != 0 || !globPattern) continue block5;
                    globPattern = false;
                    continue block5;
                }
                case ',': {
                    if (globPattern) continue block5;
                    pathStrings.add(commaSeparatedPaths.substring(pathStart, i));
                    pathStart = i + 1;
                    continue block5;
                }
                default: {
                    continue block5;
                }
            }
        }
        pathStrings.add(commaSeparatedPaths.substring(pathStart, length));
        return pathStrings.toArray(new String[0]);
    }

    public static Path[] getInputPaths(JobContext context) {
        String dirs = context.getConfiguration().get(INPUT_DIR, "");
        String[] list = StringUtils.split(dirs);
        Path[] result = new Path[list.length];
        for (int i = 0; i < list.length; ++i) {
            result[i] = new Path(StringUtils.unEscapeString(list[i]));
        }
        return result;
    }

    private static class MultiPathFilter
    implements PathFilter {
        private List<PathFilter> filters;

        public MultiPathFilter(List<PathFilter> filters) {
            this.filters = filters;
        }

        @Override
        public boolean accept(Path path) {
            for (PathFilter filter : this.filters) {
                if (filter.accept(path)) continue;
                return false;
            }
            return true;
        }
    }

    @Deprecated
    public static enum Counter {
        BYTES_READ;

    }
}

