/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.shaded.hadoop2.com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ExactSizeInputStream
extends FilterInputStream {
    private int remaining;

    public ExactSizeInputStream(InputStream in, int numBytes) {
        super(in);
        Preconditions.checkArgument(numBytes >= 0, "Negative expected bytes: ", numBytes);
        this.remaining = numBytes;
    }

    @Override
    public int available() throws IOException {
        return Math.min(super.available(), this.remaining);
    }

    @Override
    public int read() throws IOException {
        if (this.remaining <= 0) {
            return -1;
        }
        int result = super.read();
        if (result >= 0) {
            --this.remaining;
        } else if (this.remaining > 0) {
            throw new EOFException("Premature EOF. Expected " + this.remaining + "more bytes");
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.remaining <= 0) {
            return -1;
        }
        int result = super.read(b, off, len = Math.min(len, this.remaining));
        if (result >= 0) {
            this.remaining -= result;
        } else if (this.remaining > 0) {
            throw new EOFException("Premature EOF. Expected " + this.remaining + "more bytes");
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        long result = super.skip(Math.min(n, (long)this.remaining));
        if (result > 0L) {
            this.remaining = (int)((long)this.remaining - result);
        } else if (this.remaining > 0) {
            throw new EOFException("Premature EOF. Expected " + this.remaining + "more bytes");
        }
        return result;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }
}

