/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.flink.shaded.hadoop2.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.shaded.hadoop2.com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.PathIsNotDirectoryException;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LayoutFlags;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageCompression;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatProtobuf;
import org.apache.hadoop.hdfs.server.namenode.FSImageSerialization;
import org.apache.hadoop.hdfs.server.namenode.FSImageUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FileUnderConstructionFeature;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectorySnapshottable;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotFSImageFormat;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Phase;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Step;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StepType;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FSImageFormat {
    private static final Log LOG = FSImage.LOG;
    @VisibleForTesting
    public static final TreeMap<String, String> renameReservedMap = new TreeMap();
    private static final String RESERVED_ERROR_MSG = "/.reserved is a reserved path and .snapshot is a reserved path component in this version of HDFS. Please rollback and delete or rename this path, or upgrade with the " + HdfsServerConstants.StartupOption.RENAMERESERVED.getName() + " [key-value pairs]" + " option to automatically rename these paths during upgrade.";

    private FSImageFormat() {
    }

    public static LoaderDelegator newLoader(Configuration conf, FSNamesystem fsn) {
        return new LoaderDelegator(conf, fsn);
    }

    @VisibleForTesting
    public static void useDefaultRenameReservedPairs() {
        renameReservedMap.clear();
        for (String key : HdfsConstants.RESERVED_PATH_COMPONENTS) {
            renameReservedMap.put(key, key + "." + HdfsConstants.NAMENODE_LAYOUT_VERSION + "." + "UPGRADE_RENAMED");
        }
    }

    @VisibleForTesting
    public static void setRenameReservedPairs(String renameReserved) {
        FSImageFormat.useDefaultRenameReservedPairs();
        FSImageFormat.setRenameReservedMapInternal(renameReserved);
    }

    private static void setRenameReservedMapInternal(String renameReserved) {
        Collection<String> pairs = StringUtils.getTrimmedStringCollection(renameReserved);
        for (String p : pairs) {
            String[] pair = StringUtils.split(p, '/', '=');
            Preconditions.checkArgument(pair.length == 2, "Could not parse key-value pair " + p);
            String key = pair[0];
            String value = pair[1];
            Preconditions.checkArgument(DFSUtil.isReservedPathComponent(key), "Unknown reserved path " + key);
            Preconditions.checkArgument(DFSUtil.isValidNameForComponent(value), "Invalid rename path for " + key + ": " + value);
            LOG.info((Object)("Will rename reserved path " + key + " to " + value));
            renameReservedMap.put(key, value);
        }
    }

    static String renameReservedPathsOnUpgrade(String path, int layoutVersion) {
        String[] components;
        String oldPath = path;
        if (!NameNodeLayoutVersion.supports(LayoutVersion.Feature.ADD_INODE_ID, layoutVersion) && (components = INode.getPathNames(path)).length > 1) {
            components[1] = DFSUtil.bytes2String(FSImageFormat.renameReservedRootComponentOnUpgrade(DFSUtil.string2Bytes(components[1]), layoutVersion));
            path = DFSUtil.strings2PathString(components);
        }
        if (!NameNodeLayoutVersion.supports(LayoutVersion.Feature.SNAPSHOT, layoutVersion)) {
            components = INode.getPathNames(path);
            if (components.length == 0) {
                return path;
            }
            for (int i = 0; i < components.length; ++i) {
                components[i] = DFSUtil.bytes2String(FSImageFormat.renameReservedComponentOnUpgrade(DFSUtil.string2Bytes(components[i]), layoutVersion));
            }
            path = DFSUtil.strings2PathString(components);
        }
        if (!path.equals(oldPath)) {
            LOG.info((Object)("Upgrade process renamed reserved path " + oldPath + " to " + path));
        }
        return path;
    }

    private static byte[] renameReservedComponentOnUpgrade(byte[] component, int layoutVersion) {
        if (!NameNodeLayoutVersion.supports(LayoutVersion.Feature.SNAPSHOT, layoutVersion) && Arrays.equals(component, HdfsConstants.DOT_SNAPSHOT_DIR_BYTES)) {
            Preconditions.checkArgument(renameReservedMap != null && renameReservedMap.containsKey(".snapshot"), RESERVED_ERROR_MSG);
            component = DFSUtil.string2Bytes(renameReservedMap.get(".snapshot"));
        }
        return component;
    }

    private static byte[] renameReservedRootComponentOnUpgrade(byte[] component, int layoutVersion) {
        if (!NameNodeLayoutVersion.supports(LayoutVersion.Feature.ADD_INODE_ID, layoutVersion) && Arrays.equals(component, FSDirectory.DOT_RESERVED)) {
            Preconditions.checkArgument(renameReservedMap != null && renameReservedMap.containsKey(".reserved"), RESERVED_ERROR_MSG);
            String renameString = renameReservedMap.get(".reserved");
            component = DFSUtil.string2Bytes(renameString);
            LOG.info((Object)("Renamed root path .reserved to " + renameString));
        }
        return component;
    }

    public static class Loader
    implements AbstractLoader {
        private final Configuration conf;
        private final FSNamesystem namesystem;
        private boolean loaded = false;
        private long imgTxId;
        private MD5Hash imgDigest;
        private Map<Integer, Snapshot> snapshotMap = null;
        private final SnapshotFSImageFormat.ReferenceMap referenceMap = new SnapshotFSImageFormat.ReferenceMap();

        Loader(Configuration conf, FSNamesystem namesystem) {
            this.conf = conf;
            this.namesystem = namesystem;
        }

        @Override
        public MD5Hash getLoadedImageMd5() {
            this.checkLoaded();
            return this.imgDigest;
        }

        @Override
        public long getLoadedImageTxId() {
            this.checkLoaded();
            return this.imgTxId;
        }

        private void checkLoaded() {
            if (!this.loaded) {
                throw new IllegalStateException("Image not yet loaded!");
            }
        }

        private void checkNotLoaded() {
            if (this.loaded) {
                throw new IllegalStateException("Image already loaded!");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load(File curFile) throws IOException {
            this.checkNotLoaded();
            assert (curFile != null) : "curFile is null";
            StartupProgress prog = NameNode.getStartupProgress();
            Step step = new Step(StepType.INODES);
            prog.beginStep(Phase.LOADING_FSIMAGE, step);
            long startTime = Time.now();
            MessageDigest digester = MD5Hash.getDigester();
            DigestInputStream fin = new DigestInputStream(new FileInputStream(curFile), digester);
            DataInputStream in = new DataInputStream(fin);
            try {
                boolean eof;
                int imgVersion = in.readInt();
                if (this.getLayoutVersion() != imgVersion) {
                    throw new InconsistentFSStateException(curFile, "imgVersion " + imgVersion + " expected to be " + this.getLayoutVersion());
                }
                boolean supportSnapshot = NameNodeLayoutVersion.supports(LayoutVersion.Feature.SNAPSHOT, imgVersion);
                if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.ADD_LAYOUT_FLAGS, imgVersion)) {
                    LayoutFlags.read(in);
                }
                in.readInt();
                long numFiles = in.readLong();
                long genstamp = in.readLong();
                this.namesystem.setGenerationStampV1(genstamp);
                if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.SEQUENTIAL_BLOCK_ID, imgVersion)) {
                    genstamp = in.readLong();
                    this.namesystem.setGenerationStampV2(genstamp);
                    long stampAtIdSwitch = in.readLong();
                    this.namesystem.setGenerationStampV1Limit(stampAtIdSwitch);
                    long maxSequentialBlockId = in.readLong();
                    this.namesystem.setLastAllocatedBlockId(maxSequentialBlockId);
                } else {
                    long startingGenStamp = this.namesystem.upgradeGenerationStampToV2();
                    LOG.info((Object)("Upgrading to sequential block IDs. Generation stamp for new blocks set to " + startingGenStamp));
                }
                this.imgTxId = NameNodeLayoutVersion.supports(LayoutVersion.Feature.STORED_TXIDS, imgVersion) ? in.readLong() : 0L;
                if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.ADD_INODE_ID, imgVersion)) {
                    long lastInodeId = in.readLong();
                    this.namesystem.resetLastInodeId(lastInodeId);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("load last allocated InodeId from fsimage:" + lastInodeId));
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Old layout version doesn't have inode id. Will assign new id for each inode.");
                }
                if (supportSnapshot) {
                    this.snapshotMap = this.namesystem.getSnapshotManager().read(in, this);
                }
                FSImageCompression compression = NameNodeLayoutVersion.supports(LayoutVersion.Feature.FSIMAGE_COMPRESSION, imgVersion) ? FSImageCompression.readCompressionHeader(this.conf, in) : FSImageCompression.createNoopCompression();
                in = compression.unwrapInputStream(fin);
                LOG.info((Object)("Loading image file " + curFile + " using " + compression));
                LOG.info((Object)("Number of files = " + numFiles));
                prog.setTotal(Phase.LOADING_FSIMAGE, step, numFiles);
                StartupProgress.Counter counter = prog.getCounter(Phase.LOADING_FSIMAGE, step);
                if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.FSIMAGE_NAME_OPTIMIZATION, imgVersion)) {
                    if (supportSnapshot) {
                        this.loadLocalNameINodesWithSnapshot(numFiles, in, counter);
                    } else {
                        this.loadLocalNameINodes(numFiles, in, counter);
                    }
                } else {
                    this.loadFullNameINodes(numFiles, in, counter);
                }
                this.loadFilesUnderConstruction(in, supportSnapshot, counter);
                prog.endStep(Phase.LOADING_FSIMAGE, step);
                prog.setCount(Phase.LOADING_FSIMAGE, step, numFiles);
                this.loadSecretManagerState(in);
                this.loadCacheManagerState(in);
                boolean bl = eof = in.read() == -1;
                assert (eof) : "Should have reached the end of image file " + curFile;
            }
            finally {
                in.close();
            }
            this.imgDigest = new MD5Hash(digester.digest());
            this.loaded = true;
            LOG.info((Object)("Image file " + curFile + " of size " + curFile.length() + " bytes loaded in " + (Time.now() - startTime) / 1000L + " seconds."));
        }

        private void updateRootAttr(INodeWithAdditionalFields root) {
            Quota.Counts q = root.getQuotaCounts();
            long nsQuota = q.get(Quota.NAMESPACE);
            long dsQuota = q.get(Quota.DISKSPACE);
            FSDirectory fsDir = this.namesystem.dir;
            if (nsQuota != -1L || dsQuota != -1L) {
                fsDir.rootDir.getDirectoryWithQuotaFeature().setQuota(nsQuota, dsQuota);
            }
            fsDir.rootDir.cloneModificationTime(root);
            fsDir.rootDir.clonePermissionStatus(root);
        }

        private void loadLocalNameINodesWithSnapshot(long numFiles, DataInput in, StartupProgress.Counter counter) throws IOException {
            assert (NameNodeLayoutVersion.supports(LayoutVersion.Feature.FSIMAGE_NAME_OPTIMIZATION, this.getLayoutVersion()));
            assert (NameNodeLayoutVersion.supports(LayoutVersion.Feature.SNAPSHOT, this.getLayoutVersion()));
            this.loadRoot(in, counter);
            this.loadDirectoryWithSnapshot(in, counter);
        }

        private void loadLocalNameINodes(long numFiles, DataInput in, StartupProgress.Counter counter) throws IOException {
            assert (NameNodeLayoutVersion.supports(LayoutVersion.Feature.FSIMAGE_NAME_OPTIMIZATION, this.getLayoutVersion()));
            assert (numFiles > 0L);
            this.loadRoot(in, counter);
            --numFiles;
            while (numFiles > 0L) {
                numFiles -= (long)this.loadDirectory(in, counter);
            }
            if (numFiles != 0L) {
                throw new IOException("Read unexpect number of files: " + -numFiles);
            }
        }

        private void loadRoot(DataInput in, StartupProgress.Counter counter) throws IOException {
            if (in.readShort() != 0) {
                throw new IOException("First node is not root");
            }
            INodeDirectory root = this.loadINode(null, false, in, counter).asDirectory();
            this.updateRootAttr(root);
        }

        private int loadChildren(INodeDirectory parent, DataInput in, StartupProgress.Counter counter) throws IOException {
            int numChildren = in.readInt();
            for (int i = 0; i < numChildren; ++i) {
                INode newNode = this.loadINodeWithLocalName(false, in, true, counter);
                this.addToParent(parent, newNode);
            }
            return numChildren;
        }

        private void loadDirectoryWithSnapshot(DataInput in, StartupProgress.Counter counter) throws IOException {
            long inodeId = in.readLong();
            INodeDirectory parent = this.namesystem.dir.getInode(inodeId).asDirectory();
            boolean toLoadSubtree = this.referenceMap.toProcessSubtree(parent.getId());
            if (!toLoadSubtree) {
                return;
            }
            int numSnapshots = in.readInt();
            if (numSnapshots >= 0) {
                INodeDirectorySnapshottable snapshottableParent = INodeDirectorySnapshottable.valueOf((INode)parent, parent.getLocalName());
                SnapshotFSImageFormat.loadSnapshotList(snapshottableParent, numSnapshots, in, this);
                if (snapshottableParent.getSnapshotQuota() > 0) {
                    this.namesystem.getSnapshotManager().addSnapshottable(snapshottableParent);
                }
            }
            this.loadChildren(parent, in, counter);
            SnapshotFSImageFormat.loadDirectoryDiffList(parent, in, this);
            int numSubTree = in.readInt();
            for (int i = 0; i < numSubTree; ++i) {
                this.loadDirectoryWithSnapshot(in, counter);
            }
        }

        private int loadDirectory(DataInput in, StartupProgress.Counter counter) throws IOException {
            String parentPath = FSImageSerialization.readString(in);
            parentPath = FSImageFormat.renameReservedPathsOnUpgrade(parentPath, this.getLayoutVersion());
            INodeDirectory parent = INodeDirectory.valueOf(this.namesystem.dir.rootDir.getNode(parentPath, true), parentPath);
            return this.loadChildren(parent, in, counter);
        }

        private void loadFullNameINodes(long numFiles, DataInput in, StartupProgress.Counter counter) throws IOException {
            Object parentPath = new byte[][]{new byte[0]};
            FSDirectory fsDir = this.namesystem.dir;
            INodeDirectory parentINode = fsDir.rootDir;
            for (long i = 0L; i < numFiles; ++i) {
                byte[][] pathComponents = FSImageSerialization.readPathComponents(in);
                INode newNode = this.loadINode(pathComponents[pathComponents.length - 1], false, in, counter);
                if (this.isRoot(pathComponents)) {
                    this.updateRootAttr(newNode.asDirectory());
                    continue;
                }
                this.namesystem.dir.addToInodeMap(newNode);
                if (!this.isParent(pathComponents, (byte[][])parentPath)) {
                    parentINode = this.getParentINodeDirectory(pathComponents);
                    parentPath = this.getParent(pathComponents);
                }
                this.addToParent(parentINode, newNode);
            }
        }

        private INodeDirectory getParentINodeDirectory(byte[][] pathComponents) throws FileNotFoundException, PathIsNotDirectoryException, UnresolvedLinkException {
            if (pathComponents.length < 2) {
                return null;
            }
            INodesInPath inodes = this.namesystem.dir.getExistingPathINodes(pathComponents);
            return INodeDirectory.valueOf(inodes.getINode(-2), pathComponents);
        }

        private void addToParent(INodeDirectory parent, INode child) {
            FSDirectory fsDir = this.namesystem.dir;
            if (parent == fsDir.rootDir) {
                child.setLocalName(FSImageFormat.renameReservedRootComponentOnUpgrade(child.getLocalNameBytes(), this.getLayoutVersion()));
            }
            if (!parent.addChild(child)) {
                return;
            }
            this.namesystem.dir.cacheName(child);
            if (child.isFile()) {
                this.updateBlocksMap(child.asFile());
            }
        }

        public void updateBlocksMap(INodeFile file) {
            BlockInfo[] blocks = file.getBlocks();
            if (blocks != null) {
                BlockManager bm = this.namesystem.getBlockManager();
                for (int i = 0; i < blocks.length; ++i) {
                    file.setBlock(i, bm.addBlockCollection(blocks[i], file));
                }
            }
        }

        public INode loadINodeWithLocalName(boolean isSnapshotINode, DataInput in, boolean updateINodeMap) throws IOException {
            return this.loadINodeWithLocalName(isSnapshotINode, in, updateINodeMap, null);
        }

        public INode loadINodeWithLocalName(boolean isSnapshotINode, DataInput in, boolean updateINodeMap, StartupProgress.Counter counter) throws IOException {
            byte[] localName = FSImageSerialization.readLocalName(in);
            localName = FSImageFormat.renameReservedComponentOnUpgrade(localName, this.getLayoutVersion());
            INode inode = this.loadINode(localName, isSnapshotINode, in, counter);
            if (updateINodeMap) {
                this.namesystem.dir.addToInodeMap(inode);
            }
            return inode;
        }

        INode loadINode(byte[] localName, boolean isSnapshotINode, DataInput in, StartupProgress.Counter counter) throws IOException {
            int imgVersion = this.getLayoutVersion();
            if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.SNAPSHOT, imgVersion)) {
                this.namesystem.getFSDirectory().verifyINodeName(localName);
            }
            long inodeId = NameNodeLayoutVersion.supports(LayoutVersion.Feature.ADD_INODE_ID, imgVersion) ? in.readLong() : this.namesystem.allocateNewInodeId();
            short replication = this.namesystem.getBlockManager().adjustReplication(in.readShort());
            long modificationTime = in.readLong();
            long atime = 0L;
            if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.FILE_ACCESS_TIME, imgVersion)) {
                atime = in.readLong();
            }
            long blockSize = in.readLong();
            int numBlocks = in.readInt();
            if (numBlocks >= 0) {
                BlockInfo[] blocks = new BlockInfo[numBlocks];
                for (int j = 0; j < numBlocks; ++j) {
                    blocks[j] = new BlockInfo(replication);
                    blocks[j].readFields(in);
                }
                String clientName = "";
                String clientMachine = "";
                boolean underConstruction = false;
                FileDiffList fileDiffs = null;
                if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.SNAPSHOT, imgVersion)) {
                    fileDiffs = SnapshotFSImageFormat.loadFileDiffList(in, this);
                    if (isSnapshotINode && (underConstruction = in.readBoolean())) {
                        clientName = FSImageSerialization.readString(in);
                        clientMachine = FSImageSerialization.readString(in);
                        if (blocks != null && blocks.length > 0) {
                            BlockInfo lastBlk = blocks[blocks.length - 1];
                            blocks[blocks.length - 1] = new BlockInfoUnderConstruction(lastBlk, replication);
                        }
                    }
                }
                PermissionStatus permissions = PermissionStatus.read(in);
                if (counter != null) {
                    counter.increment();
                }
                INodeFile file = new INodeFile(inodeId, localName, permissions, modificationTime, atime, blocks, replication, blockSize);
                if (underConstruction) {
                    file.toUnderConstruction(clientName, clientMachine, null);
                }
                return fileDiffs == null ? file : new INodeFile(file, fileDiffs);
            }
            if (numBlocks == -1) {
                long nsQuota = in.readLong();
                long dsQuota = -1L;
                if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.DISKSPACE_QUOTA, imgVersion)) {
                    dsQuota = in.readLong();
                }
                boolean snapshottable = false;
                boolean withSnapshot = false;
                if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.SNAPSHOT, imgVersion) && !(snapshottable = in.readBoolean())) {
                    withSnapshot = in.readBoolean();
                }
                PermissionStatus permissions = PermissionStatus.read(in);
                if (counter != null) {
                    counter.increment();
                }
                INodeDirectory dir = new INodeDirectory(inodeId, localName, permissions, modificationTime);
                if (nsQuota >= 0L || dsQuota >= 0L) {
                    dir.addDirectoryWithQuotaFeature(nsQuota, dsQuota);
                }
                if (withSnapshot) {
                    dir.addSnapshotFeature(null);
                }
                return snapshottable ? new INodeDirectorySnapshottable(dir) : dir;
            }
            if (numBlocks == -2) {
                if (!FileSystem.areSymlinksEnabled()) {
                    throw new IOException("Symlinks not supported - please remove symlink before upgrading to this version of HDFS");
                }
                String symlink = Text.readString(in);
                PermissionStatus permissions = PermissionStatus.read(in);
                if (counter != null) {
                    counter.increment();
                }
                return new INodeSymlink(inodeId, localName, permissions, modificationTime, atime, symlink);
            }
            if (numBlocks == -3) {
                boolean isWithName = in.readBoolean();
                int snapshotId = in.readInt();
                INodeReference.WithCount withCount = this.referenceMap.loadINodeReferenceWithCount(isSnapshotINode, in, this);
                if (isWithName) {
                    return new INodeReference.WithName(null, withCount, localName, snapshotId);
                }
                INodeReference.DstReference ref = new INodeReference.DstReference(null, withCount, snapshotId);
                return ref;
            }
            throw new IOException("Unknown inode type: numBlocks=" + numBlocks);
        }

        public INodeFileAttributes loadINodeFileAttributes(DataInput in) throws IOException {
            int layoutVersion = this.getLayoutVersion();
            if (!NameNodeLayoutVersion.supports(LayoutVersion.Feature.OPTIMIZE_SNAPSHOT_INODES, layoutVersion)) {
                return this.loadINodeWithLocalName(true, in, false).asFile();
            }
            byte[] name = FSImageSerialization.readLocalName(in);
            PermissionStatus permissions = PermissionStatus.read(in);
            long modificationTime = in.readLong();
            long accessTime = in.readLong();
            short replication = this.namesystem.getBlockManager().adjustReplication(in.readShort());
            long preferredBlockSize = in.readLong();
            return new INodeFileAttributes.SnapshotCopy(name, permissions, null, modificationTime, accessTime, replication, preferredBlockSize);
        }

        public INodeDirectoryAttributes loadINodeDirectoryAttributes(DataInput in) throws IOException {
            int layoutVersion = this.getLayoutVersion();
            if (!NameNodeLayoutVersion.supports(LayoutVersion.Feature.OPTIMIZE_SNAPSHOT_INODES, layoutVersion)) {
                return this.loadINodeWithLocalName(true, in, false).asDirectory();
            }
            byte[] name = FSImageSerialization.readLocalName(in);
            PermissionStatus permissions = PermissionStatus.read(in);
            long modificationTime = in.readLong();
            long nsQuota = in.readLong();
            long dsQuota = in.readLong();
            return nsQuota == -1L && dsQuota == -1L ? new INodeDirectoryAttributes.SnapshotCopy(name, permissions, null, modificationTime) : new INodeDirectoryAttributes.CopyWithQuota(name, permissions, null, modificationTime, nsQuota, dsQuota);
        }

        private void loadFilesUnderConstruction(DataInput in, boolean supportSnapshot, StartupProgress.Counter counter) throws IOException {
            FSDirectory fsDir = this.namesystem.dir;
            int size = in.readInt();
            LOG.info((Object)("Number of files under construction = " + size));
            for (int i = 0; i < size; ++i) {
                INodeFile cons = FSImageSerialization.readINodeUnderConstruction(in, this.namesystem, this.getLayoutVersion());
                counter.increment();
                String path = cons.getLocalName();
                INodeFile oldnode = null;
                boolean inSnapshot = false;
                if (path != null && FSDirectory.isReservedName(path) && NameNodeLayoutVersion.supports(LayoutVersion.Feature.ADD_INODE_ID, this.getLayoutVersion())) {
                    oldnode = this.namesystem.dir.getInode(cons.getId()).asFile();
                    inSnapshot = true;
                } else {
                    INodesInPath iip = fsDir.getLastINodeInPath(path);
                    oldnode = INodeFile.valueOf(iip.getINode(0), path);
                }
                FileUnderConstructionFeature uc = cons.getFileUnderConstructionFeature();
                oldnode.toUnderConstruction(uc.getClientName(), uc.getClientMachine(), uc.getClientNode());
                if (oldnode.numBlocks() > 0) {
                    BlockInfo ucBlock = cons.getLastBlock();
                    BlockInfo info = this.namesystem.getBlockManager().addBlockCollection(ucBlock, oldnode);
                    oldnode.setBlock(oldnode.numBlocks() - 1, info);
                }
                if (inSnapshot) continue;
                this.namesystem.leaseManager.addLease(cons.getFileUnderConstructionFeature().getClientName(), path);
            }
        }

        private void loadSecretManagerState(DataInput in) throws IOException {
            int imgVersion = this.getLayoutVersion();
            if (!NameNodeLayoutVersion.supports(LayoutVersion.Feature.DELEGATION_TOKEN, imgVersion)) {
                return;
            }
            this.namesystem.loadSecretManagerStateCompat(in);
        }

        private void loadCacheManagerState(DataInput in) throws IOException {
            int imgVersion = this.getLayoutVersion();
            if (!NameNodeLayoutVersion.supports(LayoutVersion.Feature.CACHING, imgVersion)) {
                return;
            }
            this.namesystem.getCacheManager().loadStateCompat(in);
        }

        private int getLayoutVersion() {
            return this.namesystem.getFSImage().getStorage().getLayoutVersion();
        }

        private boolean isRoot(byte[][] path) {
            return path.length == 1 && path[0] == null;
        }

        private boolean isParent(byte[][] path, byte[][] parent) {
            if (path == null || parent == null) {
                return false;
            }
            if (parent.length == 0 || path.length != parent.length + 1) {
                return false;
            }
            boolean isParent = true;
            for (int i = 0; i < parent.length; ++i) {
                isParent = isParent && Arrays.equals(path[i], parent[i]);
            }
            return isParent;
        }

        String getParent(String path) {
            return path.substring(0, path.lastIndexOf("/"));
        }

        byte[][] getParent(byte[][] path) {
            byte[][] result = new byte[path.length - 1][];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new byte[path[i].length];
                System.arraycopy(path[i], 0, result[i], 0, path[i].length);
            }
            return result;
        }

        public Snapshot getSnapshot(DataInput in) throws IOException {
            return this.snapshotMap.get(in.readInt());
        }
    }

    static class LoaderDelegator
    implements AbstractLoader {
        private AbstractLoader impl;
        private final Configuration conf;
        private final FSNamesystem fsn;

        LoaderDelegator(Configuration conf, FSNamesystem fsn) {
            this.conf = conf;
            this.fsn = fsn;
        }

        @Override
        public MD5Hash getLoadedImageMd5() {
            return this.impl.getLoadedImageMd5();
        }

        @Override
        public long getLoadedImageTxId() {
            return this.impl.getLoadedImageTxId();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load(File file) throws IOException {
            FileInputStream is;
            block3: {
                Preconditions.checkState(this.impl == null, "Image already loaded!");
                is = null;
                try {
                    is = new FileInputStream(file);
                    byte[] magic = new byte[FSImageUtil.MAGIC_HEADER.length];
                    IOUtils.readFully(is, magic, 0, magic.length);
                    if (Arrays.equals(magic, FSImageUtil.MAGIC_HEADER)) {
                        FSImageFormatProtobuf.Loader loader = new FSImageFormatProtobuf.Loader(this.conf, this.fsn);
                        this.impl = loader;
                        loader.load(file);
                        break block3;
                    }
                    Loader loader = new Loader(this.conf, this.fsn);
                    this.impl = loader;
                    loader.load(file);
                }
                catch (Throwable throwable) {
                    IOUtils.cleanup(LOG, is);
                    throw throwable;
                }
            }
            IOUtils.cleanup(LOG, is);
        }
    }

    static interface AbstractLoader {
        public MD5Hash getLoadedImageMd5();

        public long getLoadedImageTxId();
    }
}

