/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.net.InetAddress;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.registration.RetryingRegistrationConfiguration;
import org.apache.flink.runtime.taskexecutor.QueryableStateConfiguration;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceSpec;
import org.apache.flink.runtime.util.ClusterEntrypointUtils;
import org.apache.flink.runtime.util.ConfigurationParserUtils;
import org.apache.flink.util.Preconditions;

public class TaskManagerServicesConfiguration {
    private final Configuration configuration;
    private final ResourceID resourceID;
    private final InetAddress taskManagerAddress;
    private final boolean localCommunicationOnly;
    private final String[] tmpDirPaths;
    private final String[] localRecoveryStateRootDirectories;
    private final int numberOfSlots;
    @Nullable
    private final QueryableStateConfiguration queryableStateConfig;
    private final int pageSize;
    private final long timerServiceShutdownTimeout;
    private final boolean localRecoveryEnabled;
    private final RetryingRegistrationConfiguration retryingRegistrationConfiguration;
    private Optional<Time> systemResourceMetricsProbingInterval;
    private final TaskExecutorResourceSpec taskExecutorResourceSpec;
    private final int numIoThreads;

    public TaskManagerServicesConfiguration(Configuration configuration, ResourceID resourceID, InetAddress taskManagerAddress, boolean localCommunicationOnly, String[] tmpDirPaths, String[] localRecoveryStateRootDirectories, boolean localRecoveryEnabled, @Nullable QueryableStateConfiguration queryableStateConfig, int numberOfSlots, int pageSize, TaskExecutorResourceSpec taskExecutorResourceSpec, long timerServiceShutdownTimeout, RetryingRegistrationConfiguration retryingRegistrationConfiguration, Optional<Time> systemResourceMetricsProbingInterval, int numIoThreads) {
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
        this.resourceID = (ResourceID)Preconditions.checkNotNull((Object)resourceID);
        this.taskManagerAddress = (InetAddress)Preconditions.checkNotNull((Object)taskManagerAddress);
        this.localCommunicationOnly = localCommunicationOnly;
        this.tmpDirPaths = (String[])Preconditions.checkNotNull((Object)tmpDirPaths);
        this.localRecoveryStateRootDirectories = (String[])Preconditions.checkNotNull((Object)localRecoveryStateRootDirectories);
        this.localRecoveryEnabled = (Boolean)Preconditions.checkNotNull((Object)localRecoveryEnabled);
        this.queryableStateConfig = queryableStateConfig;
        this.numberOfSlots = (Integer)Preconditions.checkNotNull((Object)numberOfSlots);
        this.pageSize = pageSize;
        this.taskExecutorResourceSpec = taskExecutorResourceSpec;
        this.numIoThreads = numIoThreads;
        Preconditions.checkArgument((timerServiceShutdownTimeout >= 0L ? 1 : 0) != 0, (Object)"The timer service shutdown timeout must be greater or equal to 0.");
        this.timerServiceShutdownTimeout = timerServiceShutdownTimeout;
        this.retryingRegistrationConfiguration = (RetryingRegistrationConfiguration)Preconditions.checkNotNull((Object)retryingRegistrationConfiguration);
        this.systemResourceMetricsProbingInterval = (Optional)Preconditions.checkNotNull(systemResourceMetricsProbingInterval);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ResourceID getResourceID() {
        return this.resourceID;
    }

    InetAddress getTaskManagerAddress() {
        return this.taskManagerAddress;
    }

    boolean isLocalCommunicationOnly() {
        return this.localCommunicationOnly;
    }

    public String[] getTmpDirPaths() {
        return this.tmpDirPaths;
    }

    String[] getLocalRecoveryStateRootDirectories() {
        return this.localRecoveryStateRootDirectories;
    }

    boolean isLocalRecoveryEnabled() {
        return this.localRecoveryEnabled;
    }

    @Nullable
    QueryableStateConfiguration getQueryableStateConfig() {
        return this.queryableStateConfig;
    }

    public int getNumberOfSlots() {
        return this.numberOfSlots;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public TaskExecutorResourceSpec getTaskExecutorResourceSpec() {
        return this.taskExecutorResourceSpec;
    }

    public MemorySize getNetworkMemorySize() {
        return this.taskExecutorResourceSpec.getNetworkMemSize();
    }

    public MemorySize getManagedMemorySize() {
        return this.taskExecutorResourceSpec.getManagedMemorySize();
    }

    long getTimerServiceShutdownTimeout() {
        return this.timerServiceShutdownTimeout;
    }

    public Optional<Time> getSystemResourceMetricsProbingInterval() {
        return this.systemResourceMetricsProbingInterval;
    }

    RetryingRegistrationConfiguration getRetryingRegistrationConfiguration() {
        return this.retryingRegistrationConfiguration;
    }

    public int getNumIoThreads() {
        return this.numIoThreads;
    }

    public static TaskManagerServicesConfiguration fromConfiguration(Configuration configuration, ResourceID resourceID, InetAddress remoteAddress, boolean localCommunicationOnly, TaskExecutorResourceSpec taskExecutorResourceSpec) {
        String[] tmpDirs = ConfigurationUtils.parseTempDirectories((Configuration)configuration);
        String[] localStateRootDir = ConfigurationUtils.parseLocalStateDirectories((Configuration)configuration);
        if (localStateRootDir.length == 0) {
            localStateRootDir = tmpDirs;
        }
        boolean localRecoveryMode = configuration.getBoolean(CheckpointingOptions.LOCAL_RECOVERY);
        QueryableStateConfiguration queryableStateConfig = QueryableStateConfiguration.fromConfiguration(configuration);
        long timerServiceShutdownTimeout = AkkaUtils.getTimeout(configuration).toMillis();
        RetryingRegistrationConfiguration retryingRegistrationConfiguration = RetryingRegistrationConfiguration.fromConfiguration(configuration);
        int numIoThreads = ClusterEntrypointUtils.getPoolSize(configuration);
        return new TaskManagerServicesConfiguration(configuration, resourceID, remoteAddress, localCommunicationOnly, tmpDirs, localStateRootDir, localRecoveryMode, queryableStateConfig, ConfigurationParserUtils.getSlot(configuration), ConfigurationParserUtils.getPageSize(configuration), taskExecutorResourceSpec, timerServiceShutdownTimeout, retryingRegistrationConfiguration, ConfigurationUtils.getSystemResourceMetricsProbingInterval((Configuration)configuration), numIoThreads);
    }
}

