/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferCompressor;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferPoolOwner;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.FunctionWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultPartition
implements ResultPartitionWriter,
BufferPoolOwner {
    protected static final Logger LOG = LoggerFactory.getLogger(ResultPartition.class);
    private final String owningTaskName;
    protected final ResultPartitionID partitionId;
    protected final ResultPartitionType partitionType;
    protected final ResultSubpartition[] subpartitions;
    protected final ResultPartitionManager partitionManager;
    public final int numTargetKeyGroups;
    private final AtomicBoolean isReleased = new AtomicBoolean();
    private BufferPool bufferPool;
    private boolean isFinished;
    private volatile Throwable cause;
    private final FunctionWithException<BufferPoolOwner, BufferPool, IOException> bufferPoolFactory;
    @Nullable
    protected final BufferCompressor bufferCompressor;

    public ResultPartition(String owningTaskName, ResultPartitionID partitionId, ResultPartitionType partitionType, ResultSubpartition[] subpartitions, int numTargetKeyGroups, ResultPartitionManager partitionManager, @Nullable BufferCompressor bufferCompressor, FunctionWithException<BufferPoolOwner, BufferPool, IOException> bufferPoolFactory) {
        this.owningTaskName = (String)Preconditions.checkNotNull((Object)owningTaskName);
        this.partitionId = (ResultPartitionID)Preconditions.checkNotNull((Object)partitionId);
        this.partitionType = (ResultPartitionType)((Object)Preconditions.checkNotNull((Object)((Object)partitionType)));
        this.subpartitions = (ResultSubpartition[])Preconditions.checkNotNull((Object)subpartitions);
        this.numTargetKeyGroups = numTargetKeyGroups;
        this.partitionManager = (ResultPartitionManager)Preconditions.checkNotNull((Object)partitionManager);
        this.bufferCompressor = bufferCompressor;
        this.bufferPoolFactory = bufferPoolFactory;
    }

    @Override
    public void setup() throws IOException {
        Preconditions.checkState((this.bufferPool == null ? 1 : 0) != 0, (Object)"Bug in result partition setup logic: Already registered buffer pool.");
        BufferPool bufferPool = (BufferPool)Preconditions.checkNotNull((Object)this.bufferPoolFactory.apply((Object)this));
        Preconditions.checkArgument((bufferPool.getNumberOfRequiredMemorySegments() >= this.getNumberOfSubpartitions() ? 1 : 0) != 0, (Object)"Bug in result partition setup logic: Buffer pool has not enough guaranteed buffers for this result partition.");
        this.bufferPool = bufferPool;
        this.partitionManager.registerResultPartition(this);
    }

    public String getOwningTaskName() {
        return this.owningTaskName;
    }

    @Override
    public ResultPartitionID getPartitionId() {
        return this.partitionId;
    }

    @Override
    public int getNumberOfSubpartitions() {
        return this.subpartitions.length;
    }

    public BufferPool getBufferPool() {
        return this.bufferPool;
    }

    public int getNumberOfQueuedBuffers() {
        int totalBuffers = 0;
        for (ResultSubpartition subpartition : this.subpartitions) {
            totalBuffers += subpartition.unsynchronizedGetNumberOfQueuedBuffers();
        }
        return totalBuffers;
    }

    public ResultPartitionType getPartitionType() {
        return this.partitionType;
    }

    @Override
    public BufferBuilder getBufferBuilder() throws IOException, InterruptedException {
        this.checkInProduceState();
        return this.bufferPool.requestBufferBuilderBlocking();
    }

    @Override
    public boolean addBufferConsumer(BufferConsumer bufferConsumer, int subpartitionIndex) throws IOException {
        ResultSubpartition subpartition;
        Preconditions.checkNotNull((Object)bufferConsumer);
        try {
            this.checkInProduceState();
            subpartition = this.subpartitions[subpartitionIndex];
        }
        catch (Exception ex) {
            bufferConsumer.close();
            throw ex;
        }
        return subpartition.add(bufferConsumer);
    }

    @Override
    public void flushAll() {
        for (ResultSubpartition subpartition : this.subpartitions) {
            subpartition.flush();
        }
    }

    @Override
    public void flush(int subpartitionIndex) {
        this.subpartitions[subpartitionIndex].flush();
    }

    @Override
    public void finish() throws IOException {
        this.checkInProduceState();
        for (ResultSubpartition subpartition : this.subpartitions) {
            subpartition.finish();
        }
        this.isFinished = true;
    }

    public void release() {
        this.release(null);
    }

    public void release(Throwable cause) {
        if (this.isReleased.compareAndSet(false, true)) {
            LOG.debug("{}: Releasing {}.", (Object)this.owningTaskName, (Object)this);
            if (cause != null) {
                this.cause = cause;
            }
            for (ResultSubpartition subpartition : this.subpartitions) {
                try {
                    subpartition.release();
                }
                catch (Throwable t) {
                    LOG.error("Error during release of result subpartition: " + t.getMessage(), t);
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.bufferPool != null) {
            this.bufferPool.lazyDestroy();
        }
    }

    @Override
    public void fail(@Nullable Throwable throwable) {
        this.partitionManager.releasePartition(this.partitionId, throwable);
    }

    public ResultSubpartitionView createSubpartitionView(int index, BufferAvailabilityListener availabilityListener) throws IOException {
        Preconditions.checkElementIndex((int)index, (int)this.subpartitions.length, (String)"Subpartition not found.");
        Preconditions.checkState((!this.isReleased.get() ? 1 : 0) != 0, (Object)"Partition released.");
        ResultSubpartitionView readView = this.subpartitions[index].createReadView(availabilityListener);
        LOG.debug("Created {}", (Object)readView);
        return readView;
    }

    public Throwable getFailureCause() {
        return this.cause;
    }

    @Override
    public int getNumTargetKeyGroups() {
        return this.numTargetKeyGroups;
    }

    @Override
    public void releaseMemory(int toRelease) throws IOException {
        Preconditions.checkArgument((toRelease > 0 ? 1 : 0) != 0);
        for (ResultSubpartition subpartition : this.subpartitions) {
            if ((toRelease -= subpartition.releaseMemory()) <= 0) break;
        }
    }

    public boolean isReleased() {
        return this.isReleased.get();
    }

    @Override
    public CompletableFuture<?> getAvailableFuture() {
        return this.bufferPool.getAvailableFuture();
    }

    public String toString() {
        return "ResultPartition " + this.partitionId.toString() + " [" + (Object)((Object)this.partitionType) + ", " + this.subpartitions.length + " subpartitions]";
    }

    void onConsumedSubpartition(int subpartitionIndex) {
        if (this.isReleased.get()) {
            return;
        }
        LOG.debug("{}: Received release notification for subpartition {}.", (Object)this, (Object)subpartitionIndex);
    }

    public ResultSubpartition[] getAllPartitions() {
        return this.subpartitions;
    }

    private void checkInProduceState() throws IllegalStateException {
        Preconditions.checkState((!this.isFinished ? 1 : 0) != 0, (Object)"Partition already finished.");
    }
}

