/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.execution.librarycache;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.function.Consumer;
import org.apache.flink.util.ChildFirstClassLoader;
import org.apache.flink.util.FlinkUserCodeClassLoader;

public class FlinkUserCodeClassLoaders {
    private FlinkUserCodeClassLoaders() {
    }

    public static URLClassLoader parentFirst(URL[] urls, ClassLoader parent, Consumer<Throwable> classLoadingExceptionHandler) {
        return new ParentFirstClassLoader(urls, parent, classLoadingExceptionHandler);
    }

    public static URLClassLoader childFirst(URL[] urls, ClassLoader parent, String[] alwaysParentFirstPatterns, Consumer<Throwable> classLoadingExceptionHandler) {
        return new ChildFirstClassLoader(urls, parent, alwaysParentFirstPatterns, classLoadingExceptionHandler);
    }

    public static URLClassLoader create(ResolveOrder resolveOrder, URL[] urls, ClassLoader parent, String[] alwaysParentFirstPatterns, Consumer<Throwable> classLoadingExceptionHandler) {
        switch (resolveOrder) {
            case CHILD_FIRST: {
                return FlinkUserCodeClassLoaders.childFirst(urls, parent, alwaysParentFirstPatterns, classLoadingExceptionHandler);
            }
            case PARENT_FIRST: {
                return FlinkUserCodeClassLoaders.parentFirst(urls, parent, classLoadingExceptionHandler);
            }
        }
        throw new IllegalArgumentException("Unknown class resolution order: " + (Object)((Object)resolveOrder));
    }

    static class ParentFirstClassLoader
    extends FlinkUserCodeClassLoader {
        ParentFirstClassLoader(URL[] urls, ClassLoader parent, Consumer<Throwable> classLoadingExceptionHandler) {
            super(urls, parent, classLoadingExceptionHandler);
        }
    }

    public static enum ResolveOrder {
        CHILD_FIRST,
        PARENT_FIRST;


        public static ResolveOrder fromString(String resolveOrder) {
            if (resolveOrder.equalsIgnoreCase("parent-first")) {
                return PARENT_FIRST;
            }
            if (resolveOrder.equalsIgnoreCase("child-first")) {
                return CHILD_FIRST;
            }
            throw new IllegalArgumentException("Unknown resolve order: " + resolveOrder);
        }
    }
}

