/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.akka;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.runtime.rpc.akka.AkkaRpcSystemLoader;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class AkkaRpcSystemLoaderITCase {
    private static final AkkaRpcSystemLoader LOADER = new AkkaRpcSystemLoader();

    AkkaRpcSystemLoaderITCase() {
    }

    @Test
    void testServiceLoadingWithDefaultConfig() {
        Configuration config = new Configuration();
        try (RpcSystem rpcSystem = LOADER.loadRpcSystem(config);){
            Assertions.assertThat((Object)rpcSystem).isNotNull();
        }
    }

    @Test
    void testServiceLoadingWithNonExistingPath(@TempDir Path tempDir) {
        Configuration config = new Configuration();
        config.set(CoreOptions.TMP_DIRS, (Object)tempDir.resolve(Paths.get("some", "directory")).toString());
        try (RpcSystem rpcSystem = LOADER.loadRpcSystem(config);){
            Assertions.assertThat((Object)rpcSystem).isNotNull();
        }
    }
}

