/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.File;
import java.util.Collection;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopUtils.class);
    private static final Text HDFS_DELEGATION_TOKEN_KIND = new Text("HDFS_DELEGATION_TOKEN");

    public static org.apache.hadoop.conf.Configuration getHadoopConfiguration(Configuration flinkConfiguration) {
        HdfsConfiguration result = new HdfsConfiguration();
        boolean foundHadoopConfiguration = false;
        String hdfsDefaultPath = flinkConfiguration.getString("fs.hdfs.hdfsdefault", null);
        if (hdfsDefaultPath != null) {
            result.addResource(new Path(hdfsDefaultPath));
            LOG.debug("Using hdfs-default configuration-file path form Flink config: {}", (Object)hdfsDefaultPath);
            foundHadoopConfiguration = true;
        } else {
            LOG.debug("Cannot find hdfs-default configuration-file path in Flink config.");
        }
        String hdfsSitePath = flinkConfiguration.getString("fs.hdfs.hdfssite", null);
        if (hdfsSitePath != null) {
            result.addResource(new Path(hdfsSitePath));
            LOG.debug("Using hdfs-site configuration-file path form Flink config: {}", (Object)hdfsSitePath);
            foundHadoopConfiguration = true;
        } else {
            LOG.debug("Cannot find hdfs-site configuration-file path in Flink config.");
        }
        String[] possibleHadoopConfPaths = new String[4];
        possibleHadoopConfPaths[0] = flinkConfiguration.getString("fs.hdfs.hadoopconf", null);
        possibleHadoopConfPaths[1] = System.getenv("HADOOP_CONF_DIR");
        String hadoopHome = System.getenv("HADOOP_HOME");
        if (hadoopHome != null) {
            possibleHadoopConfPaths[2] = hadoopHome + "/conf";
            possibleHadoopConfPaths[3] = hadoopHome + "/etc/hadoop";
        }
        for (String possibleHadoopConfPath : possibleHadoopConfPaths) {
            if (possibleHadoopConfPath == null || !new File(possibleHadoopConfPath).exists()) continue;
            if (new File(possibleHadoopConfPath + "/core-site.xml").exists()) {
                result.addResource(new Path(possibleHadoopConfPath + "/core-site.xml"));
                LOG.debug("Adding " + possibleHadoopConfPath + "/core-site.xml to hadoop configuration");
                foundHadoopConfiguration = true;
            }
            if (!new File(possibleHadoopConfPath + "/hdfs-site.xml").exists()) continue;
            result.addResource(new Path(possibleHadoopConfPath + "/hdfs-site.xml"));
            LOG.debug("Adding " + possibleHadoopConfPath + "/hdfs-site.xml to hadoop configuration");
            foundHadoopConfiguration = true;
        }
        if (!foundHadoopConfiguration) {
            LOG.debug("Could not find Hadoop configuration via any of the supported methods (Flink configuration, environment variables).");
        }
        return result;
    }

    public static boolean hasHDFSDelegationToken() throws Exception {
        UserGroupInformation loginUser = UserGroupInformation.getCurrentUser();
        Collection usrTok = loginUser.getTokens();
        for (Token token : usrTok) {
            if (!token.getKind().equals((Object)HDFS_DELEGATION_TOKEN_KIND)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMinHadoopVersion(int major, int minor) throws FlinkRuntimeException {
        String versionString = VersionInfo.getVersion();
        String[] versionParts = versionString.split("\\.");
        if (versionParts.length < 2) {
            throw new FlinkRuntimeException("Cannot determine version of Hadoop, unexpected version string: " + versionString);
        }
        int maj = Integer.parseInt(versionParts[0]);
        int min = Integer.parseInt(versionParts[1]);
        return maj > major || maj == major && min >= minor;
    }
}

