/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.testframe.external.source;

import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.util.Preconditions;

public class TestingSourceSettings {
    private final Boundedness boundedness;
    private final CheckpointingMode checkpointingMode;

    public static Builder builder() {
        return new Builder();
    }

    public Boundedness getBoundedness() {
        return this.boundedness;
    }

    public CheckpointingMode getCheckpointingMode() {
        return this.checkpointingMode;
    }

    private TestingSourceSettings(Boundedness boundedness, CheckpointingMode checkpointingMode) {
        this.boundedness = boundedness;
        this.checkpointingMode = checkpointingMode;
    }

    public static class Builder {
        private Boundedness boundedness;
        private CheckpointingMode checkpointingMode = CheckpointingMode.EXACTLY_ONCE;

        public Builder setBoundedness(Boundedness boundedness) {
            this.boundedness = boundedness;
            return this;
        }

        public Builder setCheckpointingMode(CheckpointingMode checkpointingMode) {
            this.checkpointingMode = checkpointingMode;
            return this;
        }

        public TestingSourceSettings build() {
            this.sanityCheck();
            return new TestingSourceSettings(this.boundedness, this.checkpointingMode);
        }

        private void sanityCheck() {
            Preconditions.checkNotNull((Object)this.boundedness, (String)"Boundedness is not specified");
            Preconditions.checkNotNull((Object)this.checkpointingMode, (String)"Checkpointing mode is not specified");
        }
    }
}

