/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.testframe.external;

import org.apache.flink.annotation.Experimental;
import org.apache.flink.connector.testframe.TestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.lifecycle.Startable;

@Experimental
public class DefaultContainerizedExternalSystem<C extends GenericContainer<C>>
implements TestResource {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultContainerizedExternalSystem.class);
    private final C container;

    public static <C extends GenericContainer<C>> Builder<C> builder() {
        return new Builder();
    }

    private DefaultContainerizedExternalSystem(C container) {
        this.container = container;
    }

    @Override
    public void startUp() throws Exception {
        if (this.container.isRunning()) {
            return;
        }
        this.container.start();
    }

    @Override
    public void tearDown() throws Exception {
        if (!this.container.isRunning()) {
            return;
        }
        this.container.stop();
    }

    public C getContainer() {
        return this.container;
    }

    /* synthetic */ DefaultContainerizedExternalSystem(GenericContainer x0, 1 x1) {
        this(x0);
    }

    public static class Builder<C extends GenericContainer<C>> {
        private C container;
        private GenericContainer<?> flinkContainer;

        public <T extends GenericContainer<T>> Builder<T> fromContainer(T container) {
            Builder self = this;
            self.container = container;
            return self;
        }

        public Builder<C> bindWithFlinkContainer(GenericContainer<?> flinkContainer) {
            this.flinkContainer = flinkContainer;
            this.container.dependsOn(new Startable[]{flinkContainer}).withNetwork(flinkContainer.getNetwork());
            return this;
        }

        public DefaultContainerizedExternalSystem<C> build() {
            if (this.flinkContainer == null) {
                LOG.warn("External system container is not bound with Flink container. This might lead to network isolation between external system and Flink");
            }
            return new DefaultContainerizedExternalSystem((GenericContainer)this.container, null);
        }
    }
}

