/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.xa;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.transaction.xa.Xid;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@Internal
final class XidImpl
implements Xid,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int formatId;
    @Nonnull
    private final byte[] globalTransactionId;
    @Nonnull
    private final byte[] branchQualifier;

    XidImpl(int formatId, byte[] globalTransactionId, byte[] branchQualifier) {
        Preconditions.checkArgument((globalTransactionId.length <= 64 ? 1 : 0) != 0);
        Preconditions.checkArgument((branchQualifier.length <= 64 ? 1 : 0) != 0);
        this.formatId = formatId;
        this.globalTransactionId = Arrays.copyOf(globalTransactionId, globalTransactionId.length);
        this.branchQualifier = Arrays.copyOf(branchQualifier, branchQualifier.length);
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XidImpl)) {
            return false;
        }
        XidImpl xid = (XidImpl)o;
        return this.formatId == xid.formatId && Arrays.equals(this.globalTransactionId, xid.globalTransactionId) && Arrays.equals(this.branchQualifier, xid.branchQualifier);
    }

    public int hashCode() {
        int result = Objects.hash(this.formatId);
        result = 31 * result + Arrays.hashCode(this.globalTransactionId);
        result = 31 * result + Arrays.hashCode(this.branchQualifier);
        return result;
    }

    public String toString() {
        return this.formatId + ":" + StringUtils.byteToHexString((byte[])this.globalTransactionId) + ":" + StringUtils.byteToHexString((byte[])this.branchQualifier);
    }
}

