/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.catalog;

import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.jdbc.catalog.AbstractJdbcCatalog;
import org.apache.flink.connector.jdbc.catalog.JdbcCatalogUtils;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class JdbcCatalog
extends AbstractJdbcCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcCatalog.class);
    private final AbstractJdbcCatalog internal;

    public JdbcCatalog(String catalogName, String defaultDatabase, String username, String pwd, String baseUrl) {
        super(catalogName, defaultDatabase, username, pwd, baseUrl);
        this.internal = JdbcCatalogUtils.createCatalog(catalogName, defaultDatabase, username, pwd, baseUrl);
    }

    public List<String> listDatabases() throws CatalogException {
        return this.internal.listDatabases();
    }

    @Override
    public CatalogDatabase getDatabase(String databaseName) throws DatabaseNotExistException, CatalogException {
        return this.internal.getDatabase(databaseName);
    }

    public List<String> listTables(String databaseName) throws DatabaseNotExistException, CatalogException {
        return this.internal.listTables(databaseName);
    }

    @Override
    public CatalogBaseTable getTable(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        return this.internal.getTable(tablePath);
    }

    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        try {
            return this.databaseExists(tablePath.getDatabaseName()) && this.listTables(tablePath.getDatabaseName()).contains(tablePath.getObjectName());
        }
        catch (DatabaseNotExistException e) {
            return false;
        }
    }

    @VisibleForTesting
    public AbstractJdbcCatalog getInternal() {
        return this.internal;
    }
}

