/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.flink.client.cli.CliArgsException;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.client.cli.CommandLineOptions;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;

public class ProgramOptions
extends CommandLineOptions {
    private final String jarFilePath;
    private final String entryPointClass;
    private final List<URL> classpaths;
    private final String[] programArgs;
    private final int parallelism;
    private final boolean detachedMode;
    private final boolean shutdownOnAttachedExit;
    private final SavepointRestoreSettings savepointSettings;
    private final boolean isPython;

    public ProgramOptions(CommandLine line) throws CliArgsException {
        block14: {
            super(line);
            String[] args = line.hasOption(CliFrontendParser.ARGS_OPTION.getOpt()) ? line.getOptionValues(CliFrontendParser.ARGS_OPTION.getOpt()) : line.getArgs();
            this.entryPointClass = line.hasOption(CliFrontendParser.CLASS_OPTION.getOpt()) ? line.getOptionValue(CliFrontendParser.CLASS_OPTION.getOpt()) : null;
            this.isPython = line.hasOption(CliFrontendParser.PY_OPTION.getOpt()) | line.hasOption(CliFrontendParser.PYMODULE_OPTION.getOpt()) | "org.apache.flink.client.python.PythonGatewayServer".equals(this.entryPointClass);
            if (this.isPython) {
                ArrayList<String> pyArgList = new ArrayList<String>();
                String[] pyOptions = new HashSet();
                pyOptions.add(CliFrontendParser.PY_OPTION);
                pyOptions.add(CliFrontendParser.PYMODULE_OPTION);
                pyOptions.add(CliFrontendParser.PYFILES_OPTION);
                pyOptions.add(CliFrontendParser.PYREQUIREMENTS_OPTION);
                pyOptions.add(CliFrontendParser.PYARCHIVE_OPTION);
                pyOptions.add(CliFrontendParser.PYEXEC_OPTION);
                Option[] optionArray = line.getOptions();
                int n = optionArray.length;
                for (int i = 0; i < n; ++i) {
                    Option option = optionArray[i];
                    if (!pyOptions.contains(option)) continue;
                    pyArgList.add("--" + option.getLongOpt());
                    pyArgList.add(option.getValue());
                }
                String[] newArgs = pyArgList.toArray(new String[args.length + pyArgList.size()]);
                System.arraycopy(args, 0, newArgs, pyArgList.size(), args.length);
                args = newArgs;
            }
            if (line.hasOption(CliFrontendParser.JAR_OPTION.getOpt())) {
                this.jarFilePath = line.getOptionValue(CliFrontendParser.JAR_OPTION.getOpt());
            } else if (!this.isPython && args.length > 0) {
                this.jarFilePath = args[0];
                args = Arrays.copyOfRange(args, 1, args.length);
            } else {
                this.jarFilePath = null;
            }
            this.programArgs = args;
            ArrayList<URL> classpaths = new ArrayList<URL>();
            if (line.hasOption(CliFrontendParser.CLASSPATH_OPTION.getOpt())) {
                for (String path : line.getOptionValues(CliFrontendParser.CLASSPATH_OPTION.getOpt())) {
                    try {
                        classpaths.add(new URL(path));
                    }
                    catch (MalformedURLException e) {
                        throw new CliArgsException("Bad syntax for classpath: " + path);
                    }
                }
            }
            this.classpaths = classpaths;
            if (line.hasOption(CliFrontendParser.PARALLELISM_OPTION.getOpt())) {
                String parString = line.getOptionValue(CliFrontendParser.PARALLELISM_OPTION.getOpt());
                try {
                    this.parallelism = Integer.parseInt(parString);
                    if (this.parallelism <= 0) {
                        throw new NumberFormatException();
                    }
                    break block14;
                }
                catch (NumberFormatException e) {
                    throw new CliArgsException("The parallelism must be a positive number: " + parString);
                }
            }
            this.parallelism = -1;
        }
        this.detachedMode = line.hasOption(CliFrontendParser.DETACHED_OPTION.getOpt()) || line.hasOption(CliFrontendParser.YARN_DETACHED_OPTION.getOpt());
        this.shutdownOnAttachedExit = line.hasOption(CliFrontendParser.SHUTDOWN_IF_ATTACHED_OPTION.getOpt());
        this.savepointSettings = CliFrontendParser.createSavepointRestoreSettings(line);
    }

    public String getJarFilePath() {
        return this.jarFilePath;
    }

    public String getEntryPointClassName() {
        return this.entryPointClass;
    }

    public List<URL> getClasspaths() {
        return this.classpaths;
    }

    public String[] getProgramArgs() {
        return this.programArgs;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public boolean getDetachedMode() {
        return this.detachedMode;
    }

    public boolean isShutdownOnAttachedExit() {
        return this.shutdownOnAttachedExit;
    }

    public SavepointRestoreSettings getSavepointRestoreSettings() {
        return this.savepointSettings;
    }

    public boolean isPython() {
        return this.isPython;
    }
}

