/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.extension;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.apache.dubbo.common.Extension;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.beans.support.InstantiationStrategy;
import org.apache.dubbo.common.compiler.Compiler;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.context.Lifecycle;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.extension.Adaptive;
import org.apache.dubbo.common.extension.AdaptiveClassCodeGenerator;
import org.apache.dubbo.common.extension.DisableInject;
import org.apache.dubbo.common.extension.ExtensionAccessorAware;
import org.apache.dubbo.common.extension.ExtensionDirector;
import org.apache.dubbo.common.extension.ExtensionFactory;
import org.apache.dubbo.common.extension.ExtensionInjector;
import org.apache.dubbo.common.extension.ExtensionPostProcessor;
import org.apache.dubbo.common.extension.LoadingStrategy;
import org.apache.dubbo.common.extension.SPI;
import org.apache.dubbo.common.extension.Wrapper;
import org.apache.dubbo.common.extension.support.ActivateComparator;
import org.apache.dubbo.common.extension.support.WrapperComparator;
import org.apache.dubbo.common.lang.Prioritized;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.resource.Disposable;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.ClassLoaderResourceLoader;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.Holder;
import org.apache.dubbo.common.utils.NativeUtils;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelAccessor;
import org.apache.dubbo.rpc.model.ScopeModelAware;

public class ExtensionLoader<T> {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ExtensionLoader.class);
    private static final Pattern NAME_SEPARATOR = Pattern.compile("\\s*[,]+\\s*");
    private static final String SPECIAL_SPI_PROPERTIES = "special_spi.properties";
    private final ConcurrentMap<Class<?>, Object> extensionInstances = new ConcurrentHashMap(64);
    private final Class<?> type;
    private final ExtensionInjector injector;
    private final ConcurrentMap<Class<?>, String> cachedNames = new ConcurrentHashMap();
    private final Holder<Map<String, Class<?>>> cachedClasses = new Holder();
    private final Map<String, Object> cachedActivates = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<String, Set<String>> cachedActivateGroups = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<String, String[][]> cachedActivateValues = Collections.synchronizedMap(new LinkedHashMap());
    private final ConcurrentMap<String, Holder<Object>> cachedInstances = new ConcurrentHashMap<String, Holder<Object>>();
    private final Holder<Object> cachedAdaptiveInstance = new Holder();
    private volatile Class<?> cachedAdaptiveClass = null;
    private String cachedDefaultName;
    private volatile Throwable createAdaptiveInstanceError;
    private Set<Class<?>> cachedWrapperClasses;
    private Map<String, IllegalStateException> exceptions = new ConcurrentHashMap<String, IllegalStateException>();
    private static volatile LoadingStrategy[] strategies = ExtensionLoader.loadLoadingStrategies();
    private static Map<String, String> specialSPILoadingStrategyMap = ExtensionLoader.getSpecialSPILoadingStrategyMap();
    private static SoftReference<Map<java.net.URL, List<String>>> urlListMapCache = new SoftReference(new ConcurrentHashMap());
    private static List<String> ignoredInjectMethodsDesc = ExtensionLoader.getIgnoredInjectMethodsDesc();
    private Set<String> unacceptableExceptions = new ConcurrentHashSet<String>();
    private ExtensionDirector extensionDirector;
    private List<ExtensionPostProcessor> extensionPostProcessors;
    private InstantiationStrategy instantiationStrategy;
    private ActivateComparator activateComparator;
    private ScopeModel scopeModel;
    private AtomicBoolean destroyed = new AtomicBoolean();

    public static void setLoadingStrategies(LoadingStrategy ... strategies) {
        if (ArrayUtils.isNotEmpty(strategies)) {
            ExtensionLoader.strategies = strategies;
        }
    }

    private static LoadingStrategy[] loadLoadingStrategies() {
        return (LoadingStrategy[])StreamSupport.stream(ServiceLoader.load(LoadingStrategy.class).spliterator(), false).sorted().toArray(LoadingStrategy[]::new);
    }

    private static Map<String, String> getSpecialSPILoadingStrategyMap() {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        Properties properties = ExtensionLoader.loadProperties(ExtensionLoader.class.getClassLoader(), SPECIAL_SPI_PROPERTIES);
        map.putAll(properties);
        return map;
    }

    public static List<LoadingStrategy> getLoadingStrategies() {
        return Arrays.asList(strategies);
    }

    private static List<String> getIgnoredInjectMethodsDesc() {
        ArrayList<String> ignoreInjectMethodsDesc = new ArrayList<String>();
        Arrays.stream(ScopeModelAware.class.getMethods()).map(ReflectUtils::getDesc).forEach(ignoreInjectMethodsDesc::add);
        Arrays.stream(ExtensionAccessorAware.class.getMethods()).map(ReflectUtils::getDesc).forEach(ignoreInjectMethodsDesc::add);
        return ignoreInjectMethodsDesc;
    }

    ExtensionLoader(Class<?> type, ExtensionDirector extensionDirector, ScopeModel scopeModel) {
        this.type = type;
        this.extensionDirector = extensionDirector;
        this.extensionPostProcessors = extensionDirector.getExtensionPostProcessors();
        this.initInstantiationStrategy();
        this.injector = type == ExtensionInjector.class ? null : extensionDirector.getExtensionLoader(ExtensionInjector.class).getAdaptiveExtension();
        this.activateComparator = new ActivateComparator(extensionDirector);
        this.scopeModel = scopeModel;
    }

    private void initInstantiationStrategy() {
        this.instantiationStrategy = this.extensionPostProcessors.stream().filter(extensionPostProcessor -> extensionPostProcessor instanceof ScopeModelAccessor).map(extensionPostProcessor -> new InstantiationStrategy((ScopeModelAccessor)((Object)extensionPostProcessor))).findFirst().orElse(new InstantiationStrategy());
    }

    @Deprecated
    public static <T> ExtensionLoader<T> getExtensionLoader(Class<T> type) {
        return ApplicationModel.defaultModel().getDefaultModule().getExtensionLoader(type);
    }

    @Deprecated
    public static void resetExtensionLoader(Class type) {
    }

    public void destroy() {
        if (!this.destroyed.compareAndSet(false, true)) {
            return;
        }
        this.extensionInstances.forEach((type, instance) -> {
            if (instance instanceof Disposable) {
                Disposable disposable = (Disposable)instance;
                try {
                    disposable.destroy();
                }
                catch (Exception e) {
                    logger.error("0-15", "", "", "Error destroying extension " + disposable, e);
                }
            }
        });
        this.extensionInstances.clear();
        for (Holder holder : this.cachedInstances.values()) {
            Object wrappedInstance = holder.get();
            if (!(wrappedInstance instanceof Disposable)) continue;
            Disposable disposable = (Disposable)wrappedInstance;
            try {
                disposable.destroy();
            }
            catch (Exception e) {
                logger.error("0-15", "", "", "Error destroying extension " + disposable, e);
            }
        }
        this.cachedInstances.clear();
    }

    private void checkDestroyed() {
        if (this.destroyed.get()) {
            throw new IllegalStateException("ExtensionLoader is destroyed: " + this.type);
        }
    }

    public String getExtensionName(T extensionInstance) {
        return this.getExtensionName(extensionInstance.getClass());
    }

    public String getExtensionName(Class<?> extensionClass) {
        this.getExtensionClasses();
        return (String)this.cachedNames.get(extensionClass);
    }

    public List<T> getActivateExtension(URL url, String key) {
        return this.getActivateExtension(url, key, null);
    }

    public List<T> getActivateExtension(URL url, String[] values) {
        return this.getActivateExtension(url, values, null);
    }

    public List<T> getActivateExtension(URL url, String key, String group) {
        String value = url.getParameter(key);
        return this.getActivateExtension(url, StringUtils.isEmpty(value) ? null : CommonConstants.COMMA_SPLIT_PATTERN.split(value), group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getActivateExtension(URL url, String[] values, String group) {
        this.checkDestroyed();
        TreeMap activateExtensionsMap = new TreeMap(this.activateComparator);
        List<Object> names = values == null ? new ArrayList(0) : Arrays.asList(values);
        HashSet namesSet = new HashSet(names);
        if (!namesSet.contains("-default")) {
            if (this.cachedActivateGroups.size() == 0) {
                Map<String, Set<String>> map = this.cachedActivateGroups;
                synchronized (map) {
                    if (this.cachedActivateGroups.size() == 0) {
                        this.getExtensionClasses();
                        for (Map.Entry<String, Object> entry : this.cachedActivates.entrySet()) {
                            String[] activateGroup2;
                            String[] activateValue;
                            String name2 = entry.getKey();
                            Object activate = entry.getValue();
                            if (activate instanceof Activate) {
                                String[] activateGroup22 = ((Activate)activate).group();
                                activateValue = ((Activate)activate).value();
                            } else {
                                if (!(activate instanceof com.alibaba.dubbo.common.extension.Activate)) continue;
                                activateGroup2 = ((com.alibaba.dubbo.common.extension.Activate)activate).group();
                                activateValue = ((com.alibaba.dubbo.common.extension.Activate)activate).value();
                            }
                            this.cachedActivateGroups.put(name2, new HashSet<String>(Arrays.asList(activateGroup2)));
                            String[][] keyPairs = new String[activateValue.length][];
                            for (int i = 0; i < activateValue.length; ++i) {
                                if (activateValue[i].contains(":")) {
                                    keyPairs[i] = new String[2];
                                    String[] arr = activateValue[i].split(":");
                                    keyPairs[i][0] = arr[0];
                                    keyPairs[i][1] = arr[1];
                                    continue;
                                }
                                keyPairs[i] = new String[1];
                                keyPairs[i][0] = activateValue[i];
                            }
                            this.cachedActivateValues.put(name2, keyPairs);
                        }
                    }
                }
            }
            this.cachedActivateGroups.forEach((name, activateGroup) -> {
                if (this.isMatchGroup(group, (Set<String>)activateGroup) && !namesSet.contains(name) && !namesSet.contains("-" + name) && this.isActive(this.cachedActivateValues.get(name), url)) {
                    activateExtensionsMap.put(this.getExtensionClass((String)name), this.getExtension((String)name));
                }
            });
        }
        if (namesSet.contains("default")) {
            ArrayList<Object> extensionsResult = new ArrayList<Object>(activateExtensionsMap.size() + names.size());
            for (String string : names) {
                if (string.startsWith("-") || namesSet.contains("-" + string)) continue;
                if ("default".equals(string)) {
                    extensionsResult.addAll(activateExtensionsMap.values());
                    continue;
                }
                if (!this.containsExtension(string)) continue;
                extensionsResult.add(this.getExtension(string));
            }
            return extensionsResult;
        }
        for (String string : names) {
            if (string.startsWith("-") || namesSet.contains("-" + string) || "default".equals(string) || !this.containsExtension(string)) continue;
            activateExtensionsMap.put(this.getExtensionClass(string), this.getExtension(string));
        }
        return new ArrayList(activateExtensionsMap.values());
    }

    public List<T> getActivateExtensions() {
        this.checkDestroyed();
        ArrayList activateExtensions = new ArrayList();
        TreeMap activateExtensionsMap = new TreeMap(this.activateComparator);
        this.getExtensionClasses();
        for (Map.Entry<String, Object> entry : this.cachedActivates.entrySet()) {
            String name = entry.getKey();
            Object activate = entry.getValue();
            if (!(activate instanceof Activate)) continue;
            activateExtensionsMap.put(this.getExtensionClass(name), this.getExtension(name));
        }
        if (!activateExtensionsMap.isEmpty()) {
            activateExtensions.addAll(activateExtensionsMap.values());
        }
        return activateExtensions;
    }

    private boolean isMatchGroup(String group, Set<String> groups) {
        if (StringUtils.isEmpty(group)) {
            return true;
        }
        if (CollectionUtils.isNotEmpty(groups)) {
            return groups.contains(group);
        }
        return false;
    }

    private boolean isActive(String[][] keyPairs, URL url) {
        if (keyPairs.length == 0) {
            return true;
        }
        for (String[] keyPair : keyPairs) {
            String key;
            String keyValue = null;
            if (keyPair.length > 1) {
                key = keyPair[0];
                keyValue = keyPair[1];
            } else {
                key = keyPair[0];
            }
            String realValue = url.getParameter(key);
            if (StringUtils.isEmpty(realValue)) {
                realValue = url.getAnyMethodParameter(key);
            }
            if ((keyValue == null || !keyValue.equals(realValue)) && (keyValue != null || !ConfigUtils.isNotEmpty(realValue))) continue;
            return true;
        }
        return false;
    }

    public T getLoadedExtension(String name) {
        this.checkDestroyed();
        if (StringUtils.isEmpty(name)) {
            throw new IllegalArgumentException("Extension name == null");
        }
        Holder<Object> holder = this.getOrCreateHolder(name);
        return (T)holder.get();
    }

    private Holder<Object> getOrCreateHolder(String name) {
        Holder holder = (Holder)this.cachedInstances.get(name);
        if (holder == null) {
            this.cachedInstances.putIfAbsent(name, new Holder());
            holder = (Holder)this.cachedInstances.get(name);
        }
        return holder;
    }

    public Set<String> getLoadedExtensions() {
        return Collections.unmodifiableSet(new TreeSet(this.cachedInstances.keySet()));
    }

    public List<T> getLoadedExtensionInstances() {
        this.checkDestroyed();
        ArrayList instances = new ArrayList();
        this.cachedInstances.values().forEach(holder -> instances.add(holder.get()));
        return instances;
    }

    public T getExtension(String name) {
        T extension = this.getExtension(name, true);
        if (extension == null) {
            throw new IllegalArgumentException("Not find extension: " + name);
        }
        return extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getExtension(String name, boolean wrap) {
        Holder<Object> holder;
        Object instance;
        this.checkDestroyed();
        if (StringUtils.isEmpty(name)) {
            throw new IllegalArgumentException("Extension name == null");
        }
        if ("true".equals(name)) {
            return this.getDefaultExtension();
        }
        String cacheKey = name;
        if (!wrap) {
            cacheKey = cacheKey + "_origin";
        }
        if ((instance = (holder = this.getOrCreateHolder(cacheKey)).get()) == null) {
            Holder<Object> holder2 = holder;
            synchronized (holder2) {
                instance = holder.get();
                if (instance == null) {
                    instance = this.createExtension(name, wrap);
                    holder.set(instance);
                }
            }
        }
        return (T)instance;
    }

    public T getOrDefaultExtension(String name) {
        return this.containsExtension(name) ? this.getExtension(name) : this.getDefaultExtension();
    }

    public T getDefaultExtension() {
        this.getExtensionClasses();
        if (StringUtils.isBlank(this.cachedDefaultName) || "true".equals(this.cachedDefaultName)) {
            return null;
        }
        return this.getExtension(this.cachedDefaultName);
    }

    public boolean hasExtension(String name) {
        this.checkDestroyed();
        if (StringUtils.isEmpty(name)) {
            throw new IllegalArgumentException("Extension name == null");
        }
        Class<?> c = this.getExtensionClass(name);
        return c != null;
    }

    public Set<String> getSupportedExtensions() {
        this.checkDestroyed();
        Map<String, Class<?>> classes = this.getExtensionClasses();
        return Collections.unmodifiableSet(new TreeSet<String>(classes.keySet()));
    }

    public Set<T> getSupportedExtensionInstances() {
        this.checkDestroyed();
        LinkedList<Object> instances = new LinkedList<Object>();
        Set<String> supportedExtensions = this.getSupportedExtensions();
        if (CollectionUtils.isNotEmpty(supportedExtensions)) {
            for (String name : supportedExtensions) {
                instances.add(this.getExtension(name));
            }
        }
        instances.sort(Prioritized.COMPARATOR);
        return new LinkedHashSet(instances);
    }

    public String getDefaultExtensionName() {
        this.getExtensionClasses();
        return this.cachedDefaultName;
    }

    public void addExtension(String name, Class<?> clazz) {
        this.checkDestroyed();
        this.getExtensionClasses();
        if (!this.type.isAssignableFrom(clazz)) {
            throw new IllegalStateException("Input type " + clazz + " doesn't implement the Extension " + this.type);
        }
        if (clazz.isInterface()) {
            throw new IllegalStateException("Input type " + clazz + " can't be interface!");
        }
        if (!clazz.isAnnotationPresent(Adaptive.class)) {
            if (StringUtils.isBlank(name)) {
                throw new IllegalStateException("Extension name is blank (Extension " + this.type + ")!");
            }
            if (this.cachedClasses.get().containsKey(name)) {
                throw new IllegalStateException("Extension name " + name + " already exists (Extension " + this.type + ")!");
            }
            this.cachedNames.put(clazz, name);
            this.cachedClasses.get().put(name, clazz);
        } else {
            if (this.cachedAdaptiveClass != null) {
                throw new IllegalStateException("Adaptive Extension already exists (Extension " + this.type + ")!");
            }
            this.cachedAdaptiveClass = clazz;
        }
    }

    @Deprecated
    public void replaceExtension(String name, Class<?> clazz) {
        this.checkDestroyed();
        this.getExtensionClasses();
        if (!this.type.isAssignableFrom(clazz)) {
            throw new IllegalStateException("Input type " + clazz + " doesn't implement Extension " + this.type);
        }
        if (clazz.isInterface()) {
            throw new IllegalStateException("Input type " + clazz + " can't be interface!");
        }
        if (!clazz.isAnnotationPresent(Adaptive.class)) {
            if (StringUtils.isBlank(name)) {
                throw new IllegalStateException("Extension name is blank (Extension " + this.type + ")!");
            }
            if (!this.cachedClasses.get().containsKey(name)) {
                throw new IllegalStateException("Extension name " + name + " doesn't exist (Extension " + this.type + ")!");
            }
            this.cachedNames.put(clazz, name);
            this.cachedClasses.get().put(name, clazz);
            this.cachedInstances.remove(name);
        } else {
            if (this.cachedAdaptiveClass == null) {
                throw new IllegalStateException("Adaptive Extension doesn't exist (Extension " + this.type + ")!");
            }
            this.cachedAdaptiveClass = clazz;
            this.cachedAdaptiveInstance.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getAdaptiveExtension() {
        this.checkDestroyed();
        Object instance = this.cachedAdaptiveInstance.get();
        if (instance == null) {
            if (this.createAdaptiveInstanceError != null) {
                throw new IllegalStateException("Failed to create adaptive instance: " + this.createAdaptiveInstanceError.toString(), this.createAdaptiveInstanceError);
            }
            Holder<Object> holder = this.cachedAdaptiveInstance;
            synchronized (holder) {
                instance = this.cachedAdaptiveInstance.get();
                if (instance == null) {
                    try {
                        instance = this.createAdaptiveExtension();
                        this.cachedAdaptiveInstance.set(instance);
                    }
                    catch (Throwable t) {
                        this.createAdaptiveInstanceError = t;
                        throw new IllegalStateException("Failed to create adaptive instance: " + t.toString(), t);
                    }
                }
            }
        }
        return (T)instance;
    }

    private IllegalStateException findException(String name) {
        StringBuilder buf = new StringBuilder("No such extension " + this.type.getName() + " by name " + name);
        int i = 1;
        for (Map.Entry<String, IllegalStateException> entry : this.exceptions.entrySet()) {
            if (!entry.getKey().toLowerCase().startsWith(name.toLowerCase())) continue;
            if (i == 1) {
                buf.append(", possible causes: ");
            }
            buf.append("\r\n(");
            buf.append(i++);
            buf.append(") ");
            buf.append(entry.getKey());
            buf.append(":\r\n");
            buf.append(StringUtils.toString(entry.getValue()));
        }
        if (i == 1) {
            buf.append(", no related exception was found, please check whether related SPI module is missing.");
        }
        return new IllegalStateException(buf.toString());
    }

    private T createExtension(String name, boolean wrap) {
        Class<?> clazz = this.getExtensionClasses().get(name);
        if (clazz == null || this.unacceptableExceptions.contains(name)) {
            throw this.findException(name);
        }
        try {
            Object instance = this.extensionInstances.get(clazz);
            if (instance == null) {
                this.extensionInstances.putIfAbsent(clazz, this.createExtensionInstance(clazz));
                instance = this.extensionInstances.get(clazz);
                instance = this.postProcessBeforeInitialization(instance, name);
                this.injectExtension(instance);
                instance = this.postProcessAfterInitialization(instance, name);
            }
            if (wrap) {
                ArrayList<Object> wrapperClassesList = new ArrayList<Object>();
                if (this.cachedWrapperClasses != null) {
                    wrapperClassesList.addAll(this.cachedWrapperClasses);
                    wrapperClassesList.sort(WrapperComparator.COMPARATOR);
                    Collections.reverse(wrapperClassesList);
                }
                if (CollectionUtils.isNotEmpty(wrapperClassesList)) {
                    for (Class clazz2 : wrapperClassesList) {
                        Wrapper wrapper = clazz2.getAnnotation(Wrapper.class);
                        boolean match = wrapper == null || (ArrayUtils.isEmpty(wrapper.matches()) || ArrayUtils.contains(wrapper.matches(), name)) && !ArrayUtils.contains(wrapper.mismatches(), name);
                        if (!match) continue;
                        instance = this.injectExtension(clazz2.getConstructor(this.type).newInstance(instance));
                        instance = this.postProcessAfterInitialization(instance, name);
                    }
                }
            }
            this.initExtension(instance);
            return (T)instance;
        }
        catch (Throwable t) {
            throw new IllegalStateException("Extension instance (name: " + name + ", class: " + this.type + ") couldn't be instantiated: " + t.getMessage(), t);
        }
    }

    private Object createExtensionInstance(Class<?> type) throws ReflectiveOperationException {
        return this.instantiationStrategy.instantiate(type);
    }

    private T postProcessBeforeInitialization(T instance, String name) throws Exception {
        if (this.extensionPostProcessors != null) {
            for (ExtensionPostProcessor processor : this.extensionPostProcessors) {
                instance = processor.postProcessBeforeInitialization(instance, name);
            }
        }
        return instance;
    }

    private T postProcessAfterInitialization(T instance, String name) throws Exception {
        if (instance instanceof ExtensionAccessorAware) {
            ((ExtensionAccessorAware)instance).setExtensionAccessor(this.extensionDirector);
        }
        if (this.extensionPostProcessors != null) {
            for (ExtensionPostProcessor processor : this.extensionPostProcessors) {
                instance = processor.postProcessAfterInitialization(instance, name);
            }
        }
        return instance;
    }

    private boolean containsExtension(String name) {
        return this.getExtensionClasses().containsKey(name);
    }

    private T injectExtension(T instance) {
        if (this.injector == null) {
            return instance;
        }
        try {
            for (Method method : instance.getClass().getMethods()) {
                Class<?> pt;
                if (!this.isSetter(method) || method.isAnnotationPresent(DisableInject.class) || method.getDeclaringClass() == ScopeModelAware.class || (instance instanceof ScopeModelAware || instance instanceof ExtensionAccessorAware) && ignoredInjectMethodsDesc.contains(ReflectUtils.getDesc(method)) || ReflectUtils.isPrimitives(pt = method.getParameterTypes()[0])) continue;
                try {
                    String property = this.getSetterProperty(method);
                    Object object = this.injector.getInstance(pt, property);
                    if (object == null) continue;
                    method.invoke(instance, object);
                }
                catch (Exception e) {
                    logger.error("0-15", "", "", "Failed to inject via method " + method.getName() + " of interface " + this.type.getName() + ": " + e.getMessage(), e);
                }
            }
        }
        catch (Exception e) {
            logger.error("0-15", "", "", e.getMessage(), e);
        }
        return instance;
    }

    private void initExtension(T instance) {
        if (instance instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)instance;
            lifecycle.initialize();
        }
    }

    private String getSetterProperty(Method method) {
        return method.getName().length() > 3 ? method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4) : "";
    }

    private boolean isSetter(Method method) {
        return method.getName().startsWith("set") && method.getParameterTypes().length == 1 && Modifier.isPublic(method.getModifiers());
    }

    private Class<?> getExtensionClass(String name) {
        if (this.type == null) {
            throw new IllegalArgumentException("Extension type == null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Extension name == null");
        }
        return this.getExtensionClasses().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Class<?>> getExtensionClasses() {
        Map<String, Class<?>> classes = this.cachedClasses.get();
        if (classes == null) {
            Holder<Map<String, Class<?>>> holder = this.cachedClasses;
            synchronized (holder) {
                classes = this.cachedClasses.get();
                if (classes == null) {
                    try {
                        classes = this.loadExtensionClasses();
                    }
                    catch (InterruptedException e) {
                        logger.error("0-15", "", "", "Exception occurred when loading extension class (interface: " + this.type + ")", e);
                        throw new IllegalStateException("Exception occurred when loading extension class (interface: " + this.type + ")", e);
                    }
                    this.cachedClasses.set(classes);
                }
            }
        }
        return classes;
    }

    private Map<String, Class<?>> loadExtensionClasses() throws InterruptedException {
        this.checkDestroyed();
        this.cacheDefaultExtensionName();
        HashMap extensionClasses = new HashMap();
        for (LoadingStrategy strategy : strategies) {
            this.loadDirectory(extensionClasses, strategy, this.type.getName());
            if (this.type != ExtensionInjector.class) continue;
            this.loadDirectory(extensionClasses, strategy, ExtensionFactory.class.getName());
        }
        return extensionClasses;
    }

    private void loadDirectory(Map<String, Class<?>> extensionClasses, LoadingStrategy strategy, String type) throws InterruptedException {
        this.loadDirectoryInternal(extensionClasses, strategy, type);
        try {
            String oldType = type.replace("org.apache", "com.alibaba");
            if (oldType.equals(type)) {
                return;
            }
            ClassUtils.forName(oldType);
            this.loadDirectoryInternal(extensionClasses, strategy, oldType);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void cacheDefaultExtensionName() {
        SPI defaultAnnotation = this.type.getAnnotation(SPI.class);
        if (defaultAnnotation == null) {
            return;
        }
        String value = defaultAnnotation.value();
        if ((value = value.trim()).length() > 0) {
            Object[] names = NAME_SEPARATOR.split(value);
            if (names.length > 1) {
                throw new IllegalStateException("More than 1 default extension name on extension " + this.type.getName() + ": " + Arrays.toString(names));
            }
            if (names.length == 1) {
                this.cachedDefaultName = names[0];
            }
        }
    }

    private void loadDirectoryInternal(Map<String, Class<?>> extensionClasses, LoadingStrategy loadingStrategy, String type) throws InterruptedException {
        String fileName = loadingStrategy.directory() + type;
        try {
            LinkedList<ClassLoader> classLoadersToLoad = new LinkedList<ClassLoader>();
            if (loadingStrategy.preferExtensionClassLoader()) {
                ClassLoader extensionLoaderClassLoader = ExtensionLoader.class.getClassLoader();
                if (ClassLoader.getSystemClassLoader() != extensionLoaderClassLoader) {
                    classLoadersToLoad.add(extensionLoaderClassLoader);
                }
            }
            if (specialSPILoadingStrategyMap.containsKey(type)) {
                String internalDirectoryType = specialSPILoadingStrategyMap.get(type);
                if (!"ALL".equals(internalDirectoryType) && !internalDirectoryType.equals(loadingStrategy.getName())) {
                    return;
                }
                classLoadersToLoad.clear();
                classLoadersToLoad.add(ExtensionLoader.class.getClassLoader());
            } else {
                Set<ClassLoader> classLoaders = this.scopeModel.getClassLoaders();
                if (CollectionUtils.isEmpty(classLoaders)) {
                    Enumeration<java.net.URL> resources = ClassLoader.getSystemResources(fileName);
                    if (resources != null) {
                        while (resources.hasMoreElements()) {
                            this.loadResource(extensionClasses, null, resources.nextElement(), loadingStrategy.overridden(), loadingStrategy.includedPackages(), loadingStrategy.excludedPackages(), loadingStrategy.onlyExtensionClassLoaderPackages());
                        }
                    }
                } else {
                    classLoadersToLoad.addAll(classLoaders);
                }
            }
            Map<ClassLoader, Set<java.net.URL>> resources = ClassLoaderResourceLoader.loadResources(fileName, classLoadersToLoad);
            resources.forEach((classLoader, urls) -> this.loadFromClass(extensionClasses, loadingStrategy.overridden(), (Set<java.net.URL>)urls, (ClassLoader)classLoader, loadingStrategy.includedPackages(), loadingStrategy.excludedPackages(), loadingStrategy.onlyExtensionClassLoaderPackages()));
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable t) {
            logger.error("0-15", "", "", "Exception occurred when loading extension class (interface: " + type + ", description file: " + fileName + ").", t);
        }
    }

    private void loadFromClass(Map<String, Class<?>> extensionClasses, boolean overridden, Set<java.net.URL> urls, ClassLoader classLoader, String[] includedPackages, String[] excludedPackages, String[] onlyExtensionClassLoaderPackages) {
        if (CollectionUtils.isNotEmpty(urls)) {
            for (java.net.URL url : urls) {
                this.loadResource(extensionClasses, classLoader, url, overridden, includedPackages, excludedPackages, onlyExtensionClassLoaderPackages);
            }
        }
    }

    private void loadResource(Map<String, Class<?>> extensionClasses, ClassLoader classLoader, java.net.URL resourceURL, boolean overridden, String[] includedPackages, String[] excludedPackages, String[] onlyExtensionClassLoaderPackages) {
        try {
            List<String> newContentList = this.getResourceContent(resourceURL);
            for (String line : newContentList) {
                try {
                    String clazz;
                    String name = null;
                    int i = line.indexOf(61);
                    if (i > 0) {
                        name = line.substring(0, i).trim();
                        clazz = line.substring(i + 1).trim();
                    } else {
                        clazz = line;
                    }
                    if (!StringUtils.isNotEmpty(clazz) || this.isExcluded(clazz, excludedPackages) || !this.isIncluded(clazz, includedPackages) || this.isExcludedByClassLoader(clazz, classLoader, onlyExtensionClassLoaderPackages)) continue;
                    this.loadClass(extensionClasses, resourceURL, Class.forName(clazz, true, classLoader), name, overridden);
                }
                catch (Throwable t) {
                    IllegalStateException e = new IllegalStateException("Failed to load extension class (interface: " + this.type + ", class line: " + line + ") in " + resourceURL + ", cause: " + t.getMessage(), t);
                    this.exceptions.put(line, e);
                }
            }
        }
        catch (Throwable t) {
            logger.error("0-15", "", "", "Exception occurred when loading extension class (interface: " + this.type + ", class file: " + resourceURL + ") in " + resourceURL, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> getResourceContent(java.net.URL resourceURL) throws IOException {
        Map<java.net.URL, List<String>> urlListMap = urlListMapCache.get();
        if (urlListMap != null) return urlListMap.computeIfAbsent(resourceURL, key -> {
            ArrayList<String> newContentList = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resourceURL.openStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    int ci = line.indexOf(35);
                    if (ci >= 0) {
                        line = line.substring(0, ci);
                    }
                    if ((line = line.trim()).length() <= 0) continue;
                    newContentList.add(line);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return newContentList;
        });
        Class<ExtensionLoader> clazz = ExtensionLoader.class;
        synchronized (ExtensionLoader.class) {
            urlListMap = urlListMapCache.get();
            if (urlListMap != null) return urlListMap.computeIfAbsent(resourceURL, key -> {
                ArrayList<String> newContentList = new ArrayList<String>();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(resourceURL.openStream(), StandardCharsets.UTF_8));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        int ci = line.indexOf(35);
                        if (ci >= 0) {
                            line = line.substring(0, ci);
                        }
                        if ((line = line.trim()).length() <= 0) continue;
                        newContentList.add(line);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                return newContentList;
            });
            urlListMap = new ConcurrentHashMap<java.net.URL, List<String>>();
            urlListMapCache = new SoftReference<Map<java.net.URL, List<String>>>(urlListMap);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return urlListMap.computeIfAbsent(resourceURL, key -> {
                ArrayList<String> newContentList = new ArrayList<String>();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(resourceURL.openStream(), StandardCharsets.UTF_8));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        int ci = line.indexOf(35);
                        if (ci >= 0) {
                            line = line.substring(0, ci);
                        }
                        if ((line = line.trim()).length() <= 0) continue;
                        newContentList.add(line);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                return newContentList;
            });
        }
    }

    private boolean isIncluded(String className, String ... includedPackages) {
        if (includedPackages != null && includedPackages.length > 0) {
            for (String includedPackage : includedPackages) {
                if (!className.startsWith(includedPackage + ".")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isExcluded(String className, String ... excludedPackages) {
        if (excludedPackages != null) {
            for (String excludePackage : excludedPackages) {
                if (!className.startsWith(excludePackage + ".")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isExcludedByClassLoader(String className, ClassLoader classLoader, String ... onlyExtensionClassLoaderPackages) {
        if (onlyExtensionClassLoaderPackages != null) {
            for (String excludePackage : onlyExtensionClassLoaderPackages) {
                if (!className.startsWith(excludePackage + ".")) continue;
                return !Objects.equals(ExtensionLoader.class.getClassLoader(), classLoader);
            }
        }
        return false;
    }

    private void loadClass(Map<String, Class<?>> extensionClasses, java.net.URL resourceURL, Class<?> clazz, String name, boolean overridden) {
        if (!this.type.isAssignableFrom(clazz)) {
            throw new IllegalStateException("Error occurred when loading extension class (interface: " + this.type + ", class line: " + clazz.getName() + "), class " + clazz.getName() + " is not subtype of interface.");
        }
        if (clazz.isAnnotationPresent(Adaptive.class)) {
            this.cacheAdaptiveClass(clazz, overridden);
        } else if (this.isWrapperClass(clazz)) {
            this.cacheWrapperClass(clazz);
        } else {
            if (StringUtils.isEmpty(name) && (name = this.findAnnotationName(clazz)).length() == 0) {
                throw new IllegalStateException("No such extension name for the class " + clazz.getName() + " in the config " + resourceURL);
            }
            Object[] names = NAME_SEPARATOR.split(name);
            if (ArrayUtils.isNotEmpty(names)) {
                this.cacheActivateClass(clazz, (String)names[0]);
                for (Object n : names) {
                    this.cacheName(clazz, (String)n);
                    this.saveInExtensionClass(extensionClasses, clazz, (String)n, overridden);
                }
            }
        }
    }

    private void cacheName(Class<?> clazz, String name) {
        if (!this.cachedNames.containsKey(clazz)) {
            this.cachedNames.put(clazz, name);
        }
    }

    private void saveInExtensionClass(Map<String, Class<?>> extensionClasses, Class<?> clazz, String name, boolean overridden) {
        Class<?> c = extensionClasses.get(name);
        if (c == null || overridden) {
            extensionClasses.put(name, clazz);
        } else if (c != clazz) {
            this.unacceptableExceptions.add(name);
            String duplicateMsg = "Duplicate extension " + this.type.getName() + " name " + name + " on " + c.getName() + " and " + clazz.getName();
            logger.error("0-15", "", "", duplicateMsg);
            throw new IllegalStateException(duplicateMsg);
        }
    }

    private void cacheActivateClass(Class<?> clazz, String name) {
        Activate activate = clazz.getAnnotation(Activate.class);
        if (activate != null) {
            this.cachedActivates.put(name, activate);
        } else {
            com.alibaba.dubbo.common.extension.Activate oldActivate = clazz.getAnnotation(com.alibaba.dubbo.common.extension.Activate.class);
            if (oldActivate != null) {
                this.cachedActivates.put(name, oldActivate);
            }
        }
    }

    private void cacheAdaptiveClass(Class<?> clazz, boolean overridden) {
        if (this.cachedAdaptiveClass == null || overridden) {
            this.cachedAdaptiveClass = clazz;
        } else if (!this.cachedAdaptiveClass.equals(clazz)) {
            throw new IllegalStateException("More than 1 adaptive class found: " + this.cachedAdaptiveClass.getName() + ", " + clazz.getName());
        }
    }

    private void cacheWrapperClass(Class<?> clazz) {
        if (this.cachedWrapperClasses == null) {
            this.cachedWrapperClasses = new ConcurrentHashSet();
        }
        this.cachedWrapperClasses.add(clazz);
    }

    protected boolean isWrapperClass(Class<?> clazz) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 1 || constructor.getParameterTypes()[0] != this.type) continue;
            return true;
        }
        return false;
    }

    private String findAnnotationName(Class<?> clazz) {
        Extension extension = clazz.getAnnotation(Extension.class);
        if (extension != null) {
            return extension.value();
        }
        String name = clazz.getSimpleName();
        if (name.endsWith(this.type.getSimpleName())) {
            name = name.substring(0, name.length() - this.type.getSimpleName().length());
        }
        return name.toLowerCase();
    }

    private T createAdaptiveExtension() {
        try {
            Object instance = this.getAdaptiveExtensionClass().newInstance();
            instance = this.postProcessBeforeInitialization(instance, null);
            this.injectExtension(instance);
            instance = this.postProcessAfterInitialization(instance, null);
            this.initExtension(instance);
            return (T)instance;
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't create adaptive extension " + this.type + ", cause: " + e.getMessage(), e);
        }
    }

    private Class<?> getAdaptiveExtensionClass() {
        this.getExtensionClasses();
        if (this.cachedAdaptiveClass != null) {
            return this.cachedAdaptiveClass;
        }
        this.cachedAdaptiveClass = this.createAdaptiveExtensionClass();
        return this.cachedAdaptiveClass;
    }

    private Class<?> createAdaptiveExtensionClass() {
        ClassLoader classLoader = this.type.getClassLoader();
        try {
            if (NativeUtils.isNative()) {
                return classLoader.loadClass(this.type.getName() + "$Adaptive");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String code = new AdaptiveClassCodeGenerator(this.type, this.cachedDefaultName).generate();
        Compiler compiler = this.extensionDirector.getExtensionLoader(Compiler.class).getAdaptiveExtension();
        return compiler.compile(this.type, code, classLoader);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.type.getName() + "]";
    }

    private static Properties loadProperties(ClassLoader classLoader, String resourceName) {
        Properties properties = new Properties();
        if (classLoader != null) {
            try {
                Enumeration<java.net.URL> resources = classLoader.getResources(resourceName);
                while (resources.hasMoreElements()) {
                    java.net.URL url = resources.nextElement();
                    Properties props = ExtensionLoader.loadFromUrl(url);
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        String key = entry.getKey().toString();
                        if (properties.containsKey(key)) continue;
                        properties.put(key, entry.getValue().toString());
                    }
                }
            }
            catch (IOException ex) {
                logger.error("5-5", "", "", "load properties failed.", ex);
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadFromUrl(java.net.URL url) {
        Properties properties = new Properties();
        InputStream is = null;
        try {
            is = url.openStream();
            properties.load(is);
        }
        catch (IOException iOException) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }
}

