/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import java.util.Enumeration;
import jdbm.RecordManager;
import jdbm.helper.CacheEvictionException;
import jdbm.helper.CachePolicy;
import jdbm.helper.CachePolicyListener;
import jdbm.helper.DefaultSerializer;
import jdbm.helper.Serializer;
import jdbm.helper.WrappedRuntimeException;
import org.apache.directory.server.i18n.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheRecordManager
implements RecordManager {
    protected RecordManager recMgr;
    protected CachePolicy<Long, CacheEntry> cache;

    public CacheRecordManager(RecordManager recMgr, CachePolicy<Long, CacheEntry> cache) {
        if (recMgr == null) {
            throw new IllegalArgumentException(I18n.err((String)I18n.ERR_517, (Object[])new Object[0]));
        }
        if (cache == null) {
            throw new IllegalArgumentException(I18n.err((String)I18n.ERR_542, (Object[])new Object[0]));
        }
        this.recMgr = recMgr;
        this.cache = cache;
        this.cache.addListener(new CacheListener());
    }

    public RecordManager getRecordManager() {
        return this.recMgr;
    }

    public CachePolicy<Long, CacheEntry> getCachePolicy() {
        return this.cache;
    }

    @Override
    public long insert(Object obj) throws IOException {
        return this.insert(obj, DefaultSerializer.INSTANCE);
    }

    @Override
    public synchronized long insert(Object obj, Serializer serializer) throws IOException {
        this.checkIfClosed();
        long recid = this.recMgr.insert(obj, serializer);
        try {
            this.cache.put(recid, new CacheEntry(recid, obj, serializer, false));
        }
        catch (CacheEvictionException except) {
            throw new WrappedRuntimeException(except);
        }
        return recid;
    }

    @Override
    public synchronized void delete(long recid) throws IOException {
        this.checkIfClosed();
        this.recMgr.delete(recid);
        this.cache.remove(recid);
    }

    @Override
    public void update(long recid, Object obj) throws IOException {
        this.update(recid, obj, DefaultSerializer.INSTANCE);
    }

    @Override
    public synchronized void update(long recid, Object obj, Serializer serializer) throws IOException {
        this.checkIfClosed();
        try {
            CacheEntry entry = this.cache.get(recid);
            if (entry != null) {
                entry.obj = obj;
                entry.serializer = serializer;
                entry.isDirty = true;
            } else {
                this.cache.put(recid, new CacheEntry(recid, obj, serializer, true));
            }
        }
        catch (CacheEvictionException except) {
            throw new IOException(except.getLocalizedMessage());
        }
    }

    @Override
    public Object fetch(long recid) throws IOException {
        return this.fetch(recid, DefaultSerializer.INSTANCE);
    }

    @Override
    public synchronized Object fetch(long recid, Serializer serializer) throws IOException {
        this.checkIfClosed();
        CacheEntry entry = this.cache.get(recid);
        if (entry == null) {
            entry = new CacheEntry(recid, null, serializer, false);
            entry.obj = this.recMgr.fetch(recid, serializer);
            try {
                this.cache.put(recid, entry);
            }
            catch (CacheEvictionException except) {
                throw new WrappedRuntimeException(except);
            }
        }
        if (entry.obj instanceof byte[]) {
            byte[] copy = new byte[((byte[])entry.obj).length];
            System.arraycopy(entry.obj, 0, copy, 0, ((byte[])entry.obj).length);
            return copy;
        }
        return entry.obj;
    }

    @Override
    public synchronized void close() throws IOException {
        this.checkIfClosed();
        this.updateCacheEntries();
        this.recMgr.close();
        this.recMgr = null;
        this.cache = null;
    }

    @Override
    public synchronized int getRootCount() {
        this.checkIfClosed();
        return this.recMgr.getRootCount();
    }

    @Override
    public synchronized long getRoot(int id) throws IOException {
        this.checkIfClosed();
        return this.recMgr.getRoot(id);
    }

    @Override
    public synchronized void setRoot(int id, long rowid) throws IOException {
        this.checkIfClosed();
        this.recMgr.setRoot(id, rowid);
    }

    @Override
    public synchronized void commit() throws IOException {
        this.checkIfClosed();
        this.updateCacheEntries();
        this.recMgr.commit();
    }

    @Override
    public synchronized void rollback() throws IOException {
        this.checkIfClosed();
        this.recMgr.rollback();
        this.cache.removeAll();
    }

    @Override
    public synchronized long getNamedObject(String name) throws IOException {
        this.checkIfClosed();
        return this.recMgr.getNamedObject(name);
    }

    @Override
    public synchronized void setNamedObject(String name, long recid) throws IOException {
        this.checkIfClosed();
        this.recMgr.setNamedObject(name, recid);
    }

    private void checkIfClosed() throws IllegalStateException {
        if (this.recMgr == null) {
            throw new IllegalStateException(I18n.err((String)I18n.ERR_538, (Object[])new Object[0]));
        }
    }

    protected void updateCacheEntries() throws IOException {
        Enumeration<CacheEntry> enume = this.cache.elements();
        while (enume.hasMoreElements()) {
            CacheEntry entry = enume.nextElement();
            if (!entry.isDirty) continue;
            this.recMgr.update(entry.recid, entry.obj, entry.serializer);
            entry.isDirty = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CacheListener
    implements CachePolicyListener<CacheEntry> {
        private CacheListener() {
        }

        @Override
        public void cacheObjectEvicted(CacheEntry obj) throws CacheEvictionException {
            CacheEntry entry = obj;
            if (entry.isDirty) {
                try {
                    CacheRecordManager.this.recMgr.update(entry.recid, entry.obj, entry.serializer);
                }
                catch (IOException except) {
                    throw new CacheEvictionException(except);
                }
            }
        }
    }

    private class CacheEntry {
        long recid;
        Object obj;
        Serializer serializer;
        boolean isDirty;

        CacheEntry(long recid, Object obj, Serializer serializer, boolean isDirty) {
            this.recid = recid;
            this.obj = obj;
            this.serializer = serializer;
            this.isDirty = isDirty;
        }
    }
}

