/*
 * Decompiled with CFR 0.152.
 */
package jdbm.btree;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Comparator;
import jdbm.RecordManager;
import jdbm.btree.BPage;
import jdbm.helper.Serializer;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import org.apache.directory.server.i18n.I18n;

public class BTree
implements Externalizable {
    private static final boolean DEBUG = false;
    static final long serialVersionUID = 1L;
    public static final int DEFAULT_SIZE = 16;
    protected transient RecordManager _recman;
    private transient long _recid;
    protected Comparator _comparator;
    protected Serializer _keySerializer;
    protected Serializer _valueSerializer;
    private int _height;
    private transient long _root;
    protected int _pageSize;
    protected int _entries;
    private transient BPage _bpageSerializer;

    public static BTree createInstance(RecordManager recman, Comparator comparator) throws IOException {
        return BTree.createInstance(recman, comparator, null, null, 16);
    }

    public static BTree createInstance(RecordManager recman, Comparator comparator, Serializer keySerializer, Serializer valueSerializer) throws IOException {
        return BTree.createInstance(recman, comparator, keySerializer, valueSerializer, 16);
    }

    public static BTree createInstance(RecordManager recman, Comparator comparator, Serializer keySerializer, Serializer valueSerializer, int pageSize) throws IOException {
        if (recman == null) {
            throw new IllegalArgumentException(I18n.err((String)I18n.ERR_517, (Object[])new Object[0]));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(I18n.err((String)I18n.ERR_518, (Object[])new Object[0]));
        }
        if (!(comparator instanceof Serializable)) {
            throw new IllegalArgumentException(I18n.err((String)I18n.ERR_519, (Object[])new Object[0]));
        }
        if (keySerializer != null && !(keySerializer instanceof Serializable)) {
            throw new IllegalArgumentException(I18n.err((String)I18n.ERR_520, (Object[])new Object[0]));
        }
        if (valueSerializer != null && !(valueSerializer instanceof Serializable)) {
            throw new IllegalArgumentException(I18n.err((String)I18n.ERR_521, (Object[])new Object[0]));
        }
        if ((pageSize & 1) != 0) {
            throw new IllegalArgumentException(I18n.err((String)I18n.ERR_522, (Object[])new Object[0]));
        }
        BTree btree = new BTree();
        btree._recman = recman;
        btree._comparator = comparator;
        btree._keySerializer = keySerializer;
        btree._valueSerializer = valueSerializer;
        btree._pageSize = pageSize;
        btree._bpageSerializer = new BPage();
        btree._bpageSerializer._btree = btree;
        btree._recid = recman.insert(btree);
        return btree;
    }

    public static BTree load(RecordManager recman, long recid) throws IOException {
        BTree btree = (BTree)recman.fetch(recid);
        btree._recid = recid;
        btree._recman = recman;
        btree._bpageSerializer = new BPage();
        btree._bpageSerializer._btree = btree;
        return btree;
    }

    public synchronized Object insert(Object key, Object value, boolean replace) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException(I18n.err((String)I18n.ERR_523, (Object[])new Object[0]));
        }
        if (value == null) {
            throw new IllegalArgumentException(I18n.err((String)I18n.ERR_524, (Object[])new Object[0]));
        }
        BPage rootPage = this.getRoot();
        if (rootPage == null) {
            rootPage = new BPage(this, key, value);
            this._root = rootPage._recid;
            this._height = 1;
            this._entries = 1;
            this._recman.update(this._recid, this);
            return null;
        }
        BPage.InsertResult insert = rootPage.insert(this._height, key, value, replace);
        boolean dirty = false;
        if (insert._overflow != null) {
            rootPage = new BPage(this, rootPage, insert._overflow);
            this._root = rootPage._recid;
            ++this._height;
            dirty = true;
        }
        if (insert._existing == null) {
            ++this._entries;
            dirty = true;
        }
        if (dirty) {
            this._recman.update(this._recid, this);
        }
        return insert._existing;
    }

    public synchronized Object remove(Object key) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException(I18n.err((String)I18n.ERR_523, (Object[])new Object[0]));
        }
        BPage rootPage = this.getRoot();
        if (rootPage == null) {
            return null;
        }
        boolean dirty = false;
        BPage.RemoveResult remove = rootPage.remove(this._height, key);
        if (remove._underflow && rootPage.isEmpty()) {
            --this._height;
            dirty = true;
            this._recman.delete(this._root);
            this._root = this._height == 0 ? 0L : rootPage.childBPage((int)(this._pageSize - 1))._recid;
        }
        if (remove._value != null) {
            --this._entries;
            dirty = true;
        }
        if (dirty) {
            this._recman.update(this._recid, this);
        }
        return remove._value;
    }

    public synchronized Object find(Object key) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException(I18n.err((String)I18n.ERR_523, (Object[])new Object[0]));
        }
        BPage rootPage = this.getRoot();
        if (rootPage == null) {
            return null;
        }
        Tuple tuple = new Tuple(null, null);
        TupleBrowser browser = rootPage.find(this._height, key);
        if (browser.getNext(tuple)) {
            if (this._comparator.compare(key, tuple.getKey()) != 0) {
                return null;
            }
            return tuple.getValue();
        }
        return null;
    }

    public synchronized Tuple findGreaterOrEqual(Object key) throws IOException {
        if (key == null) {
            return null;
        }
        Tuple tuple = new Tuple(null, null);
        TupleBrowser browser = this.browse(key);
        if (browser.getNext(tuple)) {
            return tuple;
        }
        return null;
    }

    public synchronized TupleBrowser browse() throws IOException {
        BPage rootPage = this.getRoot();
        if (rootPage == null) {
            return EmptyBrowser.INSTANCE;
        }
        TupleBrowser browser = rootPage.findFirst();
        return browser;
    }

    public synchronized TupleBrowser browse(Object key) throws IOException {
        BPage rootPage = this.getRoot();
        if (rootPage == null) {
            return EmptyBrowser.INSTANCE;
        }
        TupleBrowser browser = rootPage.find(this._height, key);
        return browser;
    }

    public synchronized int size() {
        return this._entries;
    }

    public long getRecid() {
        return this._recid;
    }

    private BPage getRoot() throws IOException {
        if (this._root == 0L) {
            return null;
        }
        BPage root = (BPage)this._recman.fetch(this._root, this._bpageSerializer);
        root._recid = this._root;
        root._btree = this;
        return root;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._comparator = (Comparator)in.readObject();
        this._keySerializer = (Serializer)in.readObject();
        this._valueSerializer = (Serializer)in.readObject();
        this._height = in.readInt();
        this._root = in.readLong();
        this._pageSize = in.readInt();
        this._entries = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._comparator);
        out.writeObject(this._keySerializer);
        out.writeObject(this._valueSerializer);
        out.writeInt(this._height);
        out.writeLong(this._root);
        out.writeInt(this._pageSize);
        out.writeInt(this._entries);
    }

    public void setValueSerializer(Serializer valueSerializer) {
        this._valueSerializer = valueSerializer;
    }

    public Comparator getComparator() {
        return this._comparator;
    }

    static class EmptyBrowser
    extends TupleBrowser {
        static TupleBrowser INSTANCE = new EmptyBrowser();

        EmptyBrowser() {
        }

        public boolean getNext(Tuple tuple) {
            return false;
        }

        public boolean getPrevious(Tuple tuple) {
            return false;
        }
    }
}

