/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.impl;

import java.util.Map;
import java.util.Optional;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.delegate.MessagePayloadMappingProvider;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.runtime.api.impl.VariablesMappingProvider;

public class JsonMessagePayloadMappingProvider
implements MessagePayloadMappingProvider {
    private final Event bpmnEvent;
    private final MessageEventDefinition messageEventDefinition;
    private final ExpressionManager expressionManager;
    private final VariablesMappingProvider variablesMappingProvider;

    public JsonMessagePayloadMappingProvider(Event bpmnEvent, MessageEventDefinition messageEventDefinition, ExpressionManager expressionManager, VariablesMappingProvider variablesMappingProvider) {
        this.bpmnEvent = bpmnEvent;
        this.messageEventDefinition = messageEventDefinition;
        this.expressionManager = expressionManager;
        this.variablesMappingProvider = variablesMappingProvider;
    }

    public Optional<Map<String, Object>> getMessagePayload(DelegateExecution execution) {
        return Optional.of(this.variablesMappingProvider.calculateInputVariables(execution)).filter(payload -> !payload.isEmpty());
    }

    public Event getBpmnEvent() {
        return this.bpmnEvent;
    }

    public MessageEventDefinition getMessageEventDefinition() {
        return this.messageEventDefinition;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public VariablesMappingProvider getVariablesMappingProvider() {
        return this.variablesMappingProvider;
    }
}

