/*
 * Decompiled with CFR 0.152.
 */
package ytx.org.apache.http.message;

import ytx.org.apache.http.HttpRequest;
import ytx.org.apache.http.ProtocolVersion;
import ytx.org.apache.http.RequestLine;
import ytx.org.apache.http.annotation.NotThreadSafe;
import ytx.org.apache.http.message.AbstractHttpMessage;
import ytx.org.apache.http.message.BasicRequestLine;
import ytx.org.apache.http.params.HttpProtocolParams;

@NotThreadSafe
public class BasicHttpRequest
extends AbstractHttpMessage
implements HttpRequest {
    private final String method;
    private final String uri;
    private RequestLine requestline;

    public BasicHttpRequest(String method, String uri) {
        if (method == null) {
            throw new IllegalArgumentException("Method name may not be null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Request URI may not be null");
        }
        this.method = method;
        this.uri = uri;
        this.requestline = null;
    }

    public BasicHttpRequest(String method, String uri, ProtocolVersion ver) {
        this(new BasicRequestLine(method, uri, ver));
    }

    public BasicHttpRequest(RequestLine requestline) {
        if (requestline == null) {
            throw new IllegalArgumentException("Request line may not be null");
        }
        this.requestline = requestline;
        this.method = requestline.getMethod();
        this.uri = requestline.getUri();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.getRequestLine().getProtocolVersion();
    }

    @Override
    public RequestLine getRequestLine() {
        if (this.requestline == null) {
            ProtocolVersion ver = HttpProtocolParams.getVersion(this.getParams());
            this.requestline = new BasicRequestLine(this.method, this.uri, ver);
        }
        return this.requestline;
    }

    public String toString() {
        return String.valueOf(this.method) + " " + this.uri + " " + this.headergroup;
    }
}

