/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.AbstractKubernetesManifestGenerator;
import io.dekorate.BuildServiceFactories;
import io.dekorate.ConfigurationRegistry;
import io.dekorate.ResourceRegistry;
import io.dekorate.WithProject;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.kubernetes.config.ApplicationConfiguration;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.EditableKubernetesConfig;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.kubernetes.config.ImageConfigurationBuilder;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.kubernetes.config.KubernetesConfigBuilder;
import io.dekorate.kubernetes.configurator.ApplyDeployToApplicationConfiguration;
import io.dekorate.kubernetes.decorator.AddIngressDecorator;
import io.dekorate.kubernetes.decorator.AddInitContainerDecorator;
import io.dekorate.kubernetes.decorator.AddServiceResourceDecorator;
import io.dekorate.kubernetes.decorator.ApplyHeadlessDecorator;
import io.dekorate.kubernetes.decorator.ApplyImageDecorator;
import io.dekorate.kubernetes.decorator.ApplyReplicasDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.project.ApplyProjectInfo;
import io.dekorate.project.Project;
import io.dekorate.utils.Images;
import io.dekorate.utils.Labels;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import java.util.Optional;

public class MinikubeManifestGenerator
extends AbstractKubernetesManifestGenerator<KubernetesConfig>
implements WithProject {
    private static final String DEFAULT_REGISTRY = "docker.io";
    private static final String IF_NOT_PRESENT = "IfNotPresent";
    private static final String KUBERNETES_NAMESPACE = "KUBERNETES_NAMESPACE";
    private static final String METADATA_NAMESPACE = "metadata.namespace";
    private static final String MINIKUBE = "minikube";
    private final ConfigurationRegistry configurationRegistry;

    public MinikubeManifestGenerator(ResourceRegistry resourceRegistry, ConfigurationRegistry configurationRegistry) {
        super(resourceRegistry);
        this.configurationRegistry = configurationRegistry;
    }

    public String getKey() {
        return MINIKUBE;
    }

    public int order() {
        return 210;
    }

    public void generate(KubernetesConfig config) {
        ImageConfiguration imageConfig = MinikubeManifestGenerator.getImageConfiguration(this.getProject(), config, this.configurationRegistry);
        Optional<Deployment> existingDeployment = this.resourceRegistry.groups().getOrDefault(MINIKUBE, new KubernetesListBuilder()).buildItems().stream().filter(i -> i instanceof Deployment).map(i -> (Deployment)i).filter(i -> i.getMetadata().getName().equals(config.getName())).findAny();
        if (!existingDeployment.isPresent()) {
            this.resourceRegistry.add(MINIKUBE, (HasMetadata)this.createDeployment(config, imageConfig));
        }
        this.addDecorators(MINIKUBE, config);
        if (config.isHeadless()) {
            this.resourceRegistry.decorate(MINIKUBE, (Decorator)new ApplyHeadlessDecorator(config.getName()));
        }
        if (config.getReplicas() != 1) {
            this.resourceRegistry.decorate(MINIKUBE, (Decorator)new ApplyReplicasDecorator(config.getName(), config.getReplicas().intValue()));
        }
        String image = Strings.isNotNullOrEmpty((String)imageConfig.getImage()) ? imageConfig.getImage() : Images.getImage((String)(imageConfig.isAutoPushEnabled() ? (Strings.isNullOrEmpty((String)imageConfig.getRegistry()) ? DEFAULT_REGISTRY : imageConfig.getRegistry()) : imageConfig.getRegistry()), (String)imageConfig.getGroup(), (String)imageConfig.getName(), (String)imageConfig.getVersion());
        this.resourceRegistry.decorate(MINIKUBE, (Decorator)new ApplyImageDecorator(config.getName(), image));
    }

    public boolean accepts(Class<? extends Configuration> type) {
        return type.equals(KubernetesConfig.class) || type.equals(EditableKubernetesConfig.class);
    }

    protected void addDecorators(String group, KubernetesConfig config) {
        super.addDecorators(group, (BaseConfig)config);
        for (Container container : config.getInitContainers()) {
            this.resourceRegistry.decorate(group, (Decorator)new AddInitContainerDecorator(config.getName(), container));
        }
        if (config.getPorts().length > 0) {
            this.resourceRegistry.decorate(group, (Decorator)new AddServiceResourceDecorator((BaseConfig)config));
        }
        this.resourceRegistry.decorate(group, (Decorator)new AddIngressDecorator(config, Labels.createLabelsAsMap((BaseConfig)config, (String)"Ingress")));
    }

    public Deployment createDeployment(KubernetesConfig appConfig, ImageConfiguration imageConfig) {
        return ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(appConfig.getName())).withLabels(Labels.createLabelsAsMap((BaseConfig)appConfig, (String)"Deployment"))).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(1))).withTemplate(MinikubeManifestGenerator.createPodTemplateSpec(appConfig, imageConfig))).withSelector(this.createSelector(appConfig))).endSpec()).build();
    }

    public LabelSelector createSelector(KubernetesConfig config) {
        return ((LabelSelectorBuilder)new LabelSelectorBuilder().withMatchLabels(Labels.createLabelsAsMap((BaseConfig)config, (String)"Deployment"))).build();
    }

    public static PodTemplateSpec createPodTemplateSpec(KubernetesConfig appConfig, ImageConfiguration imageConfig) {
        return ((PodTemplateSpecBuilder)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecBuilder)new PodTemplateSpecBuilder().withSpec(MinikubeManifestGenerator.createPodSpec(appConfig, imageConfig))).withNewMetadata().withLabels(Labels.createLabelsAsMap((BaseConfig)appConfig, (String)"Deployment"))).endMetadata()).build();
    }

    public static PodSpec createPodSpec(KubernetesConfig appConfig, ImageConfiguration imageConfig) {
        String image = Images.getImage((String)(imageConfig.isAutoPushEnabled() ? (Strings.isNullOrEmpty((String)imageConfig.getRegistry()) ? DEFAULT_REGISTRY : imageConfig.getRegistry()) : imageConfig.getRegistry()), (String)imageConfig.getGroup(), (String)imageConfig.getName(), (String)imageConfig.getVersion());
        return ((PodSpecBuilder)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)new PodSpecBuilder().addNewContainer().withName(appConfig.getName())).withImage(image)).withImagePullPolicy(IF_NOT_PRESENT)).addNewEnv().withName(KUBERNETES_NAMESPACE)).withNewValueFrom().withNewFieldRef(null, METADATA_NAMESPACE)).endValueFrom()).endEnv()).endContainer()).build();
    }

    public ConfigurationSupplier<KubernetesConfig> getFallbackConfig() {
        Project p = this.getProject();
        return new ConfigurationSupplier((VisitableBuilder)((KubernetesConfigBuilder)new KubernetesConfigBuilder().accept(new Visitor[]{new ApplyDeployToApplicationConfiguration()})).accept(new Visitor[]{new ApplyProjectInfo(p)}));
    }

    private static ImageConfiguration getImageConfiguration(Project project, KubernetesConfig appConfig, ConfigurationRegistry configurationRegistry) {
        return configurationRegistry.getImageConfig(BuildServiceFactories.supplierMatches((Project)project)).map(i -> MinikubeManifestGenerator.merge(appConfig, i)).orElse(ImageConfiguration.from((ApplicationConfiguration)appConfig));
    }

    private static ImageConfiguration merge(KubernetesConfig appConfig, ImageConfiguration imageConfig) {
        if (appConfig == null) {
            throw new NullPointerException("KubernetesConfig is null.");
        }
        if (imageConfig == null) {
            return ImageConfiguration.from((ApplicationConfiguration)appConfig);
        }
        return ((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)new ImageConfigurationBuilder().withProject(imageConfig.getProject() != null ? imageConfig.getProject() : appConfig.getProject())).withGroup(imageConfig.getGroup() != null ? imageConfig.getGroup() : null)).withName(imageConfig.getName() != null ? imageConfig.getName() : appConfig.getName())).withVersion(imageConfig.getVersion() != null ? imageConfig.getVersion() : appConfig.getVersion())).withRegistry(imageConfig.getRegistry() != null ? imageConfig.getRegistry() : null)).withDockerFile(imageConfig.getDockerFile() != null ? imageConfig.getDockerFile() : "Dockerfile")).withAutoBuildEnabled(Boolean.valueOf(imageConfig.isAutoBuildEnabled() ? imageConfig.isAutoBuildEnabled() : false))).withAutoPushEnabled(Boolean.valueOf(imageConfig.isAutoPushEnabled() ? imageConfig.isAutoPushEnabled() : false))).build();
    }
}

