/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.quarkus.kubernetes.deployment.ApplyServiceTypeDecorator;
import java.util.Optional;
import java.util.function.Predicate;
import org.jboss.logging.Logger;

public class AddNodePortDecorator
extends NamedResourceDecorator<ServiceSpecFluent> {
    private static final Logger log = Logger.getLogger(AddNodePortDecorator.class);
    private final int nodePort;
    private final Optional<String> matchingPortName;

    public AddNodePortDecorator(String name, int nodePort) {
        this(name, nodePort, Optional.empty());
    }

    public AddNodePortDecorator(String name, int nodePort, Optional<String> matchingPortName) {
        super(name);
        if (nodePort < 30000 || nodePort > 31999) {
            log.info((Object)"Using a port outside of the 30000-31999 range might not work, see https://kubernetes.io/docs/concepts/services-networking/service/#nodeport");
        }
        this.nodePort = nodePort;
        this.matchingPortName = matchingPortName;
    }

    public void andThenVisit(ServiceSpecFluent service, ObjectMeta resourceMeta) {
        ServiceSpecFluent.PortsNested editPort = this.matchingPortName.isPresent() ? service.editMatchingPort((Predicate)new Predicate<ServicePortBuilder>(){

            @Override
            public boolean test(ServicePortBuilder servicePortBuilder) {
                return servicePortBuilder.hasName() != false && servicePortBuilder.getName().equals(AddNodePortDecorator.this.matchingPortName.get());
            }
        }) : service.editFirstPort();
        editPort.withNodePort(Integer.valueOf(this.nodePort));
        editPort.endPort();
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{ApplyServiceTypeDecorator.class};
    }
}

