/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.RetryConfiguration;
import io.quarkiverse.operatorsdk.common.ClassUtils;
import io.quarkus.runtime.annotations.IgnoreProperty;
import io.quarkus.runtime.annotations.RecordableConstructor;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

public class QuarkusControllerConfiguration<R extends HasMetadata>
implements ControllerConfiguration<R> {
    private final String associatedReconcilerClassName;
    private final String name;
    private final String resourceTypeName;
    private final String crVersion;
    private final boolean generationAware;
    private final boolean registrationDelayed;
    private final String resourceClassName;
    private final Optional<String> specClassName;
    private final Optional<String> statusClassName;
    private String finalizer;
    private Set<String> namespaces;
    private RetryConfiguration retryConfiguration;
    private Class<R> resourceClass;
    private String labelSelector;
    private ConfigurationService parent;

    @RecordableConstructor
    public QuarkusControllerConfiguration(String associatedReconcilerClassName, String name, String resourceTypeName, String crVersion, boolean generationAware, String resourceClassName, boolean registrationDelayed, Set<String> namespaces, String finalizer, String labelSelector, Optional<String> specClassName, Optional<String> statusClassName) {
        this.associatedReconcilerClassName = associatedReconcilerClassName;
        this.name = name;
        this.resourceTypeName = resourceTypeName;
        this.crVersion = crVersion;
        this.generationAware = generationAware;
        this.resourceClassName = resourceClassName;
        this.registrationDelayed = registrationDelayed;
        this.retryConfiguration = super.getRetryConfiguration();
        this.setNamespaces(namespaces);
        this.setFinalizer(finalizer);
        this.labelSelector = labelSelector;
        this.specClassName = specClassName;
        this.statusClassName = statusClassName;
    }

    public static Set<String> asSet(String[] namespaces) {
        return namespaces == null || namespaces.length == 0 ? Collections.emptySet() : Set.of(namespaces);
    }

    public String getResourceClassName() {
        return this.resourceClassName;
    }

    public boolean isRegistrationDelayed() {
        return this.registrationDelayed;
    }

    @IgnoreProperty
    public Class<R> getResourceClass() {
        if (this.resourceClass == null) {
            this.resourceClass = ClassUtils.loadClass((String)this.resourceClassName);
        }
        return this.resourceClass;
    }

    public String getName() {
        return this.name;
    }

    public String getResourceTypeName() {
        return this.resourceTypeName;
    }

    public String getCrVersion() {
        return this.crVersion;
    }

    public String getFinalizer() {
        return this.finalizer;
    }

    public void setFinalizer(String finalizer) {
        this.finalizer = finalizer != null && !finalizer.isBlank() ? finalizer : ReconcilerUtils.getDefaultFinalizerName((String)this.resourceTypeName);
    }

    public boolean isGenerationAware() {
        return this.generationAware;
    }

    public String getAssociatedReconcilerClassName() {
        return this.associatedReconcilerClassName;
    }

    public Set<String> getNamespaces() {
        return this.namespaces;
    }

    void setNamespaces(Collection<String> namespaces) {
        this.namespaces = namespaces != null && !namespaces.isEmpty() ? Set.copyOf(namespaces) : Collections.emptySet();
    }

    public RetryConfiguration getRetryConfiguration() {
        return this.retryConfiguration;
    }

    public ConfigurationService getConfigurationService() {
        return this.parent;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.parent = configurationService;
    }

    void setRetryConfiguration(RetryConfiguration retryConfiguration) {
        this.retryConfiguration = retryConfiguration != null ? retryConfiguration : super.getRetryConfiguration();
    }

    @IgnoreProperty
    public Set<String> getEffectiveNamespaces() {
        return super.getEffectiveNamespaces();
    }

    public String getLabelSelector() {
        return this.labelSelector;
    }

    public void setLabelSelector(String labelSelector) {
        this.labelSelector = labelSelector;
    }

    public Optional<String> getSpecClassName() {
        return this.specClassName;
    }

    public Optional<String> getStatusClassName() {
        return this.statusClassName;
    }
}

