/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.api.config.AbstractConfigurationService;
import io.javaoperatorsdk.operator.api.config.Cloner;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.Version;
import io.javaoperatorsdk.operator.api.monitoring.Metrics;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import io.quarkus.arc.runtime.ClientProxyUnwrapper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuarkusConfigurationService
extends AbstractConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(QuarkusConfigurationService.class);
    private static final ClientProxyUnwrapper unwrapper = new ClientProxyUnwrapper();
    private final KubernetesClient client;
    private final CRDGenerationInfo crdInfo;
    private final int concurrentReconciliationThreads;
    private final Cloner cloner;
    private final int terminationTimeout;
    private final Map<String, String> reconcilerClassToName;
    private final Metrics metrics;

    public QuarkusConfigurationService(Version version, Collection<QuarkusControllerConfiguration> configurations, KubernetesClient client, CRDGenerationInfo crdInfo, int maxThreads, int timeout, final ObjectMapper mapper, Metrics metrics) {
        super(version);
        this.client = client;
        this.cloner = new Cloner(){

            public <R extends HasMetadata> R clone(R r) {
                try {
                    return (R)((HasMetadata)mapper.readValue(mapper.writeValueAsString(r), r.getClass()));
                }
                catch (JsonProcessingException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
        this.metrics = metrics;
        if (configurations != null && !configurations.isEmpty()) {
            this.reconcilerClassToName = new HashMap<String, String>(configurations.size());
            configurations.forEach(c -> {
                this.reconcilerClassToName.put(c.getAssociatedReconcilerClassName(), c.getName());
                this.register((ControllerConfiguration)c);
            });
        } else {
            this.reconcilerClassToName = Collections.emptyMap();
        }
        this.crdInfo = crdInfo;
        this.concurrentReconciliationThreads = maxThreads;
        this.terminationTimeout = timeout;
    }

    public Config getClientConfiguration() {
        return this.client.getConfiguration();
    }

    public <R extends HasMetadata> QuarkusControllerConfiguration<R> getConfigurationFor(Reconciler<R> reconciler) {
        Reconciler<R> unwrapped = QuarkusConfigurationService.unwrap(reconciler);
        return (QuarkusControllerConfiguration)super.getConfigurationFor(unwrapped);
    }

    public boolean checkCRDAndValidateLocalModel() {
        return this.crdInfo.isValidateCRDs();
    }

    private static <R extends HasMetadata> Reconciler<R> unwrap(Reconciler<R> reconciler) {
        return (Reconciler)unwrapper.apply(reconciler);
    }

    protected String keyFor(Reconciler controller) {
        String controllerName;
        String controllerClass = controller.getClass().getName();
        int i = controllerClass.indexOf(95);
        if (i > 0) {
            controllerClass = controllerClass.substring(0, i);
        }
        if ((controllerName = this.reconcilerClassToName.get(controllerClass)) == null) {
            throw new IllegalArgumentException("Unknown controller " + controllerClass);
        }
        return controllerName;
    }

    public int concurrentReconciliationThreads() {
        return this.concurrentReconciliationThreads;
    }

    public Cloner getResourceCloner() {
        return this.cloner;
    }

    public int getTerminationTimeoutSeconds() {
        return this.terminationTimeout;
    }

    public CRDGenerationInfo getCRDGenerationInfo() {
        return this.crdInfo;
    }

    protected void logMissingReconcilerWarning(String reconcilerKey, String reconcilersNameMessage) {
        log.warn("Cannot find configuration for '{}' reconciler. {}", (Object)reconcilerKey, (Object)reconcilersNameMessage);
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    KubernetesClient getClient() {
        return this.client;
    }
}

