/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.MissingCRDException;
import io.javaoperatorsdk.operator.Operator;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo;
import io.quarkiverse.operatorsdk.runtime.QuarkusConfigurationService;
import io.quarkus.arc.DefaultBean;
import java.io.File;
import java.io.IOException;
import javax.annotation.PreDestroy;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.jboss.logging.Logger;

@Singleton
public class OperatorProducer {
    private static final YAMLMapper mapper = new YAMLMapper();
    private static final Logger log = Logger.getLogger((String)OperatorProducer.class.getName());
    private Operator operator;

    @Produces
    @DefaultBean
    @Singleton
    Operator operator(QuarkusConfigurationService configuration, Instance<Reconciler<? extends HasMetadata>> reconcilers) {
        this.operator = new Operator(configuration.getClient(), (ConfigurationService)configuration);
        for (Reconciler reconciler : reconcilers) {
            ControllerConfiguration config = configuration.getConfigurationFor(reconciler);
            if (config.isRegistrationDelayed()) continue;
            OperatorProducer.applyCRDIfNeededAndRegister(this.operator, (Reconciler<? extends HasMetadata>)reconciler, configuration);
        }
        return this.operator;
    }

    @PreDestroy
    public void destroy() {
        if (this.operator != null) {
            this.operator.stop();
        }
    }

    public static void applyCRDIfNeededAndRegister(Operator operator, Reconciler<? extends HasMetadata> reconciler, QuarkusConfigurationService configuration) {
        ControllerConfiguration config = configuration.getConfigurationFor((Reconciler)reconciler);
        CRDGenerationInfo crdInfo = configuration.getCRDGenerationInfo();
        if (crdInfo.isApplyCRDs()) {
            String crdName = config.getResourceTypeName();
            if (crdInfo.shouldApplyCRD(crdName)) {
                OperatorProducer.applyCRD(operator, crdInfo, crdName);
            }
            try {
                operator.register(reconciler);
            }
            catch (MissingCRDException e) {
                OperatorProducer.applyCRD(operator, crdInfo, crdName);
                operator.register(reconciler);
            }
        } else {
            operator.register(reconciler);
        }
    }

    private static void applyCRD(Operator operator, CRDGenerationInfo crdInfo, String crdName) {
        try {
            crdInfo.getCRDInfosFor(crdName).forEach((crdVersion, info) -> {
                String filePath = info.getFilePath();
                File crdFile = new File(filePath);
                try {
                    Object crd = mapper.readValue(crdFile, OperatorProducer.getCRDClassFor(crdVersion));
                    OperatorProducer.apply(operator.getKubernetesClient(), crdVersion, crd);
                    log.infov("Applied {0} CRD named ''{1}'' from {2}", crdVersion, (Object)crdName, (Object)filePath);
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("Couldn't read CRD file at " + filePath + " as a " + crdVersion + " CRD for " + crdName, ex);
                }
            });
        }
        catch (Exception exception) {
            log.debugv((Throwable)exception, "Couldn't apply ''{0}'' CRD", (Object)crdName);
        }
    }

    private static void apply(KubernetesClient client, String v, Object crd) {
        switch (v) {
            case "v1": {
                client.apiextensions().v1().customResourceDefinitions().createOrReplace((Object[])new io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition[]{(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition)crd});
                break;
            }
            case "v1beta1": {
                client.apiextensions().v1beta1().customResourceDefinitions().createOrReplace((Object[])new CustomResourceDefinition[]{(CustomResourceDefinition)crd});
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown CRD version: " + v);
            }
        }
    }

    private static Class<?> getCRDClassFor(String v) {
        switch (v) {
            case "v1": {
                return io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition.class;
            }
            case "v1beta1": {
                return CustomResourceDefinition.class;
            }
        }
        throw new IllegalArgumentException("Unknown CRD version: " + v);
    }
}

