/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.interceptor;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.spring.web.interceptor.HandlerInterceptorSpanDecorator;
import io.opentracing.contrib.web.servlet.filter.TracingFilter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class TracingHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final String SCOPE_STACK = TracingHandlerInterceptor.class.getName() + ".scopeStack";
    private static final String CONTINUATION_FROM_ASYNC_STARTED = TracingHandlerInterceptor.class.getName() + ".continuation";
    private static final String IS_ERROR_HANDLING_SPAN = TracingHandlerInterceptor.class.getName() + ".error_handling_span";
    private Tracer tracer;
    private List<HandlerInterceptorSpanDecorator> decorators;

    public TracingHandlerInterceptor(Tracer tracer) {
        this(tracer, Arrays.asList(HandlerInterceptorSpanDecorator.STANDARD_LOGS, HandlerInterceptorSpanDecorator.HANDLER_METHOD_OPERATION_NAME));
    }

    public TracingHandlerInterceptor(Tracer tracer, List<HandlerInterceptorSpanDecorator> decorators) {
        this.tracer = tracer;
        this.decorators = new ArrayList<HandlerInterceptorSpanDecorator>(decorators);
    }

    static boolean isTraced(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getAttribute(TracingFilter.SERVER_SPAN_CONTEXT) instanceof SpanContext;
    }

    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object handler) {
        Deque<Scope> activeSpanStack = this.getScopeStack(httpServletRequest);
        if (!TracingHandlerInterceptor.isTraced(httpServletRequest)) {
            return true;
        }
        Span serverSpan = this.tracer.activeSpan();
        if (serverSpan == null) {
            if (httpServletRequest.getAttribute(CONTINUATION_FROM_ASYNC_STARTED) != null) {
                serverSpan = (Span)httpServletRequest.getAttribute(CONTINUATION_FROM_ASYNC_STARTED);
                httpServletRequest.removeAttribute(CONTINUATION_FROM_ASYNC_STARTED);
                activeSpanStack.push(this.tracer.activateSpan(serverSpan));
            } else {
                serverSpan = this.tracer.buildSpan(httpServletRequest.getMethod()).addReference("follows_from", TracingFilter.serverSpanContext((ServletRequest)httpServletRequest)).start();
                httpServletRequest.setAttribute(IS_ERROR_HANDLING_SPAN, (Object)true);
                activeSpanStack.push(this.tracer.activateSpan(serverSpan));
            }
        }
        for (HandlerInterceptorSpanDecorator decorator : this.decorators) {
            decorator.onPreHandle(httpServletRequest, handler, serverSpan);
        }
        return true;
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object handler) {
        if (!TracingHandlerInterceptor.isTraced(httpServletRequest)) {
            return;
        }
        Span span = this.tracer.activeSpan();
        for (HandlerInterceptorSpanDecorator decorator : this.decorators) {
            decorator.onAfterConcurrentHandlingStarted(httpServletRequest, httpServletResponse, handler, span);
        }
        httpServletRequest.setAttribute(CONTINUATION_FROM_ASYNC_STARTED, (Object)span);
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object handler, Exception ex) {
        if (!TracingHandlerInterceptor.isTraced(httpServletRequest)) {
            return;
        }
        Span span = this.tracer.activeSpan();
        for (HandlerInterceptorSpanDecorator decorator : this.decorators) {
            decorator.onAfterCompletion(httpServletRequest, httpServletResponse, handler, ex, span);
        }
        Deque<Scope> scopeStack = this.getScopeStack(httpServletRequest);
        if (scopeStack.size() > 0) {
            Scope scope = scopeStack.pop();
            scope.close();
        }
        if (httpServletRequest.getAttribute(IS_ERROR_HANDLING_SPAN) != null) {
            httpServletRequest.removeAttribute(IS_ERROR_HANDLING_SPAN);
            span.finish();
        }
    }

    private Deque<Scope> getScopeStack(HttpServletRequest request) {
        ArrayDeque stack = (ArrayDeque)request.getAttribute(SCOPE_STACK);
        if (stack == null) {
            stack = new ArrayDeque();
            request.setAttribute(SCOPE_STACK, stack);
        }
        return stack;
    }
}

