/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.lettuce;

import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.api.async.RedisPubSubAsyncCommands;
import io.lettuce.core.pubsub.api.reactive.RedisPubSubReactiveCommands;
import io.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import io.opentracing.contrib.redis.common.TracingConfiguration;
import io.opentracing.contrib.redis.lettuce.TracingRedisPubSubAsyncCommands;
import io.opentracing.contrib.redis.lettuce.TracingRedisPubSubCommands;
import io.opentracing.contrib.redis.lettuce.TracingRedisPubSubListener;
import io.opentracing.contrib.redis.lettuce.TracingStatefulRedisConnection;

public class TracingStatefulRedisPubSubConnection<K, V>
extends TracingStatefulRedisConnection<K, V>
implements StatefulRedisPubSubConnection<K, V> {
    private final StatefulRedisPubSubConnection<K, V> connection;

    public TracingStatefulRedisPubSubConnection(StatefulRedisPubSubConnection<K, V> connection, TracingConfiguration tracingConfiguration) {
        super(connection, tracingConfiguration);
        this.connection = connection;
    }

    @Override
    public RedisPubSubCommands<K, V> sync() {
        return new TracingRedisPubSubCommands(this.connection.sync(), this.tracingConfiguration);
    }

    @Override
    public RedisPubSubAsyncCommands<K, V> async() {
        return new TracingRedisPubSubAsyncCommands(this.connection.async(), this.tracingConfiguration);
    }

    @Override
    public RedisPubSubReactiveCommands<K, V> reactive() {
        return this.connection.reactive();
    }

    public void addListener(RedisPubSubListener<K, V> listener) {
        this.connection.addListener(new TracingRedisPubSubListener<K, V>(listener, this.tracingConfiguration));
    }

    public void removeListener(RedisPubSubListener<K, V> listener) {
        this.connection.removeListener(listener);
    }
}

