/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.lettuce;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.api.reactive.RedisReactiveCommands;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.resource.ClientResources;
import io.opentracing.contrib.redis.common.TracingConfiguration;
import io.opentracing.contrib.redis.lettuce.TracingRedisAsyncCommands;
import io.opentracing.contrib.redis.lettuce.TracingRedisCommands;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class TracingStatefulRedisConnection<K, V>
implements StatefulRedisConnection<K, V> {
    private final StatefulRedisConnection<K, V> connection;
    final TracingConfiguration tracingConfiguration;

    public TracingStatefulRedisConnection(StatefulRedisConnection<K, V> connection, TracingConfiguration tracingConfiguration) {
        this.connection = connection;
        this.tracingConfiguration = tracingConfiguration;
    }

    public boolean isMulti() {
        return this.connection.isMulti();
    }

    public RedisCommands<K, V> sync() {
        return new TracingRedisCommands(this.connection.sync(), this.tracingConfiguration);
    }

    public RedisAsyncCommands<K, V> async() {
        return new TracingRedisAsyncCommands(this.connection.async(), this.tracingConfiguration);
    }

    public RedisReactiveCommands<K, V> reactive() {
        return this.connection.reactive();
    }

    public void setTimeout(Duration timeout) {
        this.connection.setTimeout(timeout);
    }

    @Deprecated
    public void setTimeout(long timeout, TimeUnit unit) {
        this.connection.setTimeout(timeout, unit);
    }

    public Duration getTimeout() {
        return this.connection.getTimeout();
    }

    public <T> RedisCommand<K, V, T> dispatch(RedisCommand<K, V, T> command) {
        return this.connection.dispatch(command);
    }

    public Collection<RedisCommand<K, V, ?>> dispatch(Collection<? extends RedisCommand<K, V, ?>> redisCommands) {
        return this.connection.dispatch(redisCommands);
    }

    public void close() {
        this.connection.close();
    }

    public CompletableFuture<Void> closeAsync() {
        return this.connection.closeAsync();
    }

    public boolean isOpen() {
        return this.connection.isOpen();
    }

    public ClientOptions getOptions() {
        return this.connection.getOptions();
    }

    public ClientResources getResources() {
        return this.connection.getResources();
    }

    public void reset() {
        this.connection.reset();
    }

    public void setAutoFlushCommands(boolean autoFlush) {
        this.connection.setAutoFlushCommands(autoFlush);
    }

    public void flushCommands() {
        this.connection.flushCommands();
    }
}

