/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.lettuce;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.async.RedisAdvancedClusterAsyncCommands;
import io.lettuce.core.cluster.api.reactive.RedisAdvancedClusterReactiveCommands;
import io.lettuce.core.cluster.api.sync.RedisAdvancedClusterCommands;
import io.lettuce.core.cluster.models.partitions.Partitions;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.resource.ClientResources;
import io.opentracing.contrib.redis.common.TracingConfiguration;
import io.opentracing.contrib.redis.lettuce.TracingRedisAdvancedClusterAsyncCommands;
import io.opentracing.contrib.redis.lettuce.TracingRedisAdvancedClusterCommands;
import io.opentracing.contrib.redis.lettuce.TracingStatefulRedisConnection;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class TracingStatefulRedisClusterConnection<K, V>
implements StatefulRedisClusterConnection<K, V> {
    private final StatefulRedisClusterConnection<K, V> connection;
    private final TracingConfiguration tracingConfiguration;

    public TracingStatefulRedisClusterConnection(StatefulRedisClusterConnection<K, V> connection, TracingConfiguration tracingConfiguration) {
        this.connection = connection;
        this.tracingConfiguration = tracingConfiguration;
    }

    public RedisAdvancedClusterCommands<K, V> sync() {
        return new TracingRedisAdvancedClusterCommands(this.connection.sync(), this.tracingConfiguration);
    }

    public RedisAdvancedClusterAsyncCommands<K, V> async() {
        return new TracingRedisAdvancedClusterAsyncCommands(this.connection.async(), this.tracingConfiguration);
    }

    public RedisAdvancedClusterReactiveCommands<K, V> reactive() {
        return this.connection.reactive();
    }

    public StatefulRedisConnection<K, V> getConnection(String s) {
        return new TracingStatefulRedisConnection(this.connection.getConnection(s), this.tracingConfiguration);
    }

    public CompletableFuture<StatefulRedisConnection<K, V>> getConnectionAsync(String s) {
        return CompletableFuture.supplyAsync(() -> new TracingStatefulRedisConnection(this.connection.getConnection(s), this.tracingConfiguration));
    }

    public StatefulRedisConnection<K, V> getConnection(String s, int i) {
        return new TracingStatefulRedisConnection(this.connection.getConnection(s, i), this.tracingConfiguration);
    }

    public CompletableFuture<StatefulRedisConnection<K, V>> getConnectionAsync(String s, int i) {
        return CompletableFuture.supplyAsync(() -> new TracingStatefulRedisConnection(this.connection.getConnection(s, i), this.tracingConfiguration));
    }

    public void setReadFrom(ReadFrom readFrom) {
        this.connection.setReadFrom(readFrom);
    }

    public ReadFrom getReadFrom() {
        return this.connection.getReadFrom();
    }

    public Partitions getPartitions() {
        return this.connection.getPartitions();
    }

    public void setTimeout(Duration duration) {
        this.connection.setTimeout(duration);
    }

    public void setTimeout(long l, TimeUnit timeUnit) {
        this.connection.setTimeout(l, timeUnit);
    }

    public Duration getTimeout() {
        return this.connection.getTimeout();
    }

    public <T> RedisCommand<K, V, T> dispatch(RedisCommand<K, V, T> redisCommand) {
        return this.connection.dispatch(redisCommand);
    }

    public Collection<RedisCommand<K, V, ?>> dispatch(Collection<? extends RedisCommand<K, V, ?>> collection) {
        return this.connection.dispatch(collection);
    }

    public void close() {
        this.connection.close();
    }

    public CompletableFuture<Void> closeAsync() {
        return this.connection.closeAsync();
    }

    public boolean isOpen() {
        return this.connection.isOpen();
    }

    public ClientOptions getOptions() {
        return this.connection.getOptions();
    }

    public ClientResources getResources() {
        return this.connection.getResources();
    }

    public void reset() {
        this.connection.reset();
    }

    public void setAutoFlushCommands(boolean b) {
        this.connection.setAutoFlushCommands(b);
    }

    public void flushCommands() {
        this.connection.flushCommands();
    }
}

