/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.lettuce;

import io.lettuce.core.pubsub.RedisPubSubListener;
import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingConfiguration;
import io.opentracing.contrib.redis.common.TracingHelper;

public class TracingRedisPubSubListener<K, V>
implements RedisPubSubListener<K, V> {
    private final RedisPubSubListener<K, V> listener;
    private final TracingHelper helper;

    public TracingRedisPubSubListener(RedisPubSubListener<K, V> listener, TracingConfiguration tracingConfiguration) {
        this.listener = listener;
        this.helper = new TracingHelper(tracingConfiguration);
    }

    public void message(K channel, V message) {
        Span span = this.helper.buildSpan("message");
        span.setTag("channel", TracingHelper.nullable(channel));
        span.setTag("message", TracingHelper.nullable(message));
        this.helper.decorate(span, () -> this.listener.message(channel, message));
    }

    public void message(K pattern, K channel, V message) {
        Span span = this.helper.buildSpan("message");
        span.setTag("pattern", TracingHelper.nullable(pattern));
        span.setTag("channel", TracingHelper.nullable(channel));
        span.setTag("message", TracingHelper.nullable(message));
        this.helper.decorate(span, () -> this.listener.message(pattern, channel, message));
    }

    public void subscribed(K channel, long count) {
        Span span = this.helper.buildSpan("subscribed");
        span.setTag("channel", TracingHelper.nullable(channel));
        span.setTag("count", (Number)count);
        this.helper.decorate(span, () -> this.listener.subscribed(channel, count));
    }

    public void psubscribed(K pattern, long count) {
        Span span = this.helper.buildSpan("psubscribed");
        span.setTag("pattern", TracingHelper.nullable(pattern));
        span.setTag("count", (Number)count);
        this.helper.decorate(span, () -> this.listener.psubscribed(pattern, count));
    }

    public void unsubscribed(K channel, long count) {
        Span span = this.helper.buildSpan("unsubscribed");
        span.setTag("channel", TracingHelper.nullable(channel));
        span.setTag("count", (Number)count);
        this.helper.decorate(span, () -> this.listener.unsubscribed(channel, count));
    }

    public void punsubscribed(K pattern, long count) {
        Span span = this.helper.buildSpan("punsubscribed");
        span.setTag("pattern", TracingHelper.nullable(pattern));
        span.setTag("count", (Number)count);
        this.helper.decorate(span, () -> this.listener.punsubscribed(pattern, count));
    }

    public boolean equals(Object obj) {
        return this.listener.equals(obj);
    }

    public int hashCode() {
        return this.listener.hashCode();
    }
}

