/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.lettuce;

import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingConfiguration;
import io.opentracing.contrib.redis.lettuce.TracingRedisCommands;
import io.opentracing.contrib.redis.lettuce.TracingStatefulRedisPubSubConnection;
import java.util.Arrays;

public class TracingRedisPubSubCommands<K, V>
extends TracingRedisCommands<K, V>
implements RedisPubSubCommands<K, V> {
    private final RedisPubSubCommands<K, V> commands;

    public TracingRedisPubSubCommands(RedisPubSubCommands<K, V> commands, TracingConfiguration tracingConfiguration) {
        super(commands, tracingConfiguration);
        this.commands = commands;
    }

    public void psubscribe(K ... patterns) {
        Span span = this.helper.buildSpan("psubscribe");
        span.setTag("patterns", Arrays.toString(patterns));
        this.helper.decorate(span, () -> this.commands.psubscribe(patterns));
    }

    public void punsubscribe(K ... patterns) {
        Span span = this.helper.buildSpan("punsubscribe");
        span.setTag("patterns", Arrays.toString(patterns));
        this.helper.decorate(span, () -> this.commands.punsubscribe(patterns));
    }

    public void subscribe(K ... channels) {
        Span span = this.helper.buildSpan("subscribe");
        span.setTag("channels", Arrays.toString(channels));
        this.helper.decorate(span, () -> this.commands.subscribe(channels));
    }

    public void unsubscribe(K ... channels) {
        Span span = this.helper.buildSpan("unsubscribe");
        span.setTag("channels", Arrays.toString(channels));
        this.helper.decorate(span, () -> this.commands.unsubscribe(channels));
    }

    @Override
    public StatefulRedisPubSubConnection<K, V> getStatefulConnection() {
        return new TracingStatefulRedisPubSubConnection(this.commands.getStatefulConnection(), this.tracingConfiguration);
    }
}

