/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.lettuce;

import io.lettuce.core.RedisFuture;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.api.async.RedisPubSubAsyncCommands;
import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingConfiguration;
import io.opentracing.contrib.redis.lettuce.TracingRedisAsyncCommands;
import io.opentracing.contrib.redis.lettuce.TracingStatefulRedisPubSubConnection;
import java.util.Arrays;

public class TracingRedisPubSubAsyncCommands<K, V>
extends TracingRedisAsyncCommands<K, V>
implements RedisPubSubAsyncCommands<K, V> {
    private final RedisPubSubAsyncCommands<K, V> commands;

    public TracingRedisPubSubAsyncCommands(RedisPubSubAsyncCommands<K, V> commands, TracingConfiguration tracingConfiguration) {
        super(commands, tracingConfiguration);
        this.commands = commands;
    }

    public RedisFuture<Void> psubscribe(K ... patterns) {
        Span span = this.helper.buildSpan("psubscribe");
        span.setTag("patterns", Arrays.toString(patterns));
        return this.prepareRedisFuture(this.commands.psubscribe((Object[])patterns), span);
    }

    public RedisFuture<Void> punsubscribe(K ... patterns) {
        Span span = this.helper.buildSpan("punsubscribe");
        span.setTag("patterns", Arrays.toString(patterns));
        return this.prepareRedisFuture(this.commands.punsubscribe((Object[])patterns), span);
    }

    public RedisFuture<Void> subscribe(K ... channels) {
        Span span = this.helper.buildSpan("subscribe");
        span.setTag("channels", Arrays.toString(channels));
        return this.prepareRedisFuture(this.commands.subscribe((Object[])channels), span);
    }

    public RedisFuture<Void> unsubscribe(K ... channels) {
        Span span = this.helper.buildSpan("unsubscribe");
        span.setTag("channels", Arrays.toString(channels));
        return this.prepareRedisFuture(this.commands.unsubscribe((Object[])channels), span);
    }

    @Override
    public StatefulRedisPubSubConnection<K, V> getStatefulConnection() {
        return new TracingStatefulRedisPubSubConnection(this.commands.getStatefulConnection(), this.tracingConfiguration);
    }
}

