/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.lettuce;

import io.lettuce.core.BitFieldArgs;
import io.lettuce.core.Consumer;
import io.lettuce.core.GeoArgs;
import io.lettuce.core.GeoCoordinates;
import io.lettuce.core.GeoRadiusStoreArgs;
import io.lettuce.core.GeoWithin;
import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.KeyValue;
import io.lettuce.core.KillArgs;
import io.lettuce.core.Limit;
import io.lettuce.core.MapScanCursor;
import io.lettuce.core.MigrateArgs;
import io.lettuce.core.Range;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.RestoreArgs;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.ScoredValueScanCursor;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.SetArgs;
import io.lettuce.core.SortArgs;
import io.lettuce.core.StreamMessage;
import io.lettuce.core.StreamScanCursor;
import io.lettuce.core.TransactionResult;
import io.lettuce.core.UnblockType;
import io.lettuce.core.Value;
import io.lettuce.core.ValueScanCursor;
import io.lettuce.core.XAddArgs;
import io.lettuce.core.XClaimArgs;
import io.lettuce.core.XReadArgs;
import io.lettuce.core.ZAddArgs;
import io.lettuce.core.ZStoreArgs;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.KeyStreamingChannel;
import io.lettuce.core.output.KeyValueStreamingChannel;
import io.lettuce.core.output.ScoredValueStreamingChannel;
import io.lettuce.core.output.ValueStreamingChannel;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.ProtocolKeyword;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.redis.common.TracingConfiguration;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.lettuce.CompletableRedisFuture;
import io.opentracing.contrib.redis.lettuce.TracingStatefulRedisConnection;
import java.time.Duration;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class TracingRedisAsyncCommands<K, V>
implements RedisAsyncCommands<K, V> {
    private final RedisAsyncCommands<K, V> commands;
    final TracingHelper helper;
    final TracingConfiguration tracingConfiguration;

    public TracingRedisAsyncCommands(RedisAsyncCommands<K, V> commands, TracingConfiguration tracingConfiguration) {
        this.commands = commands;
        this.tracingConfiguration = tracingConfiguration;
        this.helper = new TracingHelper(tracingConfiguration);
    }

    public String auth(String password) {
        Span span = this.helper.buildSpan("auth");
        try {
            String string = this.commands.auth(password);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public String select(int db) {
        Span span = this.helper.buildSpan("select");
        span.setTag("db", (Number)db);
        try {
            String string = this.commands.select(db);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public RedisFuture<String> swapdb(int db1, int db2) {
        Span span = this.helper.buildSpan("swapdb");
        span.setTag("db1", (Number)db1);
        span.setTag("db2", (Number)db2);
        return this.prepareRedisFuture(this.commands.swapdb(db1, db2), span);
    }

    public StatefulRedisConnection<K, V> getStatefulConnection() {
        return new TracingStatefulRedisConnection(this.commands.getStatefulConnection(), this.tracingConfiguration);
    }

    public RedisFuture<Long> hdel(K key, K ... fields) {
        Span span = this.helper.buildSpan("hdel", key);
        return this.prepareRedisFuture(this.commands.hdel(key, (Object[])fields), span);
    }

    public RedisFuture<Boolean> hexists(K key, K field) {
        Span span = this.helper.buildSpan("hexists", key);
        return this.prepareRedisFuture(this.commands.hexists(key, field), span);
    }

    public RedisFuture<V> hget(K key, K field) {
        Span span = this.helper.buildSpan("hget", key);
        return this.prepareRedisFuture(this.commands.hget(key, field), span);
    }

    public RedisFuture<Long> hincrby(K key, K field, long amount) {
        Span span = this.helper.buildSpan("hincrby", key);
        span.setTag("amount", (Number)amount);
        return this.prepareRedisFuture(this.commands.hincrby(key, field, amount), span);
    }

    public RedisFuture<Double> hincrbyfloat(K key, K field, double amount) {
        Span span = this.helper.buildSpan("hincrbyfloat", key);
        span.setTag("amount", (Number)amount);
        return this.prepareRedisFuture(this.commands.hincrbyfloat(key, field, amount), span);
    }

    public RedisFuture<Map<K, V>> hgetall(K key) {
        Span span = this.helper.buildSpan("hgetall", key);
        return this.prepareRedisFuture(this.commands.hgetall(key), span);
    }

    public RedisFuture<Long> hgetall(KeyValueStreamingChannel<K, V> channel, K key) {
        Span span = this.helper.buildSpan("hgetall", key);
        return this.prepareRedisFuture(this.commands.hgetall(channel, key), span);
    }

    public RedisFuture<List<K>> hkeys(K key) {
        Span span = this.helper.buildSpan("hkeys", key);
        return this.prepareRedisFuture(this.commands.hkeys(key), span);
    }

    public RedisFuture<Long> hkeys(KeyStreamingChannel<K> channel, K key) {
        Span span = this.helper.buildSpan("hkeys", key);
        return this.prepareRedisFuture(this.commands.hkeys(channel, key), span);
    }

    public RedisFuture<Long> hlen(K key) {
        Span span = this.helper.buildSpan("hlen", key);
        return this.prepareRedisFuture(this.commands.hlen(key), span);
    }

    public RedisFuture<List<KeyValue<K, V>>> hmget(K key, K ... fields) {
        Span span = this.helper.buildSpan("hmget", key);
        return this.prepareRedisFuture(this.commands.hmget(key, (Object[])fields), span);
    }

    public RedisFuture<Long> hmget(KeyValueStreamingChannel<K, V> channel, K key, K ... fields) {
        Span span = this.helper.buildSpan("hmget", key);
        return this.prepareRedisFuture(this.commands.hmget(channel, key, (Object[])fields), span);
    }

    public RedisFuture<String> hmset(K key, Map<K, V> map) {
        Span span = this.helper.buildSpan("hmset", key);
        return this.prepareRedisFuture(this.commands.hmset(key, map), span);
    }

    public RedisFuture<MapScanCursor<K, V>> hscan(K key) {
        Span span = this.helper.buildSpan("hscan", key);
        return this.prepareRedisFuture(this.commands.hscan(key), span);
    }

    public RedisFuture<MapScanCursor<K, V>> hscan(K key, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("hscan", key);
        return this.prepareRedisFuture(this.commands.hscan(key, scanArgs), span);
    }

    public RedisFuture<MapScanCursor<K, V>> hscan(K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("hscan", key);
        return this.prepareRedisFuture(this.commands.hscan(key, scanCursor, scanArgs), span);
    }

    public RedisFuture<MapScanCursor<K, V>> hscan(K key, ScanCursor scanCursor) {
        Span span = this.helper.buildSpan("hscan", key);
        return this.prepareRedisFuture(this.commands.hscan(key, scanCursor), span);
    }

    public RedisFuture<StreamScanCursor> hscan(KeyValueStreamingChannel<K, V> channel, K key) {
        Span span = this.helper.buildSpan("hscan", key);
        return this.prepareRedisFuture(this.commands.hscan(channel, key), span);
    }

    public RedisFuture<StreamScanCursor> hscan(KeyValueStreamingChannel<K, V> channel, K key, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("hscan", key);
        return this.prepareRedisFuture(this.commands.hscan(channel, key, scanArgs), span);
    }

    public RedisFuture<StreamScanCursor> hscan(KeyValueStreamingChannel<K, V> channel, K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("hscan", key);
        return this.prepareRedisFuture(this.commands.hscan(channel, key, scanCursor, scanArgs), span);
    }

    public RedisFuture<StreamScanCursor> hscan(KeyValueStreamingChannel<K, V> channel, K key, ScanCursor scanCursor) {
        Span span = this.helper.buildSpan("hscan", key);
        return this.prepareRedisFuture(this.commands.hscan(channel, key, scanCursor), span);
    }

    public RedisFuture<Boolean> hset(K key, K field, V value) {
        Span span = this.helper.buildSpan("hset", key);
        return this.prepareRedisFuture(this.commands.hset(key, field, value), span);
    }

    public RedisFuture<Boolean> hsetnx(K key, K field, V value) {
        Span span = this.helper.buildSpan("hsetnx", key);
        return this.prepareRedisFuture(this.commands.hsetnx(key, field, value), span);
    }

    public RedisFuture<Long> hstrlen(K key, K field) {
        Span span = this.helper.buildSpan("hstrlen", key);
        return this.prepareRedisFuture(this.commands.hstrlen(key, field), span);
    }

    public RedisFuture<List<V>> hvals(K key) {
        Span span = this.helper.buildSpan("hvals", key);
        return this.prepareRedisFuture(this.commands.hvals(key), span);
    }

    public RedisFuture<Long> hvals(ValueStreamingChannel<V> channel, K key) {
        Span span = this.helper.buildSpan("hvals", key);
        return this.prepareRedisFuture(this.commands.hvals(channel, key), span);
    }

    public RedisFuture<Long> del(K ... keys) {
        Span span = this.helper.buildSpan("del", (Object[])keys);
        return this.prepareRedisFuture(this.commands.del((Object[])keys), span);
    }

    public RedisFuture<Long> unlink(K ... keys) {
        Span span = this.helper.buildSpan("unlink", (Object[])keys);
        return this.prepareRedisFuture(this.commands.unlink((Object[])keys), span);
    }

    public RedisFuture<byte[]> dump(K key) {
        Span span = this.helper.buildSpan("dump", key);
        return this.prepareRedisFuture(this.commands.dump(key), span);
    }

    public RedisFuture<Long> exists(K ... keys) {
        Span span = this.helper.buildSpan("exists", (Object[])keys);
        return this.prepareRedisFuture(this.commands.exists((Object[])keys), span);
    }

    public RedisFuture<Boolean> expire(K key, long seconds) {
        Span span = this.helper.buildSpan("expire", key);
        span.setTag("seconds", (Number)seconds);
        return this.prepareRedisFuture(this.commands.expire(key, seconds), span);
    }

    public RedisFuture<Boolean> expireat(K key, Date timestamp) {
        Span span = this.helper.buildSpan("expireat", key);
        span.setTag("timestamp", TracingHelper.nullable((Object)timestamp));
        return this.prepareRedisFuture(this.commands.expireat(key, timestamp), span);
    }

    public RedisFuture<Boolean> expireat(K key, long timestamp) {
        Span span = this.helper.buildSpan("expireat", key);
        span.setTag("timestamp", (Number)timestamp);
        return this.prepareRedisFuture(this.commands.expireat(key, timestamp), span);
    }

    public RedisFuture<List<K>> keys(K pattern) {
        Span span = this.helper.buildSpan("keys");
        return this.prepareRedisFuture(this.commands.keys(pattern), span);
    }

    public RedisFuture<Long> keys(KeyStreamingChannel<K> channel, K pattern) {
        Span span = this.helper.buildSpan("keys");
        return this.prepareRedisFuture(this.commands.keys(channel, pattern), span);
    }

    public RedisFuture<String> migrate(String host, int port, K key, int db, long timeout) {
        Span span = this.helper.buildSpan("migrate", key);
        span.setTag("host", host);
        span.setTag("port", (Number)port);
        span.setTag("db", (Number)db);
        span.setTag("timeout", (Number)timeout);
        return this.prepareRedisFuture(this.commands.migrate(host, port, key, db, timeout), span);
    }

    public RedisFuture<String> migrate(String host, int port, int db, long timeout, MigrateArgs<K> migrateArgs) {
        Span span = this.helper.buildSpan("migrate");
        span.setTag("host", host);
        span.setTag("port", (Number)port);
        span.setTag("db", (Number)db);
        span.setTag("timeout", (Number)timeout);
        return this.prepareRedisFuture(this.commands.migrate(host, port, db, timeout, migrateArgs), span);
    }

    public RedisFuture<Boolean> move(K key, int db) {
        Span span = this.helper.buildSpan("move", key);
        span.setTag("db", (Number)db);
        return this.prepareRedisFuture(this.commands.move(key, db), span);
    }

    public RedisFuture<String> objectEncoding(K key) {
        Span span = this.helper.buildSpan("objectEncoding", key);
        return this.prepareRedisFuture(this.commands.objectEncoding(key), span);
    }

    public RedisFuture<Long> objectIdletime(K key) {
        Span span = this.helper.buildSpan("objectIdletime", key);
        return this.prepareRedisFuture(this.commands.objectIdletime(key), span);
    }

    public RedisFuture<Long> objectRefcount(K key) {
        Span span = this.helper.buildSpan("objectRefcount", key);
        return this.prepareRedisFuture(this.commands.objectRefcount(key), span);
    }

    public RedisFuture<Boolean> persist(K key) {
        Span span = this.helper.buildSpan("persist", key);
        return this.prepareRedisFuture(this.commands.persist(key), span);
    }

    public RedisFuture<Boolean> pexpire(K key, long milliseconds) {
        Span span = this.helper.buildSpan("pexpire", key);
        span.setTag("milliseconds", (Number)milliseconds);
        return this.prepareRedisFuture(this.commands.pexpire(key, milliseconds), span);
    }

    public RedisFuture<Boolean> pexpireat(K key, Date timestamp) {
        Span span = this.helper.buildSpan("pexpireat", key);
        span.setTag("timestamp", TracingHelper.nullable((Object)timestamp));
        return this.prepareRedisFuture(this.commands.pexpireat(key, timestamp), span);
    }

    public RedisFuture<Boolean> pexpireat(K key, long timestamp) {
        Span span = this.helper.buildSpan("pexpireat", key);
        span.setTag("timestamp", (Number)timestamp);
        return this.prepareRedisFuture(this.commands.pexpireat(key, timestamp), span);
    }

    public RedisFuture<Long> pttl(K key) {
        Span span = this.helper.buildSpan("pttl", key);
        return this.prepareRedisFuture(this.commands.pttl(key), span);
    }

    public RedisFuture<V> randomkey() {
        Span span = this.helper.buildSpan("randomkey");
        return this.prepareRedisFuture(this.commands.randomkey(), span);
    }

    public RedisFuture<String> rename(K key, K newKey) {
        Span span = this.helper.buildSpan("rename", key);
        return this.prepareRedisFuture(this.commands.rename(key, newKey), span);
    }

    public RedisFuture<Boolean> renamenx(K key, K newKey) {
        Span span = this.helper.buildSpan("renamenx", key);
        return this.prepareRedisFuture(this.commands.renamenx(key, newKey), span);
    }

    public RedisFuture<String> restore(K key, long ttl, byte[] value) {
        Span span = this.helper.buildSpan("restore", key);
        span.setTag("ttl", (Number)ttl);
        return this.prepareRedisFuture(this.commands.restore(key, ttl, value), span);
    }

    public RedisFuture<String> restore(K key, byte[] value, RestoreArgs args) {
        Span span = this.helper.buildSpan("restore", key);
        span.setTag("value", Arrays.toString(value));
        return this.prepareRedisFuture(this.commands.restore(key, value, args), span);
    }

    public RedisFuture<List<V>> sort(K key) {
        Span span = this.helper.buildSpan("sort", key);
        return this.prepareRedisFuture(this.commands.sort(key), span);
    }

    public RedisFuture<Long> sort(ValueStreamingChannel<V> channel, K key) {
        Span span = this.helper.buildSpan("sort", key);
        return this.prepareRedisFuture(this.commands.sort(channel, key), span);
    }

    public RedisFuture<List<V>> sort(K key, SortArgs sortArgs) {
        Span span = this.helper.buildSpan("sort", key);
        return this.prepareRedisFuture(this.commands.sort(key, sortArgs), span);
    }

    public RedisFuture<Long> sort(ValueStreamingChannel<V> channel, K key, SortArgs sortArgs) {
        Span span = this.helper.buildSpan("sort", key);
        return this.prepareRedisFuture(this.commands.sort(channel, key, sortArgs), span);
    }

    public RedisFuture<Long> sortStore(K key, SortArgs sortArgs, K destination) {
        Span span = this.helper.buildSpan("sortStore", key);
        return this.prepareRedisFuture(this.commands.sortStore(key, sortArgs, destination), span);
    }

    public RedisFuture<Long> touch(K ... keys) {
        Span span = this.helper.buildSpan("touch", (Object[])keys);
        return this.prepareRedisFuture(this.commands.touch((Object[])keys), span);
    }

    public RedisFuture<Long> ttl(K key) {
        Span span = this.helper.buildSpan("ttl", key);
        return this.prepareRedisFuture(this.commands.ttl(key), span);
    }

    public RedisFuture<String> type(K key) {
        Span span = this.helper.buildSpan("type", key);
        return this.prepareRedisFuture(this.commands.type(key), span);
    }

    public RedisFuture<KeyScanCursor<K>> scan() {
        Span span = this.helper.buildSpan("scan");
        return this.prepareRedisFuture(this.commands.scan(), span);
    }

    public RedisFuture<KeyScanCursor<K>> scan(ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("scan");
        return this.prepareRedisFuture(this.commands.scan(scanArgs), span);
    }

    public RedisFuture<KeyScanCursor<K>> scan(ScanCursor scanCursor, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("scan");
        return this.prepareRedisFuture(this.commands.scan(scanCursor, scanArgs), span);
    }

    public RedisFuture<KeyScanCursor<K>> scan(ScanCursor scanCursor) {
        Span span = this.helper.buildSpan("scan");
        return this.prepareRedisFuture(this.commands.scan(scanCursor), span);
    }

    public RedisFuture<StreamScanCursor> scan(KeyStreamingChannel<K> channel) {
        Span span = this.helper.buildSpan("scan");
        return this.prepareRedisFuture(this.commands.scan(channel), span);
    }

    public RedisFuture<StreamScanCursor> scan(KeyStreamingChannel<K> channel, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("scan");
        return this.prepareRedisFuture(this.commands.scan(channel, scanArgs), span);
    }

    public RedisFuture<StreamScanCursor> scan(KeyStreamingChannel<K> channel, ScanCursor scanCursor, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("scan");
        return this.prepareRedisFuture(this.commands.scan(channel, scanCursor, scanArgs), span);
    }

    public RedisFuture<StreamScanCursor> scan(KeyStreamingChannel<K> channel, ScanCursor scanCursor) {
        Span span = this.helper.buildSpan("scan");
        return this.prepareRedisFuture(this.commands.scan(channel, scanCursor), span);
    }

    public RedisFuture<Long> append(K key, V value) {
        Span span = this.helper.buildSpan("append", key);
        return this.prepareRedisFuture(this.commands.append(key, value), span);
    }

    public RedisFuture<Long> bitcount(K key) {
        Span span = this.helper.buildSpan("bitcount", key);
        return this.prepareRedisFuture(this.commands.bitcount(key), span);
    }

    public RedisFuture<Long> bitcount(K key, long start, long end) {
        Span span = this.helper.buildSpan("bitcount", key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        return this.prepareRedisFuture(this.commands.bitcount(key, start, end), span);
    }

    public RedisFuture<List<Long>> bitfield(K key, BitFieldArgs bitFieldArgs) {
        Span span = this.helper.buildSpan("bitfield", key);
        return this.prepareRedisFuture(this.commands.bitfield(key, bitFieldArgs), span);
    }

    public RedisFuture<Long> bitpos(K key, boolean state) {
        Span span = this.helper.buildSpan("bitpos", key);
        span.setTag("state", state);
        return this.prepareRedisFuture(this.commands.bitpos(key, state), span);
    }

    public RedisFuture<Long> bitpos(K key, boolean state, long start) {
        Span span = this.helper.buildSpan("bitpos", key);
        span.setTag("state", state);
        span.setTag("start", (Number)start);
        return this.prepareRedisFuture(this.commands.bitpos(key, state, start), span);
    }

    public RedisFuture<Long> bitpos(K key, boolean state, long start, long end) {
        Span span = this.helper.buildSpan("bitpos", key);
        span.setTag("state", state);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        return this.prepareRedisFuture(this.commands.bitpos(key, state, start, end), span);
    }

    public RedisFuture<Long> bitopAnd(K destination, K ... keys) {
        Span span = this.helper.buildSpan("bitopAnd", (Object[])keys);
        return this.prepareRedisFuture(this.commands.bitopAnd(destination, (Object[])keys), span);
    }

    public RedisFuture<Long> bitopNot(K destination, K source) {
        Span span = this.helper.buildSpan("bitopNot");
        return this.prepareRedisFuture(this.commands.bitopNot(destination, source), span);
    }

    public RedisFuture<Long> bitopOr(K destination, K ... keys) {
        Span span = this.helper.buildSpan("bitopOr", (Object[])keys);
        return this.prepareRedisFuture(this.commands.bitopOr(destination, (Object[])keys), span);
    }

    public RedisFuture<Long> bitopXor(K destination, K ... keys) {
        Span span = this.helper.buildSpan("bitopXor", (Object[])keys);
        return this.prepareRedisFuture(this.commands.bitopXor(destination, (Object[])keys), span);
    }

    public RedisFuture<Long> decr(K key) {
        Span span = this.helper.buildSpan("decr", key);
        return this.prepareRedisFuture(this.commands.decr(key), span);
    }

    public RedisFuture<Long> decrby(K key, long amount) {
        Span span = this.helper.buildSpan("decrby", key);
        span.setTag("amount", (Number)amount);
        return this.prepareRedisFuture(this.commands.decrby(key, amount), span);
    }

    public RedisFuture<V> get(K key) {
        Span span = this.helper.buildSpan("get", key);
        return this.prepareRedisFuture(this.commands.get(key), span);
    }

    public RedisFuture<Long> getbit(K key, long offset) {
        Span span = this.helper.buildSpan("getbit", key);
        span.setTag("offset", (Number)offset);
        return this.prepareRedisFuture(this.commands.getbit(key, offset), span);
    }

    public RedisFuture<V> getrange(K key, long start, long end) {
        Span span = this.helper.buildSpan("getrange", key);
        span.setTag("start", (Number)start);
        span.setTag("end", (Number)end);
        return this.prepareRedisFuture(this.commands.getrange(key, start, end), span);
    }

    public RedisFuture<V> getset(K key, V value) {
        Span span = this.helper.buildSpan("getset", key);
        return this.prepareRedisFuture(this.commands.getset(key, value), span);
    }

    public RedisFuture<Long> incr(K key) {
        Span span = this.helper.buildSpan("incr", key);
        return this.prepareRedisFuture(this.commands.incr(key), span);
    }

    public RedisFuture<Long> incrby(K key, long amount) {
        Span span = this.helper.buildSpan("incrby", key);
        span.setTag("amount", (Number)amount);
        return this.prepareRedisFuture(this.commands.incrby(key, amount), span);
    }

    public RedisFuture<Double> incrbyfloat(K key, double amount) {
        Span span = this.helper.buildSpan("incrbyfloat", key);
        span.setTag("amount", (Number)amount);
        return this.prepareRedisFuture(this.commands.incrbyfloat(key, amount), span);
    }

    public RedisFuture<List<KeyValue<K, V>>> mget(K ... keys) {
        Span span = this.helper.buildSpan("mget", (Object[])keys);
        return this.prepareRedisFuture(this.commands.mget((Object[])keys), span);
    }

    public RedisFuture<Long> mget(KeyValueStreamingChannel<K, V> channel, K ... keys) {
        Span span = this.helper.buildSpan("mget", (Object[])keys);
        return this.prepareRedisFuture(this.commands.mget(channel, (Object[])keys), span);
    }

    public RedisFuture<String> mset(Map<K, V> map) {
        Span span = this.helper.buildSpan("mset");
        return this.prepareRedisFuture(this.commands.mset(map), span);
    }

    public RedisFuture<Boolean> msetnx(Map<K, V> map) {
        Span span = this.helper.buildSpan("msetnx");
        return this.prepareRedisFuture(this.commands.msetnx(map), span);
    }

    public RedisFuture<String> set(K key, V value) {
        Span span = this.helper.buildSpan("set", key);
        return this.prepareRedisFuture(this.commands.set(key, value), span);
    }

    public RedisFuture<String> set(K key, V value, SetArgs setArgs) {
        Span span = this.helper.buildSpan("set", key);
        return this.prepareRedisFuture(this.commands.set(key, value, setArgs), span);
    }

    public RedisFuture<Long> setbit(K key, long offset, int value) {
        Span span = this.helper.buildSpan("setbit", key);
        span.setTag("offset", (Number)offset);
        span.setTag("value", (Number)value);
        return this.prepareRedisFuture(this.commands.setbit(key, offset, value), span);
    }

    public RedisFuture<String> setex(K key, long seconds, V value) {
        Span span = this.helper.buildSpan("setex", key);
        span.setTag("seconds", (Number)seconds);
        return this.prepareRedisFuture(this.commands.setex(key, seconds, value), span);
    }

    public RedisFuture<String> psetex(K key, long milliseconds, V value) {
        Span span = this.helper.buildSpan("psetex", key);
        span.setTag("milliseconds", (Number)milliseconds);
        return this.prepareRedisFuture(this.commands.psetex(key, milliseconds, value), span);
    }

    public RedisFuture<Boolean> setnx(K key, V value) {
        Span span = this.helper.buildSpan("setnx", key);
        return this.prepareRedisFuture(this.commands.setnx(key, value), span);
    }

    public RedisFuture<Long> setrange(K key, long offset, V value) {
        Span span = this.helper.buildSpan("setrange", key);
        span.setTag("offset", (Number)offset);
        return this.prepareRedisFuture(this.commands.setrange(key, offset, value), span);
    }

    public RedisFuture<Long> strlen(K key) {
        Span span = this.helper.buildSpan("strlen", key);
        return this.prepareRedisFuture(this.commands.strlen(key), span);
    }

    public RedisFuture<KeyValue<K, V>> blpop(long timeout, K ... keys) {
        Span span = this.helper.buildSpan("blpop", (Object[])keys);
        span.setTag("timeout", (Number)timeout);
        return this.prepareRedisFuture(this.commands.blpop(timeout, (Object[])keys), span);
    }

    public RedisFuture<KeyValue<K, V>> brpop(long timeout, K ... keys) {
        Span span = this.helper.buildSpan("brpop", (Object[])keys);
        span.setTag("timeout", (Number)timeout);
        return this.prepareRedisFuture(this.commands.brpop(timeout, (Object[])keys), span);
    }

    public RedisFuture<V> brpoplpush(long timeout, K source, K destination) {
        Span span = this.helper.buildSpan("brpoplpush");
        span.setTag("timeout", (Number)timeout);
        return this.prepareRedisFuture(this.commands.brpoplpush(timeout, source, destination), span);
    }

    public RedisFuture<V> lindex(K key, long index) {
        Span span = this.helper.buildSpan("lindex", key);
        span.setTag("index", (Number)index);
        return this.prepareRedisFuture(this.commands.lindex(key, index), span);
    }

    public RedisFuture<Long> linsert(K key, boolean before, V pivot, V value) {
        Span span = this.helper.buildSpan("linsert", key);
        span.setTag("before", before);
        return this.prepareRedisFuture(this.commands.linsert(key, before, pivot, value), span);
    }

    public RedisFuture<Long> llen(K key) {
        Span span = this.helper.buildSpan("llen", key);
        return this.prepareRedisFuture(this.commands.llen(key), span);
    }

    public RedisFuture<V> lpop(K key) {
        Span span = this.helper.buildSpan("lpop", key);
        return this.prepareRedisFuture(this.commands.lpop(key), span);
    }

    public RedisFuture<Long> lpush(K key, V ... values) {
        Span span = this.helper.buildSpan("lpush", key);
        return this.prepareRedisFuture(this.commands.lpush(key, (Object[])values), span);
    }

    public RedisFuture<Long> lpushx(K key, V ... values) {
        Span span = this.helper.buildSpan("lpushx", key);
        return this.prepareRedisFuture(this.commands.lpushx(key, (Object[])values), span);
    }

    public RedisFuture<List<V>> lrange(K key, long start, long stop) {
        Span span = this.helper.buildSpan("lrange", key);
        span.setTag("start", (Number)start);
        span.setTag("stop", (Number)stop);
        return this.prepareRedisFuture(this.commands.lrange(key, start, stop), span);
    }

    public RedisFuture<Long> lrange(ValueStreamingChannel<V> channel, K key, long start, long stop) {
        Span span = this.helper.buildSpan("lrange", key);
        span.setTag("start", (Number)start);
        span.setTag("stop", (Number)stop);
        return this.prepareRedisFuture(this.commands.lrange(channel, key, start, stop), span);
    }

    public RedisFuture<Long> lrem(K key, long count, V value) {
        Span span = this.helper.buildSpan("lrem", key);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.lrem(key, count, value), span);
    }

    public RedisFuture<String> lset(K key, long index, V value) {
        Span span = this.helper.buildSpan("lset", key);
        span.setTag("index", (Number)index);
        return this.prepareRedisFuture(this.commands.lset(key, index, value), span);
    }

    public RedisFuture<String> ltrim(K key, long start, long stop) {
        Span span = this.helper.buildSpan("ltrim", key);
        span.setTag("start", (Number)start);
        span.setTag("stop", (Number)stop);
        return this.prepareRedisFuture(this.commands.ltrim(key, start, stop), span);
    }

    public RedisFuture<V> rpop(K key) {
        Span span = this.helper.buildSpan("rpop", key);
        return this.prepareRedisFuture(this.commands.rpop(key), span);
    }

    public RedisFuture<V> rpoplpush(K source, K destination) {
        Span span = this.helper.buildSpan("rpoplpush");
        return this.prepareRedisFuture(this.commands.rpoplpush(source, destination), span);
    }

    public RedisFuture<Long> rpush(K key, V ... values) {
        Span span = this.helper.buildSpan("rpush", key);
        return this.prepareRedisFuture(this.commands.rpush(key, (Object[])values), span);
    }

    public RedisFuture<Long> rpushx(K key, V ... values) {
        Span span = this.helper.buildSpan("rpushx", key);
        return this.prepareRedisFuture(this.commands.rpushx(key, (Object[])values), span);
    }

    public RedisFuture<Long> sadd(K key, V ... members) {
        Span span = this.helper.buildSpan("sadd", key);
        return this.prepareRedisFuture(this.commands.sadd(key, (Object[])members), span);
    }

    public RedisFuture<Long> scard(K key) {
        Span span = this.helper.buildSpan("scard", key);
        return this.prepareRedisFuture(this.commands.scard(key), span);
    }

    public RedisFuture<Set<V>> sdiff(K ... keys) {
        Span span = this.helper.buildSpan("sdiff", (Object[])keys);
        return this.prepareRedisFuture(this.commands.sdiff((Object[])keys), span);
    }

    public RedisFuture<Long> sdiff(ValueStreamingChannel<V> channel, K ... keys) {
        Span span = this.helper.buildSpan("sdiff", (Object[])keys);
        return this.prepareRedisFuture(this.commands.sdiff(channel, (Object[])keys), span);
    }

    public RedisFuture<Long> sdiffstore(K destination, K ... keys) {
        Span span = this.helper.buildSpan("sdiffstore", (Object[])keys);
        return this.prepareRedisFuture(this.commands.sdiffstore(destination, (Object[])keys), span);
    }

    public RedisFuture<Set<V>> sinter(K ... keys) {
        Span span = this.helper.buildSpan("sinter", (Object[])keys);
        return this.prepareRedisFuture(this.commands.sinter((Object[])keys), span);
    }

    public RedisFuture<Long> sinter(ValueStreamingChannel<V> channel, K ... keys) {
        Span span = this.helper.buildSpan("sinter", (Object[])keys);
        return this.prepareRedisFuture(this.commands.sinter(channel, (Object[])keys), span);
    }

    public RedisFuture<Long> sinterstore(K destination, K ... keys) {
        Span span = this.helper.buildSpan("sinterstore", (Object[])keys);
        return this.prepareRedisFuture(this.commands.sinterstore(destination, (Object[])keys), span);
    }

    public RedisFuture<Boolean> sismember(K key, V member) {
        Span span = this.helper.buildSpan("sismember", key);
        return this.prepareRedisFuture(this.commands.sismember(key, member), span);
    }

    public RedisFuture<Boolean> smove(K source, K destination, V member) {
        Span span = this.helper.buildSpan("smove");
        return this.prepareRedisFuture(this.commands.smove(source, destination, member), span);
    }

    public RedisFuture<Set<V>> smembers(K key) {
        Span span = this.helper.buildSpan("smembers", key);
        return this.prepareRedisFuture(this.commands.smembers(key), span);
    }

    public RedisFuture<Long> smembers(ValueStreamingChannel<V> channel, K key) {
        Span span = this.helper.buildSpan("smembers", key);
        return this.prepareRedisFuture(this.commands.smembers(channel, key), span);
    }

    public RedisFuture<V> spop(K key) {
        Span span = this.helper.buildSpan("spop", key);
        return this.prepareRedisFuture(this.commands.spop(key), span);
    }

    public RedisFuture<Set<V>> spop(K key, long count) {
        Span span = this.helper.buildSpan("spop", key);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.spop(key, count), span);
    }

    public RedisFuture<V> srandmember(K key) {
        Span span = this.helper.buildSpan("srandmember", key);
        return this.prepareRedisFuture(this.commands.srandmember(key), span);
    }

    public RedisFuture<List<V>> srandmember(K key, long count) {
        Span span = this.helper.buildSpan("srandmember", key);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.srandmember(key, count), span);
    }

    public RedisFuture<Long> srandmember(ValueStreamingChannel<V> channel, K key, long count) {
        Span span = this.helper.buildSpan("srandmember", key);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.srandmember(channel, key, count), span);
    }

    public RedisFuture<Long> srem(K key, V ... members) {
        Span span = this.helper.buildSpan("srem", key);
        return this.prepareRedisFuture(this.commands.srem(key, (Object[])members), span);
    }

    public RedisFuture<Set<V>> sunion(K ... keys) {
        Span span = this.helper.buildSpan("sunion", (Object[])keys);
        return this.prepareRedisFuture(this.commands.sunion((Object[])keys), span);
    }

    public RedisFuture<Long> sunion(ValueStreamingChannel<V> channel, K ... keys) {
        Span span = this.helper.buildSpan("sunion", (Object[])keys);
        return this.prepareRedisFuture(this.commands.sunion(channel, (Object[])keys), span);
    }

    public RedisFuture<Long> sunionstore(K destination, K ... keys) {
        Span span = this.helper.buildSpan("sunionstore", (Object[])keys);
        return this.prepareRedisFuture(this.commands.sunionstore(destination, (Object[])keys), span);
    }

    public RedisFuture<ValueScanCursor<V>> sscan(K key) {
        Span span = this.helper.buildSpan("sscan", key);
        return this.prepareRedisFuture(this.commands.sscan(key), span);
    }

    public RedisFuture<ValueScanCursor<V>> sscan(K key, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("sscan", key);
        return this.prepareRedisFuture(this.commands.sscan(key, scanArgs), span);
    }

    public RedisFuture<ValueScanCursor<V>> sscan(K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("sscan", key);
        return this.prepareRedisFuture(this.commands.sscan(key, scanCursor, scanArgs), span);
    }

    public RedisFuture<ValueScanCursor<V>> sscan(K key, ScanCursor scanCursor) {
        Span span = this.helper.buildSpan("sscan", key);
        return this.prepareRedisFuture(this.commands.sscan(key, scanCursor), span);
    }

    public RedisFuture<StreamScanCursor> sscan(ValueStreamingChannel<V> channel, K key) {
        Span span = this.helper.buildSpan("sscan", key);
        return this.prepareRedisFuture(this.commands.sscan(channel, key), span);
    }

    public RedisFuture<StreamScanCursor> sscan(ValueStreamingChannel<V> channel, K key, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("sscan", key);
        return this.prepareRedisFuture(this.commands.sscan(channel, key, scanArgs), span);
    }

    public RedisFuture<StreamScanCursor> sscan(ValueStreamingChannel<V> channel, K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("sscan", key);
        return this.prepareRedisFuture(this.commands.sscan(channel, key, scanCursor, scanArgs), span);
    }

    public RedisFuture<StreamScanCursor> sscan(ValueStreamingChannel<V> channel, K key, ScanCursor scanCursor) {
        Span span = this.helper.buildSpan("sscan", key);
        return this.prepareRedisFuture(this.commands.sscan(channel, key, scanCursor), span);
    }

    public RedisFuture<KeyValue<K, ScoredValue<V>>> bzpopmin(long timeout, K ... keys) {
        Span span = this.helper.buildSpan("bzpopmin", (Object[])keys);
        span.setTag("timeout", (Number)timeout);
        return this.prepareRedisFuture(this.commands.bzpopmin(timeout, (Object[])keys), span);
    }

    public RedisFuture<KeyValue<K, ScoredValue<V>>> bzpopmax(long timeout, K ... keys) {
        Span span = this.helper.buildSpan("bzpopmax", (Object[])keys);
        span.setTag("timeout", (Number)timeout);
        return this.prepareRedisFuture(this.commands.bzpopmax(timeout, (Object[])keys), span);
    }

    public RedisFuture<Long> zadd(K key, double score, V member) {
        Span span = this.helper.buildSpan("zadd", key);
        span.setTag("score", (Number)score);
        return this.prepareRedisFuture(this.commands.zadd(key, score, member), span);
    }

    public RedisFuture<Long> zadd(K key, Object ... scoresAndValues) {
        Span span = this.helper.buildSpan("zadd", key);
        return this.prepareRedisFuture(this.commands.zadd(key, scoresAndValues), span);
    }

    public RedisFuture<Long> zadd(K key, ScoredValue<V> ... scoredValues) {
        Span span = this.helper.buildSpan("zadd", key);
        return this.prepareRedisFuture(this.commands.zadd(key, scoredValues), span);
    }

    public RedisFuture<Long> zadd(K key, ZAddArgs zAddArgs, double score, V member) {
        Span span = this.helper.buildSpan("zadd", key);
        span.setTag("score", (Number)score);
        return this.prepareRedisFuture(this.commands.zadd(key, zAddArgs, score, member), span);
    }

    public RedisFuture<Long> zadd(K key, ZAddArgs zAddArgs, Object ... scoresAndValues) {
        Span span = this.helper.buildSpan("zadd", key);
        return this.prepareRedisFuture(this.commands.zadd(key, zAddArgs, scoresAndValues), span);
    }

    public RedisFuture<Long> zadd(K key, ZAddArgs zAddArgs, ScoredValue<V> ... scoredValues) {
        Span span = this.helper.buildSpan("zadd", key);
        return this.prepareRedisFuture(this.commands.zadd(key, zAddArgs, scoredValues), span);
    }

    public RedisFuture<Double> zaddincr(K key, double score, V member) {
        Span span = this.helper.buildSpan("zaddincr", key);
        span.setTag("score", (Number)score);
        return this.prepareRedisFuture(this.commands.zaddincr(key, score, member), span);
    }

    public RedisFuture<Double> zaddincr(K key, ZAddArgs zAddArgs, double score, V member) {
        Span span = this.helper.buildSpan("zaddincr", key);
        span.setTag("score", (Number)score);
        return this.prepareRedisFuture(this.commands.zaddincr(key, zAddArgs, score, member), span);
    }

    public RedisFuture<Long> zcard(K key) {
        Span span = this.helper.buildSpan("zcard", key);
        return this.prepareRedisFuture(this.commands.zcard(key), span);
    }

    @Deprecated
    public RedisFuture<Long> zcount(K key, double min, double max) {
        Span span = this.helper.buildSpan("zcount", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        return this.prepareRedisFuture(this.commands.zcount(key, min, max), span);
    }

    @Deprecated
    public RedisFuture<Long> zcount(K key, String min, String max) {
        Span span = this.helper.buildSpan("zcount", key);
        span.setTag("min", min);
        span.setTag("max", max);
        return this.prepareRedisFuture(this.commands.zcount(key, min, max), span);
    }

    public RedisFuture<Long> zcount(K key, Range<? extends Number> range) {
        Span span = this.helper.buildSpan("zcount", key);
        span.setTag("range", TracingHelper.nullable(range));
        return this.prepareRedisFuture(this.commands.zcount(key, range), span);
    }

    public RedisFuture<Double> zincrby(K key, double amount, V member) {
        Span span = this.helper.buildSpan("zincrby", key);
        span.setTag("amount", (Number)amount);
        return this.prepareRedisFuture(this.commands.zincrby(key, amount, member), span);
    }

    public RedisFuture<Long> zinterstore(K destination, K ... keys) {
        Span span = this.helper.buildSpan("zinterstore", (Object[])keys);
        return this.prepareRedisFuture(this.commands.zinterstore(destination, (Object[])keys), span);
    }

    public RedisFuture<Long> zinterstore(K destination, ZStoreArgs storeArgs, K ... keys) {
        Span span = this.helper.buildSpan("zinterstore", (Object[])keys);
        return this.prepareRedisFuture(this.commands.zinterstore(destination, storeArgs, (Object[])keys), span);
    }

    @Deprecated
    public RedisFuture<Long> zlexcount(K key, String min, String max) {
        Span span = this.helper.buildSpan("zlexcount", key);
        span.setTag("min", min);
        span.setTag("max", max);
        return this.prepareRedisFuture(this.commands.zlexcount(key, min, max), span);
    }

    public RedisFuture<Long> zlexcount(K key, Range<? extends V> range) {
        Span span = this.helper.buildSpan("zlexcount", key);
        span.setTag("range", TracingHelper.nullable(range));
        return this.prepareRedisFuture(this.commands.zlexcount(key, range), span);
    }

    public RedisFuture<ScoredValue<V>> zpopmin(K key) {
        Span span = this.helper.buildSpan("zpopmin", key);
        return this.prepareRedisFuture(this.commands.zpopmin(key), span);
    }

    public RedisFuture<List<ScoredValue<V>>> zpopmin(K key, long count) {
        Span span = this.helper.buildSpan("zpopmin", key);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.zpopmin(key, count), span);
    }

    public RedisFuture<ScoredValue<V>> zpopmax(K key) {
        Span span = this.helper.buildSpan("zpopmax", key);
        return this.prepareRedisFuture(this.commands.zpopmax(key), span);
    }

    public RedisFuture<List<ScoredValue<V>>> zpopmax(K key, long count) {
        Span span = this.helper.buildSpan("zpopmax", key);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.zpopmax(key, count), span);
    }

    public RedisFuture<List<V>> zrange(K key, long start, long stop) {
        Span span = this.helper.buildSpan("zrange", key);
        span.setTag("start", (Number)start);
        span.setTag("stop", (Number)stop);
        return this.prepareRedisFuture(this.commands.zrange(key, start, stop), span);
    }

    public RedisFuture<Long> zrange(ValueStreamingChannel<V> channel, K key, long start, long stop) {
        Span span = this.helper.buildSpan("zrange", key);
        span.setTag("start", (Number)start);
        span.setTag("stop", (Number)stop);
        return this.prepareRedisFuture(this.commands.zrange(channel, key, start, stop), span);
    }

    public RedisFuture<List<ScoredValue<V>>> zrangeWithScores(K key, long start, long stop) {
        Span span = this.helper.buildSpan("zrangeWithScores", key);
        span.setTag("start", (Number)start);
        span.setTag("stop", (Number)stop);
        return this.prepareRedisFuture(this.commands.zrangeWithScores(key, start, stop), span);
    }

    public RedisFuture<Long> zrangeWithScores(ScoredValueStreamingChannel<V> channel, K key, long start, long stop) {
        Span span = this.helper.buildSpan("zrangeWithScores", key);
        span.setTag("start", (Number)start);
        span.setTag("stop", (Number)stop);
        return this.prepareRedisFuture(this.commands.zrangeWithScores(channel, key, start, stop), span);
    }

    @Deprecated
    public RedisFuture<List<V>> zrangebylex(K key, String min, String max) {
        Span span = this.helper.buildSpan("zrangebylex", key);
        span.setTag("min", min);
        span.setTag("max", max);
        return this.prepareRedisFuture(this.commands.zrangebylex(key, min, max), span);
    }

    public RedisFuture<List<V>> zrangebylex(K key, Range<? extends V> range) {
        Span span = this.helper.buildSpan("zrangebylex", key);
        span.setTag("range", TracingHelper.nullable(range));
        return this.prepareRedisFuture(this.commands.zrangebylex(key, range), span);
    }

    @Deprecated
    public RedisFuture<List<V>> zrangebylex(K key, String min, String max, long offset, long count) {
        Span span = this.helper.buildSpan("zrangebylex", key);
        span.setTag("min", min);
        span.setTag("max", max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.zrangebylex(key, min, max, offset, count), span);
    }

    public RedisFuture<List<V>> zrangebylex(K key, Range<? extends V> range, Limit limit) {
        Span span = this.helper.buildSpan("zrangebylex", key);
        span.setTag("range", TracingHelper.nullable(range));
        span.setTag("limit", TracingHelper.nullable((Object)limit));
        return this.prepareRedisFuture(this.commands.zrangebylex(key, range, limit), span);
    }

    @Deprecated
    public RedisFuture<List<V>> zrangebyscore(K key, double min, double max) {
        Span span = this.helper.buildSpan("zrangebyscore", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        return this.prepareRedisFuture(this.commands.zrangebyscore(key, min, max), span);
    }

    @Deprecated
    public RedisFuture<List<V>> zrangebyscore(K key, String min, String max) {
        Span span = this.helper.buildSpan("zrangebyscore", key);
        span.setTag("min", min);
        span.setTag("max", max);
        return this.prepareRedisFuture(this.commands.zrangebyscore(key, min, max), span);
    }

    public RedisFuture<List<V>> zrangebyscore(K key, Range<? extends Number> range) {
        Span span = this.helper.buildSpan("zrangebyscore", key);
        span.setTag("range", TracingHelper.nullable(range));
        return this.prepareRedisFuture(this.commands.zrangebyscore(key, range), span);
    }

    @Deprecated
    public RedisFuture<List<V>> zrangebyscore(K key, double min, double max, long offset, long count) {
        Span span = this.helper.buildSpan("zrangebyscore", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.zrangebyscore(key, min, max, offset, count), span);
    }

    @Deprecated
    public RedisFuture<List<V>> zrangebyscore(K key, String min, String max, long offset, long count) {
        Span span = this.helper.buildSpan("zrangebyscore", key);
        span.setTag("min", min);
        span.setTag("max", max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.zrangebyscore(key, min, max, offset, count), span);
    }

    public RedisFuture<List<V>> zrangebyscore(K key, Range<? extends Number> range, Limit limit) {
        Span span = this.helper.buildSpan("zrangebyscore", key);
        span.setTag("range", TracingHelper.nullable(range));
        span.setTag("limit", TracingHelper.nullable((Object)limit));
        return this.prepareRedisFuture(this.commands.zrangebyscore(key, range, limit), span);
    }

    @Deprecated
    public RedisFuture<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, double min, double max) {
        Span span = this.helper.buildSpan("zrangebyscore", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        return this.prepareRedisFuture(this.commands.zrangebyscore(channel, key, min, max), span);
    }

    @Deprecated
    public RedisFuture<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, String min, String max) {
        Span span = this.helper.buildSpan("zrangebyscore", key);
        span.setTag("min", min);
        span.setTag("max", max);
        return this.prepareRedisFuture(this.commands.zrangebyscore(channel, key, min, max), span);
    }

    public RedisFuture<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range) {
        Span span = this.helper.buildSpan("zrangebyscore", key);
        span.setTag("range", TracingHelper.nullable(range));
        return this.prepareRedisFuture(this.commands.zrangebyscore(channel, key, range), span);
    }

    @Deprecated
    public RedisFuture<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, double min, double max, long offset, long count) {
        Span span = this.helper.buildSpan("zrangebyscore", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.zrangebyscore(channel, key, min, max, offset, count), span);
    }

    @Deprecated
    public RedisFuture<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, String min, String max, long offset, long count) {
        Span span = this.helper.buildSpan("zrangebyscore", key);
        span.setTag("min", min);
        span.setTag("max", max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.zrangebyscore(channel, key, min, max, offset, count), span);
    }

    public RedisFuture<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        Span span = this.helper.buildSpan("zrangebyscore", key);
        span.setTag("range", TracingHelper.nullable(range));
        span.setTag("limit", TracingHelper.nullable((Object)limit));
        return this.prepareRedisFuture(this.commands.zrangebyscore(channel, key, range, limit), span);
    }

    @Deprecated
    public RedisFuture<List<ScoredValue<V>>> zrangebyscoreWithScores(K key, double min, double max) {
        Span span = this.helper.buildSpan("zrangebyscoreWithScores", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        return this.prepareRedisFuture(this.commands.zrangebyscoreWithScores(key, min, max), span);
    }

    @Deprecated
    public RedisFuture<List<ScoredValue<V>>> zrangebyscoreWithScores(K key, String min, String max) {
        Span span = this.helper.buildSpan("zrangebyscoreWithScores", key);
        span.setTag("min", min);
        span.setTag("max", max);
        return this.prepareRedisFuture(this.commands.zrangebyscoreWithScores(key, min, max), span);
    }

    public RedisFuture<List<ScoredValue<V>>> zrangebyscoreWithScores(K key, Range<? extends Number> range) {
        Span span = this.helper.buildSpan("zrangebyscoreWithScores", key);
        span.setTag("range", TracingHelper.nullable(range));
        return this.prepareRedisFuture(this.commands.zrangebyscoreWithScores(key, range), span);
    }

    @Deprecated
    public RedisFuture<List<ScoredValue<V>>> zrangebyscoreWithScores(K key, double min, double max, long offset, long count) {
        Span span = this.helper.buildSpan("zrangebyscoreWithScores", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.zrangebyscoreWithScores(key, min, max, offset, count), span);
    }

    @Deprecated
    public RedisFuture<List<ScoredValue<V>>> zrangebyscoreWithScores(K key, String min, String max, long offset, long count) {
        Span span = this.helper.buildSpan("zrangebyscoreWithScores", key);
        span.setTag("min", min);
        span.setTag("max", max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.zrangebyscoreWithScores(key, min, max, offset, count), span);
    }

    public RedisFuture<List<ScoredValue<V>>> zrangebyscoreWithScores(K key, Range<? extends Number> range, Limit limit) {
        Span span = this.helper.buildSpan("zrangebyscoreWithScores", key);
        span.setTag("range", TracingHelper.nullable(range));
        span.setTag("limit", TracingHelper.nullable((Object)limit));
        return this.prepareRedisFuture(this.commands.zrangebyscoreWithScores(key, range, limit), span);
    }

    @Deprecated
    public RedisFuture<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double min, double max) {
        Span span = this.helper.buildSpan("zrangebyscoreWithScores", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        return this.prepareRedisFuture(this.commands.zrangebyscoreWithScores(channel, key, min, max), span);
    }

    @Deprecated
    public RedisFuture<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String min, String max) {
        Span span = this.helper.buildSpan("zrangebyscoreWithScores", key);
        span.setTag("min", min);
        span.setTag("max", max);
        return this.prepareRedisFuture(this.commands.zrangebyscoreWithScores(channel, key, min, max), span);
    }

    public RedisFuture<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range) {
        Span span = this.helper.buildSpan("zrangebyscoreWithScores", key);
        span.setTag("range", TracingHelper.nullable(range));
        return this.prepareRedisFuture(this.commands.zrangebyscoreWithScores(channel, key, range), span);
    }

    @Deprecated
    public RedisFuture<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double min, double max, long offset, long count) {
        Span span = this.helper.buildSpan("zrangebyscoreWithScores", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.zrangebyscoreWithScores(channel, key, min, max, offset, count), span);
    }

    @Deprecated
    public RedisFuture<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String min, String max, long offset, long count) {
        Span span = this.helper.buildSpan("zrangebyscoreWithScores", key);
        span.setTag("min", min);
        span.setTag("max", max);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.zrangebyscoreWithScores(channel, key, min, max, offset, count), span);
    }

    public RedisFuture<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        Span span = this.helper.buildSpan("zrangebyscoreWithScores", key);
        span.setTag("range", TracingHelper.nullable(range));
        span.setTag("limit", TracingHelper.nullable((Object)limit));
        return this.prepareRedisFuture(this.commands.zrangebyscoreWithScores(channel, key, range, limit), span);
    }

    public RedisFuture<Long> zrank(K key, V member) {
        Span span = this.helper.buildSpan("zrank", key);
        return this.prepareRedisFuture(this.commands.zrank(key, member), span);
    }

    public RedisFuture<Long> zrem(K key, V ... members) {
        Span span = this.helper.buildSpan("zrem", key);
        return this.prepareRedisFuture(this.commands.zrem(key, (Object[])members), span);
    }

    @Deprecated
    public RedisFuture<Long> zremrangebylex(K key, String min, String max) {
        Span span = this.helper.buildSpan("zremrangebylex", key);
        span.setTag("min", min);
        span.setTag("max", max);
        return this.prepareRedisFuture(this.commands.zremrangebylex(key, min, max), span);
    }

    public RedisFuture<Long> zremrangebylex(K key, Range<? extends V> range) {
        Span span = this.helper.buildSpan("zremrangebylex", key);
        span.setTag("range", TracingHelper.nullable(range));
        return this.prepareRedisFuture(this.commands.zremrangebylex(key, range), span);
    }

    public RedisFuture<Long> zremrangebyrank(K key, long start, long stop) {
        Span span = this.helper.buildSpan("zremrangebyrank", key);
        span.setTag("start", (Number)start);
        span.setTag("stop", (Number)stop);
        return this.prepareRedisFuture(this.commands.zremrangebyrank(key, start, stop), span);
    }

    @Deprecated
    public RedisFuture<Long> zremrangebyscore(K key, double min, double max) {
        Span span = this.helper.buildSpan("zremrangebyscore", key);
        span.setTag("min", (Number)min);
        span.setTag("max", (Number)max);
        return this.prepareRedisFuture(this.commands.zremrangebyscore(key, min, max), span);
    }

    @Deprecated
    public RedisFuture<Long> zremrangebyscore(K key, String min, String max) {
        Span span = this.helper.buildSpan("zremrangebyscore", key);
        span.setTag("min", min);
        span.setTag("max", max);
        return this.prepareRedisFuture(this.commands.zremrangebyscore(key, min, max), span);
    }

    public RedisFuture<Long> zremrangebyscore(K key, Range<? extends Number> range) {
        Span span = this.helper.buildSpan("zremrangebyscore", key);
        span.setTag("range", TracingHelper.nullable(range));
        return this.prepareRedisFuture(this.commands.zremrangebyscore(key, range), span);
    }

    public RedisFuture<List<V>> zrevrange(K key, long start, long stop) {
        Span span = this.helper.buildSpan("zrevrange", key);
        span.setTag("start", (Number)start);
        span.setTag("stop", (Number)stop);
        return this.prepareRedisFuture(this.commands.zrevrange(key, start, stop), span);
    }

    public RedisFuture<Long> zrevrange(ValueStreamingChannel<V> channel, K key, long start, long stop) {
        Span span = this.helper.buildSpan("zrevrange", key);
        span.setTag("start", (Number)start);
        span.setTag("stop", (Number)stop);
        return this.prepareRedisFuture(this.commands.zrevrange(channel, key, start, stop), span);
    }

    public RedisFuture<List<ScoredValue<V>>> zrevrangeWithScores(K key, long start, long stop) {
        Span span = this.helper.buildSpan("zrevrangeWithScores", key);
        span.setTag("start", (Number)start);
        span.setTag("stop", (Number)stop);
        return this.prepareRedisFuture(this.commands.zrevrangeWithScores(key, start, stop), span);
    }

    public RedisFuture<Long> zrevrangeWithScores(ScoredValueStreamingChannel<V> channel, K key, long start, long stop) {
        Span span = this.helper.buildSpan("zrevrangeWithScores", key);
        span.setTag("start", (Number)start);
        span.setTag("stop", (Number)stop);
        return this.prepareRedisFuture(this.commands.zrevrangeWithScores(channel, key, start, stop), span);
    }

    public RedisFuture<List<V>> zrevrangebylex(K key, Range<? extends V> range) {
        Span span = this.helper.buildSpan("zrevrangebylex", key);
        span.setTag("range", TracingHelper.nullable(range));
        return this.prepareRedisFuture(this.commands.zrevrangebylex(key, range), span);
    }

    public RedisFuture<List<V>> zrevrangebylex(K key, Range<? extends V> range, Limit limit) {
        Span span = this.helper.buildSpan("zrevrangebylex", key);
        span.setTag("range", TracingHelper.nullable(range));
        span.setTag("limit", TracingHelper.nullable((Object)limit));
        return this.prepareRedisFuture(this.commands.zrevrangebylex(key, range, limit), span);
    }

    @Deprecated
    public RedisFuture<List<V>> zrevrangebyscore(K key, double max, double min) {
        Span span = this.helper.buildSpan("zrevrangebyscore", key);
        span.setTag("max", (Number)max);
        span.setTag("min", (Number)min);
        return this.prepareRedisFuture(this.commands.zrevrangebyscore(key, max, min), span);
    }

    @Deprecated
    public RedisFuture<List<V>> zrevrangebyscore(K key, String max, String min) {
        Span span = this.helper.buildSpan("zrevrangebyscore", key);
        span.setTag("max", max);
        span.setTag("min", min);
        return this.prepareRedisFuture(this.commands.zrevrangebyscore(key, max, min), span);
    }

    public RedisFuture<List<V>> zrevrangebyscore(K key, Range<? extends Number> range) {
        Span span = this.helper.buildSpan("zrevrangebyscore", key);
        span.setTag("range", TracingHelper.nullable(range));
        return this.prepareRedisFuture(this.commands.zrevrangebyscore(key, range), span);
    }

    @Deprecated
    public RedisFuture<List<V>> zrevrangebyscore(K key, double max, double min, long offset, long count) {
        Span span = this.helper.buildSpan("zrevrangebyscore", key);
        span.setTag("max", (Number)max);
        span.setTag("min", (Number)min);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.zrevrangebyscore(key, max, min, offset, count), span);
    }

    @Deprecated
    public RedisFuture<List<V>> zrevrangebyscore(K key, String max, String min, long offset, long count) {
        Span span = this.helper.buildSpan("zrevrangebyscore", key);
        span.setTag("max", max);
        span.setTag("min", min);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.zrevrangebyscore(key, max, min, offset, count), span);
    }

    public RedisFuture<List<V>> zrevrangebyscore(K key, Range<? extends Number> range, Limit limit) {
        Span span = this.helper.buildSpan("zrevrangebyscore", key);
        span.setTag("range", TracingHelper.nullable(range));
        span.setTag("limit", TracingHelper.nullable((Object)limit));
        return this.prepareRedisFuture(this.commands.zrevrangebyscore(key, range, limit), span);
    }

    @Deprecated
    public RedisFuture<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, double max, double min) {
        Span span = this.helper.buildSpan("zrevrangebyscore", key);
        span.setTag("max", (Number)max);
        span.setTag("min", (Number)min);
        return this.prepareRedisFuture(this.commands.zrevrangebyscore(channel, key, max, min), span);
    }

    @Deprecated
    public RedisFuture<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, String max, String min) {
        Span span = this.helper.buildSpan("zrevrangebyscore", key);
        span.setTag("max", max);
        span.setTag("min", min);
        return this.prepareRedisFuture(this.commands.zrevrangebyscore(channel, key, max, min), span);
    }

    public RedisFuture<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range) {
        Span span = this.helper.buildSpan("zrevrangebyscore", key);
        span.setTag("range", TracingHelper.nullable(range));
        return this.prepareRedisFuture(this.commands.zrevrangebyscore(channel, key, range), span);
    }

    @Deprecated
    public RedisFuture<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, double max, double min, long offset, long count) {
        Span span = this.helper.buildSpan("zrevrangebyscore", key);
        span.setTag("max", (Number)max);
        span.setTag("min", (Number)min);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.zrevrangebyscore(channel, key, max, min, offset, count), span);
    }

    @Deprecated
    public RedisFuture<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, String max, String min, long offset, long count) {
        Span span = this.helper.buildSpan("zrevrangebyscore", key);
        span.setTag("max", max);
        span.setTag("min", min);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.zrevrangebyscore(channel, key, max, min, offset, count), span);
    }

    public RedisFuture<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        Span span = this.helper.buildSpan("zrevrangebyscore", key);
        span.setTag("range", TracingHelper.nullable(range));
        span.setTag("limit", TracingHelper.nullable((Object)limit));
        return this.prepareRedisFuture(this.commands.zrevrangebyscore(channel, key, range, limit), span);
    }

    @Deprecated
    public RedisFuture<List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, double max, double min) {
        Span span = this.helper.buildSpan("zrevrangebyscoreWithScores", key);
        span.setTag("max", (Number)max);
        span.setTag("min", (Number)min);
        return this.prepareRedisFuture(this.commands.zrevrangebyscoreWithScores(key, max, min), span);
    }

    @Deprecated
    public RedisFuture<List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, String max, String min) {
        Span span = this.helper.buildSpan("zrevrangebyscoreWithScores", key);
        span.setTag("max", max);
        span.setTag("min", min);
        return this.prepareRedisFuture(this.commands.zrevrangebyscoreWithScores(key, max, min), span);
    }

    public RedisFuture<List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, Range<? extends Number> range) {
        Span span = this.helper.buildSpan("zrevrangebyscoreWithScores", key);
        span.setTag("range", TracingHelper.nullable(range));
        return this.prepareRedisFuture(this.commands.zrevrangebyscoreWithScores(key, range), span);
    }

    @Deprecated
    public RedisFuture<List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, double max, double min, long offset, long count) {
        Span span = this.helper.buildSpan("zrevrangebyscoreWithScores", key);
        span.setTag("max", (Number)max);
        span.setTag("min", (Number)min);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.zrevrangebyscoreWithScores(key, max, min, offset, count), span);
    }

    @Deprecated
    public RedisFuture<List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, String max, String min, long offset, long count) {
        Span span = this.helper.buildSpan("zrevrangebyscoreWithScores", key);
        span.setTag("max", max);
        span.setTag("min", min);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.zrevrangebyscoreWithScores(key, max, min, offset, count), span);
    }

    public RedisFuture<List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, Range<? extends Number> range, Limit limit) {
        Span span = this.helper.buildSpan("zrevrangebyscoreWithScores", key);
        span.setTag("range", TracingHelper.nullable(range));
        span.setTag("limit", TracingHelper.nullable((Object)limit));
        return this.prepareRedisFuture(this.commands.zrevrangebyscoreWithScores(key, range, limit), span);
    }

    @Deprecated
    public RedisFuture<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double max, double min) {
        Span span = this.helper.buildSpan("zrevrangebyscoreWithScores", key);
        span.setTag("max", (Number)max);
        span.setTag("min", (Number)min);
        return this.prepareRedisFuture(this.commands.zrevrangebyscoreWithScores(channel, key, max, min), span);
    }

    @Deprecated
    public RedisFuture<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String max, String min) {
        Span span = this.helper.buildSpan("zrevrangebyscoreWithScores", key);
        span.setTag("max", max);
        span.setTag("min", min);
        return this.prepareRedisFuture(this.commands.zrevrangebyscoreWithScores(channel, key, max, min), span);
    }

    public RedisFuture<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range) {
        Span span = this.helper.buildSpan("zrevrangebyscoreWithScores", key);
        span.setTag("range", TracingHelper.nullable(range));
        return this.prepareRedisFuture(this.commands.zrevrangebyscoreWithScores(channel, key, range), span);
    }

    @Deprecated
    public RedisFuture<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double max, double min, long offset, long count) {
        Span span = this.helper.buildSpan("zrevrangebyscoreWithScores", key);
        span.setTag("max", (Number)max);
        span.setTag("min", (Number)min);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.zrevrangebyscoreWithScores(channel, key, max, min, offset, count), span);
    }

    @Deprecated
    public RedisFuture<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String max, String min, long offset, long count) {
        Span span = this.helper.buildSpan("zrevrangebyscoreWithScores", key);
        span.setTag("max", max);
        span.setTag("min", min);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.zrevrangebyscoreWithScores(channel, key, max, min, offset, count), span);
    }

    public RedisFuture<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        Span span = this.helper.buildSpan("zrevrangebyscoreWithScores", key);
        span.setTag("range", TracingHelper.nullable(range));
        span.setTag("limit", TracingHelper.nullable((Object)limit));
        return this.prepareRedisFuture(this.commands.zrevrangebyscoreWithScores(channel, key, range, limit), span);
    }

    public RedisFuture<Long> zrevrank(K key, V member) {
        Span span = this.helper.buildSpan("zrevrank", key);
        return this.prepareRedisFuture(this.commands.zrevrank(key, member), span);
    }

    public RedisFuture<ScoredValueScanCursor<V>> zscan(K key) {
        Span span = this.helper.buildSpan("zscan", key);
        return this.prepareRedisFuture(this.commands.zscan(key), span);
    }

    public RedisFuture<ScoredValueScanCursor<V>> zscan(K key, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("zscan", key);
        return this.prepareRedisFuture(this.commands.zscan(key, scanArgs), span);
    }

    public RedisFuture<ScoredValueScanCursor<V>> zscan(K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("zscan", key);
        return this.prepareRedisFuture(this.commands.zscan(key, scanCursor, scanArgs), span);
    }

    public RedisFuture<ScoredValueScanCursor<V>> zscan(K key, ScanCursor scanCursor) {
        Span span = this.helper.buildSpan("zscan", key);
        return this.prepareRedisFuture(this.commands.zscan(key, scanCursor), span);
    }

    public RedisFuture<StreamScanCursor> zscan(ScoredValueStreamingChannel<V> channel, K key) {
        Span span = this.helper.buildSpan("zscan", key);
        return this.prepareRedisFuture(this.commands.zscan(channel, key), span);
    }

    public RedisFuture<StreamScanCursor> zscan(ScoredValueStreamingChannel<V> channel, K key, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("zscan", key);
        return this.prepareRedisFuture(this.commands.zscan(channel, key, scanArgs), span);
    }

    public RedisFuture<StreamScanCursor> zscan(ScoredValueStreamingChannel<V> channel, K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        Span span = this.helper.buildSpan("zscan", key);
        return this.prepareRedisFuture(this.commands.zscan(channel, key, scanCursor, scanArgs), span);
    }

    public RedisFuture<StreamScanCursor> zscan(ScoredValueStreamingChannel<V> channel, K key, ScanCursor scanCursor) {
        Span span = this.helper.buildSpan("zscan", key);
        return this.prepareRedisFuture(this.commands.zscan(channel, key, scanCursor), span);
    }

    public RedisFuture<Double> zscore(K key, V member) {
        Span span = this.helper.buildSpan("zscore", key);
        return this.prepareRedisFuture(this.commands.zscore(key, member), span);
    }

    public RedisFuture<Long> zunionstore(K destination, K ... keys) {
        Span span = this.helper.buildSpan("zunionstore", (Object[])keys);
        return this.prepareRedisFuture(this.commands.zunionstore(destination, (Object[])keys), span);
    }

    public RedisFuture<Long> zunionstore(K destination, ZStoreArgs storeArgs, K ... keys) {
        Span span = this.helper.buildSpan("zunionstore", (Object[])keys);
        return this.prepareRedisFuture(this.commands.zunionstore(destination, storeArgs, (Object[])keys), span);
    }

    public RedisFuture<Long> xack(K key, K group, String ... messageIds) {
        Span span = this.helper.buildSpan("xack", key);
        span.setTag("group", TracingHelper.nullable(group));
        span.setTag("messageIds", Arrays.toString(messageIds));
        return this.prepareRedisFuture(this.commands.xack(key, group, messageIds), span);
    }

    public RedisFuture<String> xadd(K key, Map<K, V> body) {
        Span span = this.helper.buildSpan("xadd", key);
        span.setTag("body", TracingHelper.mapToString(body));
        return this.prepareRedisFuture(this.commands.xadd(key, body), span);
    }

    public RedisFuture<String> xadd(K key, XAddArgs args, Map<K, V> body) {
        Span span = this.helper.buildSpan("xadd", key);
        span.setTag("body", TracingHelper.mapToString(body));
        return this.prepareRedisFuture(this.commands.xadd(key, args, body), span);
    }

    public RedisFuture<String> xadd(K key, Object ... keysAndValues) {
        Span span = this.helper.buildSpan("xadd", key);
        span.setTag("keysAndValues", Arrays.toString(keysAndValues));
        return this.prepareRedisFuture(this.commands.xadd(key, keysAndValues), span);
    }

    public RedisFuture<String> xadd(K key, XAddArgs args, Object ... keysAndValues) {
        Span span = this.helper.buildSpan("xadd", key);
        span.setTag("keysAndValues", Arrays.toString(keysAndValues));
        return this.prepareRedisFuture(this.commands.xadd(key, args, keysAndValues), span);
    }

    public RedisFuture<List<StreamMessage<K, V>>> xclaim(K key, Consumer<K> consumer, long minIdleTime, String ... messageIds) {
        Span span = this.helper.buildSpan("xclaim", key);
        span.setTag("minIdleTime", (Number)minIdleTime);
        span.setTag("consumer", TracingHelper.nullable(consumer));
        span.setTag("messageIds", Arrays.toString(messageIds));
        return this.prepareRedisFuture(this.commands.xclaim(key, consumer, minIdleTime, messageIds), span);
    }

    public RedisFuture<List<StreamMessage<K, V>>> xclaim(K key, Consumer<K> consumer, XClaimArgs args, String ... messageIds) {
        Span span = this.helper.buildSpan("xclaim", key);
        span.setTag("consumer", TracingHelper.nullable(consumer));
        span.setTag("messageIds", Arrays.toString(messageIds));
        return this.prepareRedisFuture(this.commands.xclaim(key, consumer, args, messageIds), span);
    }

    public RedisFuture<Long> xdel(K key, String ... messageIds) {
        Span span = this.helper.buildSpan("xdel", key);
        span.setTag("messageIds", Arrays.toString(messageIds));
        return this.prepareRedisFuture(this.commands.xdel(key, messageIds), span);
    }

    public RedisFuture<String> xgroupCreate(XReadArgs.StreamOffset<K> streamOffset, K group) {
        Span span = this.helper.buildSpan("xgroupCreate");
        span.setTag("streamOffset", TracingHelper.nullable(streamOffset));
        span.setTag("group", TracingHelper.nullable(group));
        return this.prepareRedisFuture(this.commands.xgroupCreate(streamOffset, group), span);
    }

    public RedisFuture<Boolean> xgroupDelconsumer(K key, Consumer<K> consumer) {
        Span span = this.helper.buildSpan("xgroupDelconsumer", key);
        span.setTag("consumer", TracingHelper.nullable(consumer));
        return this.prepareRedisFuture(this.commands.xgroupDelconsumer(key, consumer), span);
    }

    public RedisFuture<Boolean> xgroupDestroy(K key, K group) {
        Span span = this.helper.buildSpan("xgroupDestroy", key);
        span.setTag("group", TracingHelper.nullable(group));
        return this.prepareRedisFuture(this.commands.xgroupDestroy(key, group), span);
    }

    public RedisFuture<String> xgroupSetid(XReadArgs.StreamOffset<K> streamOffset, K group) {
        Span span = this.helper.buildSpan("xgroupSetid");
        span.setTag("streamOffset", TracingHelper.nullable(streamOffset));
        span.setTag("group", TracingHelper.nullable(group));
        return this.prepareRedisFuture(this.commands.xgroupSetid(streamOffset, group), span);
    }

    public RedisFuture<Long> xlen(K key) {
        Span span = this.helper.buildSpan("xlen", key);
        return this.prepareRedisFuture(this.commands.xlen(key), span);
    }

    public RedisFuture<List<Object>> xpending(K key, K group) {
        Span span = this.helper.buildSpan("xpending", key);
        span.setTag("group", TracingHelper.nullable(group));
        return this.prepareRedisFuture(this.commands.xpending(key, group), span);
    }

    public RedisFuture<List<Object>> xpending(K key, K group, Range<String> range, Limit limit) {
        Span span = this.helper.buildSpan("xpending", key);
        span.setTag("group", TracingHelper.nullable(group));
        span.setTag("range", TracingHelper.nullable(range));
        span.setTag("limit", TracingHelper.nullable((Object)limit));
        return this.prepareRedisFuture(this.commands.xpending(key, group, range, limit), span);
    }

    public RedisFuture<List<Object>> xpending(K key, Consumer<K> consumer, Range<String> range, Limit limit) {
        Span span = this.helper.buildSpan("xpending", key);
        span.setTag("consumer", TracingHelper.nullable(consumer));
        span.setTag("range", TracingHelper.nullable(range));
        span.setTag("limit", TracingHelper.nullable((Object)limit));
        return this.prepareRedisFuture(this.commands.xpending(key, consumer, range, limit), span);
    }

    public RedisFuture<List<StreamMessage<K, V>>> xrange(K key, Range<String> range) {
        Span span = this.helper.buildSpan("xrange", key);
        span.setTag("range", TracingHelper.nullable(range));
        return this.prepareRedisFuture(this.commands.xrange(key, range), span);
    }

    public RedisFuture<List<StreamMessage<K, V>>> xrange(K key, Range<String> range, Limit limit) {
        Span span = this.helper.buildSpan("xrange", key);
        span.setTag("range", TracingHelper.nullable(range));
        span.setTag("limit", TracingHelper.nullable((Object)limit));
        return this.prepareRedisFuture(this.commands.xrange(key, range, limit), span);
    }

    public RedisFuture<List<StreamMessage<K, V>>> xread(XReadArgs.StreamOffset<K> ... streams) {
        Span span = this.helper.buildSpan("xread");
        span.setTag("streams", Arrays.toString(streams));
        return this.prepareRedisFuture(this.commands.xread(streams), span);
    }

    public RedisFuture<List<StreamMessage<K, V>>> xread(XReadArgs args, XReadArgs.StreamOffset<K> ... streams) {
        Span span = this.helper.buildSpan("xread");
        span.setTag("streams", Arrays.toString(streams));
        return this.prepareRedisFuture(this.commands.xread(args, streams), span);
    }

    public RedisFuture<List<StreamMessage<K, V>>> xreadgroup(Consumer<K> consumer, XReadArgs.StreamOffset<K> ... streams) {
        Span span = this.helper.buildSpan("xreadgroup");
        span.setTag("consumer", TracingHelper.nullable(consumer));
        span.setTag("streams", Arrays.toString(streams));
        return this.prepareRedisFuture(this.commands.xreadgroup(consumer, streams), span);
    }

    public RedisFuture<List<StreamMessage<K, V>>> xreadgroup(Consumer<K> consumer, XReadArgs args, XReadArgs.StreamOffset<K> ... streams) {
        Span span = this.helper.buildSpan("xreadgroup");
        span.setTag("consumer", TracingHelper.nullable(consumer));
        span.setTag("streams", Arrays.toString(streams));
        return this.prepareRedisFuture(this.commands.xreadgroup(consumer, args, streams), span);
    }

    public RedisFuture<List<StreamMessage<K, V>>> xrevrange(K key, Range<String> range) {
        Span span = this.helper.buildSpan("xrevrange", key);
        span.setTag("range", TracingHelper.nullable(range));
        return this.prepareRedisFuture(this.commands.xrevrange(key, range), span);
    }

    public RedisFuture<List<StreamMessage<K, V>>> xrevrange(K key, Range<String> range, Limit limit) {
        Span span = this.helper.buildSpan("xrevrange", key);
        span.setTag("range", TracingHelper.nullable(range));
        span.setTag("limit", TracingHelper.nullable((Object)limit));
        return this.prepareRedisFuture(this.commands.xrevrange(key, range, limit), span);
    }

    public RedisFuture<Long> xtrim(K key, long count) {
        Span span = this.helper.buildSpan("xtrim", key);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.xtrim(key, count), span);
    }

    public RedisFuture<Long> xtrim(K key, boolean approximateTrimming, long count) {
        Span span = this.helper.buildSpan("xtrim", key);
        span.setTag("approximateTrimming", approximateTrimming);
        span.setTag("count", (Number)count);
        return this.prepareRedisFuture(this.commands.xtrim(key, approximateTrimming, count), span);
    }

    public <T> RedisFuture<T> eval(String script, ScriptOutputType type, K ... keys) {
        Span span = this.helper.buildSpan("eval", (Object[])keys);
        return this.prepareRedisFuture(this.commands.eval(script, type, (Object[])keys), span);
    }

    public <T> RedisFuture<T> eval(String script, ScriptOutputType type, K[] keys, V ... values) {
        Span span = this.helper.buildSpan("eval", (Object[])keys);
        return this.prepareRedisFuture(this.commands.eval(script, type, (Object[])keys, (Object[])values), span);
    }

    public <T> RedisFuture<T> evalsha(String digest, ScriptOutputType type, K ... keys) {
        Span span = this.helper.buildSpan("evalsha", (Object[])keys);
        return this.prepareRedisFuture(this.commands.evalsha(digest, type, (Object[])keys), span);
    }

    public <T> RedisFuture<T> evalsha(String digest, ScriptOutputType type, K[] keys, V ... values) {
        Span span = this.helper.buildSpan("evalsha", (Object[])keys);
        return this.prepareRedisFuture(this.commands.evalsha(digest, type, (Object[])keys, (Object[])values), span);
    }

    public RedisFuture<List<Boolean>> scriptExists(String ... digests) {
        Span span = this.helper.buildSpan("scriptExists");
        return this.prepareRedisFuture(this.commands.scriptExists(digests), span);
    }

    public RedisFuture<String> scriptFlush() {
        Span span = this.helper.buildSpan("scriptFlush");
        return this.prepareRedisFuture(this.commands.scriptFlush(), span);
    }

    public RedisFuture<String> scriptKill() {
        Span span = this.helper.buildSpan("scriptKill");
        return this.prepareRedisFuture(this.commands.scriptKill(), span);
    }

    public RedisFuture<String> scriptLoad(V script) {
        Span span = this.helper.buildSpan("scriptLoad");
        return this.prepareRedisFuture(this.commands.scriptLoad(script), span);
    }

    public String digest(V script) {
        Span span = this.helper.buildSpan("digest");
        try {
            String string = this.commands.digest(script);
            return string;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public RedisFuture<String> bgrewriteaof() {
        Span span = this.helper.buildSpan("bgrewriteaof");
        return this.prepareRedisFuture(this.commands.bgrewriteaof(), span);
    }

    public RedisFuture<String> bgsave() {
        Span span = this.helper.buildSpan("bgsave");
        return this.prepareRedisFuture(this.commands.bgsave(), span);
    }

    public RedisFuture<K> clientGetname() {
        Span span = this.helper.buildSpan("clientGetname");
        return this.prepareRedisFuture(this.commands.clientGetname(), span);
    }

    public RedisFuture<String> clientSetname(K name) {
        Span span = this.helper.buildSpan("clientSetname");
        return this.prepareRedisFuture(this.commands.clientSetname(name), span);
    }

    public RedisFuture<String> clientKill(String addr) {
        Span span = this.helper.buildSpan("clientKill");
        return this.prepareRedisFuture(this.commands.clientKill(addr), span);
    }

    public RedisFuture<Long> clientKill(KillArgs killArgs) {
        Span span = this.helper.buildSpan("clientKill");
        return this.prepareRedisFuture(this.commands.clientKill(killArgs), span);
    }

    public RedisFuture<Long> clientUnblock(long id, UnblockType type) {
        Span span = this.helper.buildSpan("clientUnblock");
        span.setTag("id", (Number)id);
        span.setTag("type", TracingHelper.nullable((Object)type));
        return this.prepareRedisFuture(this.commands.clientUnblock(id, type), span);
    }

    public RedisFuture<String> clientPause(long timeout) {
        Span span = this.helper.buildSpan("clientPause");
        return this.prepareRedisFuture(this.commands.clientPause(timeout), span);
    }

    public RedisFuture<String> clientList() {
        Span span = this.helper.buildSpan("clientList");
        return this.prepareRedisFuture(this.commands.clientList(), span);
    }

    public RedisFuture<List<Object>> command() {
        Span span = this.helper.buildSpan("command");
        return this.prepareRedisFuture(this.commands.command(), span);
    }

    public RedisFuture<List<Object>> commandInfo(String ... commands) {
        Span span = this.helper.buildSpan("commandInfo");
        return this.commands.commandInfo(commands);
    }

    public RedisFuture<List<Object>> commandInfo(CommandType ... commands) {
        Span span = this.helper.buildSpan("commandInfo");
        return this.commands.commandInfo(commands);
    }

    public RedisFuture<Long> commandCount() {
        Span span = this.helper.buildSpan("commandCount");
        return this.prepareRedisFuture(this.commands.commandCount(), span);
    }

    public RedisFuture<Map<String, String>> configGet(String parameter) {
        Span span = this.helper.buildSpan("configGet");
        return this.prepareRedisFuture(this.commands.configGet(parameter), span);
    }

    public RedisFuture<String> configResetstat() {
        Span span = this.helper.buildSpan("configResetstat");
        return this.prepareRedisFuture(this.commands.configResetstat(), span);
    }

    public RedisFuture<String> configRewrite() {
        Span span = this.helper.buildSpan("configRewrite");
        return this.prepareRedisFuture(this.commands.configRewrite(), span);
    }

    public RedisFuture<String> configSet(String parameter, String value) {
        Span span = this.helper.buildSpan("configSet");
        return this.prepareRedisFuture(this.commands.configSet(parameter, value), span);
    }

    public RedisFuture<Long> dbsize() {
        Span span = this.helper.buildSpan("dbsize");
        return this.prepareRedisFuture(this.commands.dbsize(), span);
    }

    public RedisFuture<String> debugCrashAndRecover(Long delay) {
        Span span = this.helper.buildSpan("debugCrashAndRecover");
        return this.prepareRedisFuture(this.commands.debugCrashAndRecover(delay), span);
    }

    public RedisFuture<String> debugHtstats(int db) {
        Span span = this.helper.buildSpan("debugHtstats");
        return this.prepareRedisFuture(this.commands.debugHtstats(db), span);
    }

    public RedisFuture<String> debugObject(K key) {
        Span span = this.helper.buildSpan("debugObject", key);
        return this.prepareRedisFuture(this.commands.debugObject(key), span);
    }

    public void debugOom() {
        Span span = this.helper.buildSpan("debugOom");
        try {
            this.debugOom();
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public void debugSegfault() {
        Span span = this.helper.buildSpan("debugSegfault");
        try {
            this.commands.debugSegfault();
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public RedisFuture<String> debugReload() {
        Span span = this.helper.buildSpan("debugReload");
        return this.prepareRedisFuture(this.commands.debugReload(), span);
    }

    public RedisFuture<String> debugRestart(Long delay) {
        Span span = this.helper.buildSpan("debugRestart");
        return this.prepareRedisFuture(this.commands.debugRestart(delay), span);
    }

    public RedisFuture<String> debugSdslen(K key) {
        Span span = this.helper.buildSpan("debugSdslen", key);
        return this.prepareRedisFuture(this.commands.debugSdslen(key), span);
    }

    public RedisFuture<String> flushall() {
        Span span = this.helper.buildSpan("flushall");
        return this.prepareRedisFuture(this.commands.flushall(), span);
    }

    public RedisFuture<String> flushallAsync() {
        Span span = this.helper.buildSpan("flushallAsync");
        return this.prepareRedisFuture(this.commands.flushallAsync(), span);
    }

    public RedisFuture<String> flushdb() {
        Span span = this.helper.buildSpan("flushdb");
        return this.prepareRedisFuture(this.commands.flushdb(), span);
    }

    public RedisFuture<String> flushdbAsync() {
        Span span = this.helper.buildSpan("flushdbAsync");
        return this.prepareRedisFuture(this.commands.flushdbAsync(), span);
    }

    public RedisFuture<String> info() {
        Span span = this.helper.buildSpan("info");
        return this.prepareRedisFuture(this.commands.info(), span);
    }

    public RedisFuture<String> info(String section) {
        Span span = this.helper.buildSpan("info");
        return this.prepareRedisFuture(this.commands.info(section), span);
    }

    public RedisFuture<Date> lastsave() {
        Span span = this.helper.buildSpan("lastsave");
        return this.prepareRedisFuture(this.commands.lastsave(), span);
    }

    public RedisFuture<String> save() {
        Span span = this.helper.buildSpan("save");
        return this.prepareRedisFuture(this.commands.save(), span);
    }

    public void shutdown(boolean save) {
        Span span = this.helper.buildSpan("shutdown");
        try {
            this.commands.shutdown(save);
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public RedisFuture<String> slaveof(String host, int port) {
        Span span = this.helper.buildSpan("slaveof");
        return this.prepareRedisFuture(this.commands.slaveof(host, port), span);
    }

    public RedisFuture<String> slaveofNoOne() {
        Span span = this.helper.buildSpan("slaveofNoOne");
        return this.prepareRedisFuture(this.commands.slaveofNoOne(), span);
    }

    public RedisFuture<List<Object>> slowlogGet() {
        Span span = this.helper.buildSpan("slowlogGet");
        return this.prepareRedisFuture(this.commands.slowlogGet(), span);
    }

    public RedisFuture<List<Object>> slowlogGet(int count) {
        Span span = this.helper.buildSpan("slowlogGet");
        return this.prepareRedisFuture(this.commands.slowlogGet(count), span);
    }

    public RedisFuture<Long> slowlogLen() {
        Span span = this.helper.buildSpan("slowlogLen");
        return this.prepareRedisFuture(this.commands.slowlogLen(), span);
    }

    public RedisFuture<String> slowlogReset() {
        Span span = this.helper.buildSpan("slowlogReset");
        return this.prepareRedisFuture(this.commands.slowlogReset(), span);
    }

    public RedisFuture<List<V>> time() {
        Span span = this.helper.buildSpan("time");
        return this.prepareRedisFuture(this.commands.time(), span);
    }

    public RedisFuture<Long> pfadd(K key, V ... values) {
        Span span = this.helper.buildSpan("pfadd", key);
        return this.prepareRedisFuture(this.commands.pfadd(key, (Object[])values), span);
    }

    public RedisFuture<String> pfmerge(K destkey, K ... sourcekeys) {
        Span span = this.helper.buildSpan("pfmerge");
        return this.prepareRedisFuture(this.commands.pfmerge(destkey, (Object[])sourcekeys), span);
    }

    public RedisFuture<Long> pfcount(K ... keys) {
        Span span = this.helper.buildSpan("pfcount", (Object[])keys);
        return this.prepareRedisFuture(this.commands.pfcount((Object[])keys), span);
    }

    public RedisFuture<Long> publish(K channel, V message) {
        Span span = this.helper.buildSpan("publish");
        return this.prepareRedisFuture(this.commands.publish(channel, message), span);
    }

    public RedisFuture<List<K>> pubsubChannels() {
        Span span = this.helper.buildSpan("pubsubChannels");
        return this.prepareRedisFuture(this.commands.pubsubChannels(), span);
    }

    public RedisFuture<List<K>> pubsubChannels(K channel) {
        Span span = this.helper.buildSpan("pubsubChannels");
        return this.prepareRedisFuture(this.commands.pubsubChannels(channel), span);
    }

    public RedisFuture<Map<K, Long>> pubsubNumsub(K ... channels) {
        Span span = this.helper.buildSpan("pubsubNumsub");
        return this.prepareRedisFuture(this.commands.pubsubNumsub((Object[])channels), span);
    }

    public RedisFuture<Long> pubsubNumpat() {
        Span span = this.helper.buildSpan("pubsubNumpat");
        return this.prepareRedisFuture(this.commands.pubsubNumpat(), span);
    }

    public RedisFuture<V> echo(V msg) {
        Span span = this.helper.buildSpan("echo");
        return this.prepareRedisFuture(this.commands.echo(msg), span);
    }

    public RedisFuture<List<Object>> role() {
        Span span = this.helper.buildSpan("role");
        return this.prepareRedisFuture(this.commands.role(), span);
    }

    public RedisFuture<String> ping() {
        Span span = this.helper.buildSpan("ping");
        return this.prepareRedisFuture(this.commands.ping(), span);
    }

    public RedisFuture<String> readOnly() {
        Span span = this.helper.buildSpan("readOnly");
        return this.prepareRedisFuture(this.commands.readOnly(), span);
    }

    public RedisFuture<String> readWrite() {
        Span span = this.helper.buildSpan("readWrite");
        return this.prepareRedisFuture(this.commands.readWrite(), span);
    }

    public RedisFuture<String> quit() {
        Span span = this.helper.buildSpan("quit");
        return this.prepareRedisFuture(this.commands.quit(), span);
    }

    public RedisFuture<Long> waitForReplication(int replicas, long timeout) {
        Span span = this.helper.buildSpan("waitForReplication");
        return this.prepareRedisFuture(this.commands.waitForReplication(replicas, timeout), span);
    }

    public <T> RedisFuture<T> dispatch(ProtocolKeyword type, CommandOutput<K, V, T> output) {
        Span span = this.helper.buildSpan("dispatch");
        return this.prepareRedisFuture(this.commands.dispatch(type, output), span);
    }

    public <T> RedisFuture<T> dispatch(ProtocolKeyword type, CommandOutput<K, V, T> output, CommandArgs<K, V> args) {
        Span span = this.helper.buildSpan("dispatch");
        return this.prepareRedisFuture(this.commands.dispatch(type, output, args), span);
    }

    public boolean isOpen() {
        Span span = this.helper.buildSpan("isOpen");
        try {
            boolean bl = this.commands.isOpen();
            return bl;
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public void reset() {
        Span span = this.helper.buildSpan("reset");
        try {
            this.commands.reset();
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public void setAutoFlushCommands(boolean autoFlush) {
        Span span = this.helper.buildSpan("setAutoFlushCommands");
        try {
            this.commands.setAutoFlushCommands(autoFlush);
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public void flushCommands() {
        Span span = this.helper.buildSpan("flushCommands");
        try {
            this.commands.flushCommands();
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public void setTimeout(Duration timeout) {
        Span span = this.helper.buildSpan("setTimeout");
        try {
            this.commands.setTimeout(timeout);
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    @Deprecated
    public void setTimeout(long timeout, TimeUnit unit) {
        Span span = this.helper.buildSpan("setTimeout");
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        try {
            this.commands.setTimeout(timeout, unit);
        }
        catch (Exception e) {
            TracingHelper.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public RedisFuture<String> clusterBumpepoch() {
        Span span = this.helper.buildSpan("clusterBumpepoch");
        return this.prepareRedisFuture(this.commands.clusterBumpepoch(), span);
    }

    public RedisFuture<String> clusterMeet(String ip, int port) {
        Span span = this.helper.buildSpan("clusterMeet");
        return this.prepareRedisFuture(this.commands.clusterMeet(ip, port), span);
    }

    public RedisFuture<String> clusterForget(String nodeId) {
        Span span = this.helper.buildSpan("clusterForget");
        span.setTag("nodeId", nodeId);
        return this.prepareRedisFuture(this.commands.clusterForget(nodeId), span);
    }

    public RedisFuture<String> clusterAddSlots(int ... slots) {
        Span span = this.helper.buildSpan("clusterAddSlots");
        span.setTag("slots", Arrays.toString(slots));
        return this.prepareRedisFuture(this.commands.clusterAddSlots(slots), span);
    }

    public RedisFuture<String> clusterDelSlots(int ... slots) {
        Span span = this.helper.buildSpan("clusterDelSlots");
        span.setTag("slots", Arrays.toString(slots));
        return this.prepareRedisFuture(this.commands.clusterDelSlots(slots), span);
    }

    public RedisFuture<String> clusterSetSlotNode(int slot, String nodeId) {
        Span span = this.helper.buildSpan("clusterSetSlotNode");
        span.setTag("slot", (Number)slot);
        span.setTag("nodeId", nodeId);
        return this.prepareRedisFuture(this.commands.clusterSetSlotNode(slot, nodeId), span);
    }

    public RedisFuture<String> clusterSetSlotStable(int slot) {
        Span span = this.helper.buildSpan("clusterSetSlotStable");
        span.setTag("slot", (Number)slot);
        return this.prepareRedisFuture(this.commands.clusterSetSlotStable(slot), span);
    }

    public RedisFuture<String> clusterSetSlotMigrating(int slot, String nodeId) {
        Span span = this.helper.buildSpan("clusterSetSlotMigrating");
        span.setTag("slot", (Number)slot);
        span.setTag("nodeId", nodeId);
        return this.prepareRedisFuture(this.commands.clusterSetSlotMigrating(slot, nodeId), span);
    }

    public RedisFuture<String> clusterSetSlotImporting(int slot, String nodeId) {
        Span span = this.helper.buildSpan("clusterSetSlotImporting");
        span.setTag("slot", (Number)slot);
        span.setTag("nodeId", nodeId);
        return this.prepareRedisFuture(this.commands.clusterSetSlotImporting(slot, nodeId), span);
    }

    public RedisFuture<String> clusterInfo() {
        Span span = this.helper.buildSpan("clusterInfo");
        return this.prepareRedisFuture(this.commands.clusterInfo(), span);
    }

    public RedisFuture<String> clusterMyId() {
        Span span = this.helper.buildSpan("clusterMyId");
        return this.prepareRedisFuture(this.commands.clusterMyId(), span);
    }

    public RedisFuture<String> clusterNodes() {
        Span span = this.helper.buildSpan("clusterNodes");
        return this.prepareRedisFuture(this.commands.clusterNodes(), span);
    }

    public RedisFuture<List<String>> clusterSlaves(String nodeId) {
        Span span = this.helper.buildSpan("clusterSlaves");
        span.setTag("nodeId", nodeId);
        return this.prepareRedisFuture(this.commands.clusterSlaves(nodeId), span);
    }

    public RedisFuture<List<K>> clusterGetKeysInSlot(int slot, int count) {
        Span span = this.helper.buildSpan("clusterGetKeysInSlot");
        span.setTag("slot", (Number)slot);
        return this.prepareRedisFuture(this.commands.clusterGetKeysInSlot(slot, count), span);
    }

    public RedisFuture<Long> clusterCountKeysInSlot(int slot) {
        Span span = this.helper.buildSpan("clusterCountKeysInSlot");
        span.setTag("slot", (Number)slot);
        return this.prepareRedisFuture(this.commands.clusterCountKeysInSlot(slot), span);
    }

    public RedisFuture<Long> clusterCountFailureReports(String nodeId) {
        Span span = this.helper.buildSpan("clusterCountFailureReports");
        span.setTag("nodeId", nodeId);
        return this.prepareRedisFuture(this.commands.clusterCountFailureReports(nodeId), span);
    }

    public RedisFuture<Long> clusterKeyslot(K key) {
        Span span = this.helper.buildSpan("clusterKeyslot", key);
        return this.prepareRedisFuture(this.commands.clusterKeyslot(key), span);
    }

    public RedisFuture<String> clusterSaveconfig() {
        Span span = this.helper.buildSpan("clusterSaveconfig");
        return this.prepareRedisFuture(this.commands.clusterSaveconfig(), span);
    }

    public RedisFuture<String> clusterSetConfigEpoch(long configEpoch) {
        Span span = this.helper.buildSpan("clusterSetConfigEpoch");
        return this.prepareRedisFuture(this.commands.clusterSetConfigEpoch(configEpoch), span);
    }

    public RedisFuture<List<Object>> clusterSlots() {
        Span span = this.helper.buildSpan("clusterSlots");
        return this.prepareRedisFuture(this.commands.clusterSlots(), span);
    }

    public RedisFuture<String> asking() {
        Span span = this.helper.buildSpan("asking");
        return this.prepareRedisFuture(this.commands.asking(), span);
    }

    public RedisFuture<String> clusterReplicate(String nodeId) {
        Span span = this.helper.buildSpan("clusterReplicate");
        span.setTag("nodeId", nodeId);
        return this.prepareRedisFuture(this.commands.clusterReplicate(nodeId), span);
    }

    public RedisFuture<String> clusterFailover(boolean force) {
        Span span = this.helper.buildSpan("clusterFailover");
        span.setTag("force", force);
        return this.prepareRedisFuture(this.commands.clusterFailover(force), span);
    }

    public RedisFuture<String> clusterReset(boolean hard) {
        Span span = this.helper.buildSpan("clusterReset");
        span.setTag("hard", hard);
        return this.prepareRedisFuture(this.commands.clusterReset(hard), span);
    }

    public RedisFuture<String> clusterFlushslots() {
        Span span = this.helper.buildSpan("clusterFlushslots");
        return this.prepareRedisFuture(this.commands.clusterFlushslots(), span);
    }

    public RedisFuture<Long> geoadd(K key, double longitude, double latitude, V member) {
        Span span = this.helper.buildSpan("geoadd", key);
        span.setTag("longitude", (Number)longitude);
        span.setTag("latitude", (Number)latitude);
        return this.prepareRedisFuture(this.commands.geoadd(key, longitude, latitude, member), span);
    }

    public RedisFuture<Long> geoadd(K key, Object ... lngLatMember) {
        Span span = this.helper.buildSpan("geoadd", key);
        return this.prepareRedisFuture(this.commands.geoadd(key, lngLatMember), span);
    }

    public RedisFuture<List<Value<String>>> geohash(K key, V ... members) {
        Span span = this.helper.buildSpan("geohash", key);
        return this.prepareRedisFuture(this.commands.geohash(key, (Object[])members), span);
    }

    public RedisFuture<Set<V>> georadius(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit) {
        Span span = this.helper.buildSpan("georadius", key);
        span.setTag("longitude", (Number)longitude);
        span.setTag("latitude", (Number)latitude);
        span.setTag("unit", TracingHelper.nullable((Object)unit));
        span.setTag("distance", (Number)distance);
        return this.prepareRedisFuture(this.commands.georadius(key, longitude, latitude, distance, unit), span);
    }

    public RedisFuture<List<GeoWithin<V>>> georadius(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit, GeoArgs geoArgs) {
        Span span = this.helper.buildSpan("georadius", key);
        span.setTag("longitude", (Number)longitude);
        span.setTag("latitude", (Number)latitude);
        span.setTag("unit", TracingHelper.nullable((Object)unit));
        span.setTag("distance", (Number)distance);
        return this.prepareRedisFuture(this.commands.georadius(key, longitude, latitude, distance, unit, geoArgs), span);
    }

    public RedisFuture<Long> georadius(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit, GeoRadiusStoreArgs<K> geoRadiusStoreArgs) {
        Span span = this.helper.buildSpan("georadius", key);
        span.setTag("longitude", (Number)longitude);
        span.setTag("latitude", (Number)latitude);
        span.setTag("unit", TracingHelper.nullable((Object)unit));
        span.setTag("distance", (Number)distance);
        return this.prepareRedisFuture(this.commands.georadius(key, longitude, latitude, distance, unit, geoRadiusStoreArgs), span);
    }

    public RedisFuture<Set<V>> georadiusbymember(K key, V member, double distance, GeoArgs.Unit unit) {
        Span span = this.helper.buildSpan("georadiusbymember", key);
        span.setTag("unit", TracingHelper.nullable((Object)unit));
        span.setTag("distance", (Number)distance);
        return this.prepareRedisFuture(this.commands.georadiusbymember(key, member, distance, unit), span);
    }

    public RedisFuture<List<GeoWithin<V>>> georadiusbymember(K key, V member, double distance, GeoArgs.Unit unit, GeoArgs geoArgs) {
        Span span = this.helper.buildSpan("georadiusbymember", key);
        span.setTag("unit", TracingHelper.nullable((Object)unit));
        span.setTag("distance", (Number)distance);
        return this.prepareRedisFuture(this.commands.georadiusbymember(key, member, distance, unit, geoArgs), span);
    }

    public RedisFuture<Long> georadiusbymember(K key, V member, double distance, GeoArgs.Unit unit, GeoRadiusStoreArgs<K> geoRadiusStoreArgs) {
        Span span = this.helper.buildSpan("georadiusbymember", key);
        span.setTag("unit", TracingHelper.nullable((Object)unit));
        span.setTag("distance", (Number)distance);
        return this.prepareRedisFuture(this.commands.georadiusbymember(key, member, distance, unit, geoRadiusStoreArgs), span);
    }

    public RedisFuture<List<GeoCoordinates>> geopos(K key, V ... members) {
        Span span = this.helper.buildSpan("geopos", key);
        return this.prepareRedisFuture(this.commands.geopos(key, (Object[])members), span);
    }

    public RedisFuture<Double> geodist(K key, V from, V to, GeoArgs.Unit unit) {
        Span span = this.helper.buildSpan("geodist", key);
        span.setTag("unit", TracingHelper.nullable((Object)unit));
        return this.prepareRedisFuture(this.commands.geodist(key, from, to, unit), span);
    }

    public RedisFuture<String> discard() {
        Span span = this.helper.buildSpan("discard");
        return this.prepareRedisFuture(this.commands.discard(), span);
    }

    public RedisFuture<TransactionResult> exec() {
        Span span = this.helper.buildSpan("exec");
        return this.prepareRedisFuture(this.commands.exec(), span);
    }

    public RedisFuture<String> multi() {
        Span span = this.helper.buildSpan("multi");
        return this.prepareRedisFuture(this.commands.multi(), span);
    }

    public RedisFuture<String> watch(K ... keys) {
        Span span = this.helper.buildSpan("watch", (Object[])keys);
        return this.prepareRedisFuture(this.commands.watch((Object[])keys), span);
    }

    public RedisFuture<String> unwatch() {
        Span span = this.helper.buildSpan("unwatch");
        return this.prepareRedisFuture(this.commands.unwatch(), span);
    }

    <V> RedisFuture<V> prepareRedisFuture(RedisFuture<V> future, Span span) {
        return this.continueScopeSpan(this.setCompleteAction(future, span));
    }

    private <V> RedisFuture<V> setCompleteAction(RedisFuture<V> future, Span span) {
        future.whenComplete((v, throwable) -> {
            if (throwable != null) {
                TracingHelper.onError((Throwable)throwable, (Span)span);
            }
            span.finish();
        });
        return future;
    }

    private <T> RedisFuture<T> continueScopeSpan(RedisFuture<T> redisFuture) {
        Tracer tracer = this.tracingConfiguration.getTracer();
        Span span = tracer.activeSpan();
        CompletableRedisFuture customRedisFuture = new CompletableRedisFuture(redisFuture);
        redisFuture.whenComplete((v, throwable) -> {
            try (Scope ignored = tracer.scopeManager().activate(span);){
                if (throwable != null) {
                    customRedisFuture.completeExceptionally((Throwable)throwable);
                } else {
                    customRedisFuture.complete(v);
                }
            }
        });
        return customRedisFuture;
    }
}

